/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.DirectDataBufferInt;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.loader.NativeLibraryLoader;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.WritableRasterNative;

public class NST {
    private static final Logger LOG = Logger.getInstance(NST.class);
    private static final String ourRegistryKeyTouchbar = "ide.mac.touchbar.use";
    private static NSTLibrary ourNSTLibrary = null;
    private static final String MIN_OS_VERSION = "10.12.2";

    static boolean isSupportedOS() {
        return SystemInfo.isMac && SystemInfo.isOsVersionAtLeast((String)MIN_OS_VERSION);
    }

    static NSTLibrary loadLibrary() {
        NativeLibraryLoader.loadPlatformLibrary((String)"nst");
        ourNSTLibrary = (NSTLibrary)Native.load((String)"nst", NSTLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
        return ourNSTLibrary;
    }

    public static boolean isAvailable() {
        return ourNSTLibrary != null;
    }

    public static ID createTouchBar(String name, NSTLibrary.ItemCreator creator, String escID) {
        return ourNSTLibrary.createTouchBar(name, creator, escID);
    }

    public static void releaseTouchBar(ID tbObj) {
        ourNSTLibrary.releaseTouchBar(tbObj);
    }

    public static void setTouchBar(TouchBar tb) {
        ourNSTLibrary.setTouchBar(tb == null ? ID.NIL : tb.getNativePeer());
    }

    public static void selectItemsToShow(ID tbObj, String[] ids, int count) {
        ourNSTLibrary.selectItemsToShow(tbObj, ids, count);
    }

    public static void setPrincipal(ID tbObj, String uid) {
        ourNSTLibrary.setPrincipal(tbObj, uid);
    }

    public static ID createButton(String uid, int buttWidth, int buttFlags, String text2, Icon icon, NSTLibrary.Action action2) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        Memory raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createButton(uid, buttWidth, buttFlags, text2, (Pointer)raster4ByteRGBA, w, h, action2);
    }

    public static ID createPopover(String uid, int itemWidth, String text2, Icon icon, ID tbObjExpand, ID tbObjTapAndHold) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        Memory raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createPopover(uid, itemWidth, text2, (Pointer)raster4ByteRGBA, w, h, tbObjExpand, tbObjTapAndHold);
    }

    public static ID createScrubber(String uid, int itemWidth, NSTLibrary.ScrubberDelegate delegate, NSTLibrary.ScrubberCacheUpdater updater, List<? extends TBItemScrubber.ItemData> items, int itemsCount) {
        Memory mem;
        ID scrubberNativePeer = ourNSTLibrary.createScrubber(uid, itemWidth, delegate, updater, mem, (mem = NST._packItems(items, 0, itemsCount)) == null ? 0 : (int)mem.size());
        return scrubberNativePeer;
    }

    public static ID createGroupItem(String uid, ID[] items) {
        return ourNSTLibrary.createGroupItem(uid, items == null || items.length == 0 ? null : items, items.length);
    }

    public static void updateButton(ID buttonObj, int updateOptions, int buttWidth, int buttonFlags, String text2, Icon icon, NSTLibrary.Action action2) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        Memory raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.updateButton(buttonObj, updateOptions, buttWidth, buttonFlags, text2, (Pointer)raster4ByteRGBA, w, h, action2);
    }

    public static void setArrowImage(ID buttObj, @Nullable Icon arrow) {
        BufferedImage img = NST._getImg4ByteRGBA(arrow);
        Memory raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.setArrowImage(buttObj, (Pointer)raster4ByteRGBA, w, h);
    }

    public static void updatePopover(ID popoverObj, int itemWidth, String text2, Icon icon, ID tbObjExpand, ID tbObjTapAndHold) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        Memory raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.updatePopover(popoverObj, itemWidth, text2, (Pointer)raster4ByteRGBA, w, h, tbObjExpand, tbObjTapAndHold);
    }

    public static void updateScrubber(ID scrubObj, int itemWidth, List<? extends TBItemScrubber.ItemData> items) {
        LOG.error("updateScrubber musn't be called");
    }

    private static Memory _makeIndices(Collection<Integer> indices) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        int step = Native.getNativeSize(Integer.class);
        Memory mem = new Memory((long)(indices.size() * step));
        int offset = 0;
        for (Integer i : indices) {
            mem.setInt((long)offset, i.intValue());
            offset += step;
        }
        return mem;
    }

    static void appendScrubberItems(ID scrubObj, List<? extends TBItemScrubber.ItemData> items, int fromIndex, int itemsCount) {
        Memory mem;
        ourNSTLibrary.appendScrubberItems(scrubObj, mem, (mem = NST._packItems(items, fromIndex, itemsCount)) == null ? 0 : (int)mem.size());
    }

    public static void enableScrubberItem(ID scrubObj, Collection<Integer> indices, boolean enabled) {
        if (indices == null || indices.isEmpty()) {
            return;
        }
        Memory mem = NST._makeIndices(indices);
        ourNSTLibrary.enableScrubberItems(scrubObj, mem, indices.size(), enabled);
    }

    public static void showScrubberItem(ID scrubObj, Collection<Integer> indices, boolean show) {
        if (indices == null || indices.isEmpty()) {
            return;
        }
        Memory mem = NST._makeIndices(indices);
        ourNSTLibrary.showScrubberItems(scrubObj, mem, indices.size(), show);
    }

    @Nullable
    private static Memory _packItems(List<? extends TBItemScrubber.ItemData> items, int fromIndex, int itemsCount) {
        if (items == null || itemsCount <= 0) {
            return null;
        }
        if (fromIndex < 0) {
            LOG.error("_packItems: fromIndex < 0 (" + fromIndex + ")");
            return null;
        }
        if (fromIndex + itemsCount > items.size()) {
            LOG.error("_packItems: fromIndex + itemsCount > items.size() (" + fromIndex + ", " + itemsCount + ", " + items.size() + ")");
            return null;
        }
        int byteCount = 4;
        for (int c2 = 0; c2 < itemsCount; ++c2) {
            TBItemScrubber.ItemData id = items.get(fromIndex + c2);
            byteCount += 4 + (id.getTextBytes() != null ? id.getTextBytes().length + 1 : 0);
            if (id.myIcon != null) {
                int w = Math.round((float)id.myIcon.getIconWidth() * id.fMulX);
                int h = Math.round((float)id.myIcon.getIconHeight() * id.fMulX);
                int sizeInBytes = w * h * 4;
                int totalSize = sizeInBytes + 8;
                byteCount += totalSize;
                continue;
            }
            byteCount += 4;
        }
        Memory result2 = new Memory((long)(byteCount + 200));
        result2.setInt(0L, itemsCount);
        int offset = 4;
        for (int c3 = 0; c3 < itemsCount; ++c3) {
            TBItemScrubber.ItemData id = items.get(fromIndex + c3);
            offset = NST._fill(id, result2, offset);
        }
        return result2;
    }

    private static int _fill(@NotNull TBItemScrubber.ItemData from, @NotNull Memory out, int offset) {
        if (from == null) {
            NST.$$$reportNull$$$0(0);
        }
        if (out == null) {
            NST.$$$reportNull$$$0(1);
        }
        if (from.getTextBytes() != null) {
            out.setInt((long)offset, from.getTextBytes().length);
            out.write((long)(offset += 4), from.getTextBytes(), 0, from.getTextBytes().length);
            out.setByte((long)(offset += from.getTextBytes().length), (byte)0);
            ++offset;
        } else {
            out.setInt((long)offset, 0);
            offset += 4;
        }
        if (from.myIcon != null) {
            offset += NST._writeIconRaster(from.myIcon, from.fMulX, out, offset);
        } else {
            out.setInt((long)offset, 0);
            out.setInt((long)(offset + 4), 0);
            offset += 8;
        }
        return offset;
    }

    private static Memory _getRaster(BufferedImage img) {
        if (img == null) {
            return null;
        }
        DataBuffer db = img.getRaster().getDataBuffer();
        DirectDataBufferInt dbb = (DirectDataBufferInt)db;
        return dbb.myMemory;
    }

    private static int _getImgW(BufferedImage img) {
        return img == null ? 0 : img.getWidth();
    }

    private static int _getImgH(BufferedImage img) {
        return img == null ? 0 : img.getHeight();
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon, float scale) {
        if (icon == null) {
            return null;
        }
        int w = Math.round((float)icon.getIconWidth() * scale);
        int h = Math.round((float)icon.getIconHeight() * scale);
        Memory memory = new Memory((long)(w * h * 4));
        return NST._drawIconIntoMemory(icon, scale, memory, 0);
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon) {
        if (icon == null || icon.getIconHeight() == 0) {
            return null;
        }
        Application app = ApplicationManager.getApplication();
        float fMulX = app != null && UISettings.getInstance().getPresentationMode() ? 40.0f / (float)icon.getIconHeight() : (icon.getIconHeight() < 24 ? 2.5f : 44.0f / (float)icon.getIconHeight());
        return NST._getImg4ByteRGBA(icon, fMulX);
    }

    private static int _writeIconRaster(@NotNull Icon icon, float scale, @NotNull Memory memory, int offset) {
        if (icon == null) {
            NST.$$$reportNull$$$0(2);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(3);
        }
        int w = Math.round((float)icon.getIconWidth() * scale);
        int h = Math.round((float)icon.getIconHeight() * scale);
        int rasterSizeInBytes = w * h * 4;
        int totalSize = rasterSizeInBytes + 8;
        if (memory.size() - (long)offset < (long)totalSize) {
            LOG.error("insufficient size of allocated memory: avail " + (memory.size() - (long)offset) + ", needs " + totalSize);
            return 0;
        }
        memory.setInt((long)offset, w);
        memory.setInt((long)(offset += 4), h);
        NST._drawIconIntoMemory(icon, scale, memory, offset += 4);
        return totalSize;
    }

    private static BufferedImage _drawIconIntoMemory(@NotNull Icon icon, float scale, @NotNull Memory memory, int offset) {
        if (icon == null) {
            NST.$$$reportNull$$$0(4);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(5);
        }
        int w = Math.round((float)icon.getIconWidth() * scale);
        int h = Math.round((float)icon.getIconHeight() * scale);
        int rasterSizeInBytes = w * h * 4;
        memory.setMemory((long)offset, (long)rasterSizeInBytes, (byte)0);
        DirectDataBufferInt dataBuffer = new DirectDataBufferInt(memory, offset);
        DirectColorModel colorModel = new DirectColorModel(ColorModel.getRGBdefault().getColorSpace(), 32, 255, 65280, 0xFF0000, -16777216, false, 3);
        SampleModel sm = colorModel.createCompatibleSampleModel(w, h);
        WritableRasterNative raster = WritableRasterNative.createNativeRaster(sm, dataBuffer);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        g.setComposite(AlphaComposite.SrcOver);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    static {
        try {
            block23: {
                if (!NST.isSupportedOS()) {
                    LOG.info("OS doesn't support touchbar, skip nst loading");
                } else if (GraphicsEnvironment.isHeadless()) {
                    LOG.info("The graphics environment is headless, skip nst loading");
                } else if (!Registry.is((String)ourRegistryKeyTouchbar, (boolean)false)) {
                    LOG.info("registry key 'ide.mac.touchbar.use' is disabled, skip nst loading");
                } else if (!JnaLoader.isLoaded()) {
                    LOG.info("JNA library is unavailable, skip nst loading");
                } else if (!Utils.isTouchBarServerRunning()) {
                    LOG.info("touchbar-server isn't running, skip nst loading");
                } else {
                    try {
                        NST.loadLibrary();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to load nst library for touchbar: ", e);
                    }
                    if (ourNSTLibrary != null) {
                        try {
                            ID test = ourNSTLibrary.createTouchBar("test", uid -> ID.NIL, null);
                            if (test == null || test == ID.NIL) {
                                LOG.error("Failed to create native touchbar object, result is null");
                                ourNSTLibrary = null;
                                break block23;
                            }
                            ourNSTLibrary.releaseTouchBar(test);
                            LOG.info("nst library works properly, successfully created and released native touchbar object");
                        }
                        catch (Throwable e) {
                            LOG.error("nst library was loaded, but can't be used: ", e);
                            ourNSTLibrary = null;
                        }
                    } else {
                        LOG.error("nst library wasn't loaded");
                    }
                }
            }
            if (ourNSTLibrary != null) {
                String appId = Utils.getAppId();
                if (appId == null || appId.isEmpty()) {
                    LOG.debug("can't obtain application id from NSBundle");
                } else if (NSDefaults.isShowFnKeysEnabled((String)appId)) {
                    LOG.info("nst library was loaded, but user enabled fn-keys in touchbar");
                    ourNSTLibrary = null;
                }
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/NST";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "_fill";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "_writeIconRaster";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "_drawIconIntoMemory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

