/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.SplashManager;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

public final class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static List<Image> ourIcons = null;
    private static volatile boolean ourMacDocIconSet = false;
    private static final int MIN_ICON_SIZE = 32;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(AppUIUtil.class);
        if (logger == null) {
            AppUIUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void updateWindowIcon(@NotNull Window window) {
        if (window == null) {
            AppUIUtil.$$$reportNull$$$0(1);
        }
        if (AppUIUtil.isWindowIconAlreadyExternallySet()) {
            return;
        }
        List<Image> images = ourIcons;
        if (images == null) {
            String fallback;
            ourIcons = images = new ArrayList<Image>(3);
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            String svgIconUrl = appInfo.getApplicationSvgIconUrl();
            String smallSvgIconUrl = appInfo.getSmallApplicationSvgIconUrl();
            ScaleContext ctx = ScaleContext.create((Component)window);
            if (SystemInfo.isUnix) {
                fallback = appInfo.getBigIconUrl();
                ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadApplicationIconImage(svgIconUrl, ctx, 128, fallback));
            }
            fallback = appInfo.getIconUrl();
            ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadApplicationIconImage(smallSvgIconUrl, ctx, 32, fallback));
            if (SystemInfo.isWindows) {
                ContainerUtil.addIfNotNull(images, (Object)AppUIUtil.loadSmallApplicationIconImage(ctx, 16));
            }
            for (int i = 0; i < images.size(); ++i) {
                Image image = images.get(i);
                if (!(image instanceof JBHiDPIScaledImage)) continue;
                images.set(i, ((JBHiDPIScaledImage)image).getDelegate());
            }
        }
        if (!images.isEmpty()) {
            if (!SystemInfo.isMac) {
                window.setIconImages(images);
            } else if (!ourMacDocIconSet && PluginManagerCore.isRunningFromSources()) {
                AppIcon.MacAppIcon.setDockIcon(ImageUtil.toBufferedImage((Image)images.get(0)));
                ourMacDocIconSet = true;
            }
        }
    }

    public static boolean isWindowIconAlreadyExternallySet() {
        if (SystemInfo.isMac) {
            return ourMacDocIconSet || !PluginManagerCore.isRunningFromSources();
        }
        return SystemInfo.isWindows && Boolean.getBoolean("ide.native.launcher") && Boolean.getBoolean("jbre.win.app.icon.supported");
    }

    @NotNull
    private static Image loadSmallApplicationIconImage(@NotNull ScaleContext ctx, int size) {
        if (ctx == null) {
            AppUIUtil.$$$reportNull$$$0(2);
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String fallbackSmallIconUrl = appInfo.getSmallIconUrl();
        Image image = AppUIUtil.loadApplicationIconImage(appInfo.getSmallApplicationSvgIconUrl(), ctx, size, fallbackSmallIconUrl);
        if (image == null) {
            AppUIUtil.$$$reportNull$$$0(3);
        }
        return image;
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext ctx) {
        if (ctx == null) {
            AppUIUtil.$$$reportNull$$$0(4);
        }
        Image image = AppUIUtil.loadSmallApplicationIconImage(ctx, 16);
        JBImageIcon jBImageIcon = new JBImageIcon(image);
        if (jBImageIcon == null) {
            AppUIUtil.$$$reportNull$$$0(5);
        }
        return jBImageIcon;
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext ctx, int size) {
        if (ctx == null) {
            AppUIUtil.$$$reportNull$$$0(6);
        }
        Image image = AppUIUtil.loadSmallApplicationIconImage(ctx, size);
        JBImageIcon jBImageIcon = new JBImageIcon(image);
        if (jBImageIcon == null) {
            AppUIUtil.$$$reportNull$$$0(7);
        }
        return jBImageIcon;
    }

    @Contract(value="_, _, _, !null -> !null")
    @Nullable
    private static Image loadApplicationIconImage(String svgPath, ScaleContext ctx, int size, String fallbackPath) {
        if (svgPath != null) {
            Icon icon = IconLoader.findIcon((String)svgPath);
            if (icon != null) {
                int width = icon.getIconWidth();
                float scale = (float)size / (float)width;
                icon = IconUtil.scale((Icon)icon, null, (float)scale);
                return IconUtil.toImage((Icon)icon, (ScaleContext)ctx);
            }
            AppUIUtil.getLogger().info("Cannot load SVG application icon from " + svgPath);
        }
        if (fallbackPath != null) {
            return ImageLoader.loadFromResource((String)fallbackPath);
        }
        return null;
    }

    public static void invokeLaterIfProjectAlive(@NotNull Project project, @NotNull Runnable runnable2) {
        Application application;
        if (project == null) {
            AppUIUtil.$$$reportNull$$$0(8);
        }
        if (runnable2 == null) {
            AppUIUtil.$$$reportNull$$$0(9);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, o -> !project.isOpen() || project.isDisposed());
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    public static void invokeOnEdt(Runnable runnable2, @Nullable Condition<?> expired) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass(@NotNull Toolkit toolkit) {
        if (toolkit == null) {
            AppUIUtil.$$$reportNull$$$0(10);
        }
        if (SystemInfo.isWindows || SystemInfo.isMac) {
            return;
        }
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("update frame class");
        try {
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        activity.end();
    }

    public static String getFrameClass() {
        String wmClass;
        String name = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getFullProductNameWithEdition()).replace(' ', '-').replace("intellij-idea", "idea").replace("android-studio", "studio").replace("-community-edition", "-ce").replace("-ultimate-edition", "").replace("-professional-edition", "");
        String string = wmClass = name.startsWith(VENDOR_PREFIX) ? name : VENDOR_PREFIX + name;
        if (PluginManagerCore.isRunningFromSources()) {
            wmClass = wmClass + "-debug";
        }
        return wmClass;
    }

    private static void registerFont(@NotNull String name, @Nullable File fontDir) {
        if (name == null) {
            AppUIUtil.$$$reportNull$$$0(11);
        }
        try {
            Font font;
            if (fontDir == null) {
                URL url = AppUIUtil.class.getResource("/fonts/" + name);
                if (url == null) {
                    AppUIUtil.getLogger().warn("Resource missing: " + name);
                    return;
                }
                try (InputStream is = url.openStream();){
                    font = Font.createFont(0, is);
                }
            } else {
                font = Font.createFont(0, new File(fontDir, name));
            }
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Throwable t) {
            AppUIUtil.getLogger().warn("Cannot register font: " + name, t);
        }
    }

    public static void hideToolWindowBalloon(@NotNull String id, @NotNull Project project) {
        if (id == null) {
            AppUIUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AppUIUtil.$$$reportNull$$$0(13);
        }
        AppUIUtil.invokeLaterIfProjectAlive(project, () -> {
            Balloon balloon = ToolWindowManager.getInstance((Project)project).getToolWindowBalloon(id);
            if (balloon != null) {
                balloon.hide();
            }
        });
    }

    @Nullable
    public static String findIcon() {
        String[] childFiles;
        String iconsPath = PathManager.getBinPath();
        for (String child2 : childFiles = (String[])ObjectUtils.notNull((Object)new File(iconsPath).list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)) {
            if (!child2.endsWith(".svg")) continue;
            return iconsPath + '/' + child2;
        }
        File svgFile = ApplicationInfoEx.getInstanceEx().getApplicationSvgIconFile();
        if (svgFile != null) {
            return svgFile.getAbsolutePath();
        }
        int best = 31;
        String iconPath = null;
        for (String child3 : childFiles) {
            String path;
            ImageIcon icon;
            int size;
            if (!child3.endsWith(".png") || (size = (icon = new ImageIcon(path = iconsPath + '/' + child3)).getIconHeight()) <= best || size != icon.getIconWidth()) continue;
            best = size;
            iconPath = path;
        }
        return iconPath;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean showConsentsAgreementIfNeed(@NotNull Logger log2) {
        if (log2 == null) {
            AppUIUtil.$$$reportNull$$$0(14);
        }
        return AppUIUtil.showConsentsAgreementIfNeeded(log2);
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Logger log2) {
        if (log2 == null) {
            AppUIUtil.$$$reportNull$$$0(15);
        }
        return AppUIUtil.showConsentsAgreementIfNeeded((Runnable command) -> {
            if (EventQueue.isDispatchThread()) {
                command.run();
            } else {
                try {
                    EventQueue.invokeAndWait(command);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    log2.warn((Throwable)e);
                }
            }
        });
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Executor edtExecutor) {
        if (edtExecutor == null) {
            AppUIUtil.$$$reportNull$$$0(16);
        }
        Pair<List<Consent>, Boolean> consentsToShow = ConsentOptions.getInstance().getConsents();
        Ref result2 = new Ref((Object)Boolean.FALSE);
        if (((Boolean)consentsToShow.second).booleanValue()) {
            edtExecutor.execute(() -> result2.set((Object)AppUIUtil.confirmConsentOptions((List)consentsToShow.first)));
        }
        return (Boolean)result2.get();
    }

    public static void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    public static void showEndUserAgreementText(final @NotNull String htmlText, final boolean isPrivacyPolicy) {
        if (htmlText == null) {
            AppUIUtil.$$$reportNull$$$0(17);
        }
        DialogWrapper dialog2 = new DialogWrapper(true){
            private JEditorPane myViewer;

            protected JComponent createCenterPanel() {
                JPanel centerPanel2 = new JPanel(new BorderLayout(0, JBUIScale.scale((int)8)));
                this.myViewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                this.myViewer.setFocusable(true);
                this.myViewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        URL url = e.getURL();
                        if (url != null) {
                            BrowserUtil.browse((URL)url);
                        } else {
                            SwingHelper.scrollToReference(myViewer, e.getDescription());
                        }
                    }
                });
                this.myViewer.setText(htmlText);
                StyleSheet styleSheet = ((HTMLDocument)this.myViewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUIScale.scaleFontSize((float)13.0f) + "pt;}");
                styleSheet.addRule("h2, em {margin-top:" + JBUIScale.scaleFontSize((float)20.0f) + "pt;}");
                styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
                styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
                styleSheet.addRule("li {margin-bottom:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
                styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)13.0f) + "pt;}");
                this.myViewer.setCaretPosition(0);
                this.myViewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                centerPanel2.add((Component)JBUI.Borders.emptyTop((int)8).wrap((JComponent)new JLabel("Please read and accept these terms and conditions. Scroll down for full text:")), "North");
                JBScrollPane scrollPane = new JBScrollPane((Component)this.myViewer, 20, 31);
                centerPanel2.add((Component)scrollPane, "Center");
                JPanel bottomPanel = new JPanel(new BorderLayout());
                if (ApplicationInfoImpl.getShadowInstance().isEAP()) {
                    JPanel eapPanel = new JPanel(new BorderLayout(8, 8));
                    eapPanel.setBorder(JBUI.Borders.empty((int)8));
                    eapPanel.setBackground(new Color(14476520));
                    JLabel label2 = new JLabel(AllIcons.General.BalloonInformation);
                    label2.setVerticalAlignment(1);
                    eapPanel.add((Component)label2, "West");
                    JEditorPane html = SwingHelper.createHtmlLabel("EAP builds report usage statistics by default per " + (isPrivacyPolicy ? "this Privacy Policy." : "the <a href=\"https://www.jetbrains.com/company/privacy.html\">JetBrains Privacy Policy</a>.") + "<br/>No personal or sensitive data are sent. You may disable this in the settings.", null, null);
                    eapPanel.add((Component)html, "Center");
                    bottomPanel.add((Component)eapPanel, "North");
                }
                JCheckBox checkBox2 = new JCheckBox("I confirm that I have read and accept the terms of this User Agreement");
                bottomPanel.add((Component)JBUI.Borders.empty((int)24, (int)0, (int)16, (int)0).wrap((JComponent)checkBox2), "Center");
                centerPanel2.add((Component)JBUI.Borders.emptyTop((int)8).wrap((JComponent)bottomPanel), "South");
                checkBox2.addActionListener(e -> this.setOKActionEnabled(checkBox2.isSelected()));
                centerPanel2.setPreferredSize((Dimension)JBUI.size((int)520, (int)450));
                return centerPanel2;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myViewer;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setOKButtonText("Continue");
                this.setOKActionEnabled(false);
                this.setCancelButtonText("Reject and Exit");
                this.setAutoAdjustable(false);
            }

            public void doCancelAction() {
                super.doCancelAction();
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    System.exit(11);
                } else {
                    ((ApplicationImpl)application).exit(true, true, false);
                }
            }
        };
        dialog2.setModal(true);
        dialog2.setTitle(isPrivacyPolicy ? ApplicationInfoImpl.getShadowInstance().getShortCompanyName() + " Privacy Policy" : ApplicationNamesInfo.getInstance().getFullProductName() + " User Agreement");
        dialog2.pack();
        SplashManager.executeWithHiddenSplash(dialog2.getWindow(), () -> dialog2.show());
    }

    public static boolean confirmConsentOptions(final @NotNull List<Consent> consents) {
        List<Consent> result2;
        if (consents == null) {
            AppUIUtil.$$$reportNull$$$0(18);
        }
        if (consents.isEmpty()) {
            return false;
        }
        final ConsentSettingsUi ui = new ConsentSettingsUi(false);
        DialogWrapper dialog2 = new DialogWrapper(true){

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                JComponent southPanel = super.createSouthPanel();
                if (southPanel != null) {
                    southPanel.setBorder(ourDefaultBorder);
                }
                return southPanel;
            }

            protected JComponent createCenterPanel() {
                return ui.getComponent();
            }

            @NotNull
            protected Action[] createActions() {
                if (consents.size() > 1) {
                    Action[] actions = super.createActions();
                    this.setOKButtonText("Save");
                    this.setCancelButtonText("Skip");
                    if (actions == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return actions;
                }
                this.setOKButtonText(((Consent)consents.iterator().next()).getName());
                Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction("Don't send"){

                    protected void doAction(ActionEvent e) {
                        this.close(2);
                    }
                }};
                if (actionArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionArray;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setAutoAdjustable(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppUIUtil$2", "createActions"));
            }
        };
        ui.reset(consents);
        dialog2.setModal(true);
        dialog2.setTitle("Data Sharing");
        dialog2.pack();
        if (consents.size() < 2) {
            dialog2.setSize(dialog2.getWindow().getWidth(), dialog2.getWindow().getHeight() + JBUIScale.scale((int)75));
        }
        dialog2.show();
        int exitCode = dialog2.getExitCode();
        if (exitCode == 1) {
            return false;
        }
        if (consents.size() == 1) {
            result2 = Collections.singletonList(consents.iterator().next().derive(exitCode == 0));
        } else {
            result2 = new ArrayList<Consent>();
            ui.apply(result2);
        }
        AppUIUtil.saveConsents(result2);
        return true;
    }

    public static List<Consent> loadConsentsForEditing() {
        Consent statConsent;
        ConsentOptions options = ConsentOptions.getInstance();
        ArrayList<Consent> result2 = (ArrayList<Consent>)options.getConsents().first;
        if (options.isEAP() && (statConsent = options.getUsageStatsConsent()) != null) {
            ArrayList<Consent> consents = result2;
            result2 = new ArrayList<Consent>();
            result2.add(statConsent.derive(UsageStatisticsPersistenceComponent.getInstance().isAllowed()));
            result2.addAll(consents);
        }
        return result2;
    }

    public static void saveConsents(List<Consent> consents) {
        Consent defaultStatsConsent;
        ConsentOptions options = ConsentOptions.getInstance();
        Application app = ApplicationManager.getApplication();
        List<Consent> toSave = consents;
        if (app != null && options.isEAP() && (defaultStatsConsent = options.getUsageStatsConsent()) != null) {
            toSave = new ArrayList<Consent>();
            for (Consent consent : consents) {
                if (defaultStatsConsent.getId().equals(consent.getId())) {
                    UsageStatisticsPersistenceComponent.getInstance().setAllowed(consent.isAccepted());
                    continue;
                }
                toSave.add(consent);
            }
        }
        if (!toSave.isEmpty()) {
            options.setConsents(toSave);
        }
    }

    public static void targetToDevice(@NotNull Component comp, @Nullable Component target2) {
        if (comp == null) {
            AppUIUtil.$$$reportNull$$$0(19);
        }
        if (comp.isShowing()) {
            return;
        }
        GraphicsConfiguration gc = target2 != null ? target2.getGraphicsConfiguration() : null;
        AppUIUtil.setGraphicsConfiguration(comp, gc);
    }

    public static void setGraphicsConfiguration(@NotNull Component comp, @Nullable GraphicsConfiguration gc) {
        if (comp == null) {
            AppUIUtil.$$$reportNull$$$0(20);
        }
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AppUIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AppUIUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSmallApplicationIconImage";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSmallApplicationIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateWindowIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadSmallApplicationIconImage";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadSmallApplicationIcon";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfProjectAlive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerFont";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hideToolWindowBalloon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showConsentsAgreementIfNeed";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showConsentsAgreementIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showEndUserAgreementText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "confirmConsentOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "targetToDevice";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setGraphicsConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

