/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.DisposableWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalStarter;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable,
DataProvider {
    public static final DataKey<String> SELECTED_TEXT_DATA_KEY = DataKey.create((String)(JBTerminalWidget.class.getName() + " selected text"));
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private JBTerminalWidgetListener myListener;
    private JBTerminalWidgetDisposableWrapper myDisposableWrapper;
    private VirtualFile myVirtualFile;
    private String myCommandHistoryFilePath;

    public JBTerminalWidget(Project project, JBTerminalSystemSettingsProviderBase settingsProvider, Disposable parent) {
        this(project, 80, 24, settingsProvider, parent);
    }

    public JBTerminalWidget(Project project, int columns, int lines, JBTerminalSystemSettingsProviderBase settingsProvider, Disposable parent) {
        super(columns, lines, (SettingsProvider)settingsProvider);
        this.mySettingsProvider = settingsProvider;
        this.setName("terminal");
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            for (Filter filter : eachProvider.getDefaultFilters(project)) {
                this.addMessageFilter(project, filter);
            }
        }
        this.myDisposableWrapper = new JBTerminalWidgetDisposableWrapper(this, parent);
    }

    public JBTerminalWidgetListener getListener() {
        return this.myListener;
    }

    public void setListener(JBTerminalWidgetListener listener2) {
        this.myListener = listener2;
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(0);
        }
        if (styleState == null) {
            JBTerminalWidget.$$$reportNull$$$0(1);
        }
        if (textBuffer == null) {
            JBTerminalWidget.$$$reportNull$$$0(2);
        }
        JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel2);
        return panel2;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new JBTerminalStarter((Terminal)terminal, connector);
    }

    protected JScrollBar createScrollBar() {
        JBScrollBar bar = new JBScrollBar();
        bar.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar.putClientProperty((Object)JBScrollBar.TRACK, (g, x, y, width, height, object) -> {
            SubstringFinder.FindResult result2 = this.myTerminalPanel.getFindResult();
            if (result2 != null) {
                int modelHeight = bar.getModel().getMaximum() - bar.getModel().getMinimum();
                Color color = this.mySettingsProvider.getTerminalColorPalette().getColor(this.mySettingsProvider.getFoundPatternColor().getBackground());
                g.setColor(color);
                int anchorHeight = Math.max(2, height / modelHeight);
                for (SubstringFinder.FindResult.FindItem r : result2.getItems()) {
                    int where = height * r.getStart().y / modelHeight;
                    g.fillRect(x, y + where, width, anchorHeight);
                }
            }
        });
        return bar;
    }

    public List<TerminalAction> getActions() {
        List actions = super.getActions();
        if (this.isInTerminalToolWindow()) {
            actions.add(new TerminalAction("New Session", this.mySettingsProvider.getNewSessionKeyStrokes(), input -> {
                this.myListener.onNewSession();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction("Select Previous Tab", this.mySettingsProvider.getPreviousTabKeyStrokes(), input -> {
                this.myListener.onPreviousTabSelected();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction("Select Next Tab", this.mySettingsProvider.getNextTabKeyStrokes(), input -> {
                this.myListener.onNextTabSelected();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction("Move Right", this.mySettingsProvider.getMoveTabRightKeyStrokes(), input -> {
                this.myListener.moveTabRight();
                return true;
            }).withMnemonicKey(Integer.valueOf(82)).withEnabledSupplier(() -> this.myListener != null && this.myListener.canMoveTabRight()));
            actions.add(new TerminalAction("Move Left", this.mySettingsProvider.getMoveTabLeftKeyStrokes(), input -> {
                this.myListener.moveTabLeft();
                return true;
            }).withMnemonicKey(Integer.valueOf(76)).withEnabledSupplier(() -> this.myListener != null && this.myListener.canMoveTabLeft()));
            actions.add(new TerminalAction("Show Tabs", this.mySettingsProvider.getShowTabsKeyStrokes(), input -> {
                this.myListener.showTabs();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
            actions.add(new TerminalAction("Close Session", this.mySettingsProvider.getCloseSessionKeyStrokes(), input -> {
                this.myListener.onSessionClosed();
                return true;
            }).withMnemonicKey(Integer.valueOf(84)).withEnabledSupplier(() -> this.myListener != null));
        }
        return actions;
    }

    private boolean isInTerminalToolWindow() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myTerminalPanel);
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        return toolWindow instanceof ToolWindowImpl && "Terminal".equals(((ToolWindowImpl)toolWindow).getId());
    }

    public void dispose() {
        this.close();
    }

    protected JediTermWidget.SearchComponent createSearchComponent() {
        return new JediTermWidget.SearchComponent(){
            private final SearchTextField myTextField = new SearchTextField(false);

            public String getText() {
                return this.myTextField.getText();
            }

            public boolean ignoreCase() {
                return false;
            }

            public JComponent getComponent() {
                this.myTextField.setOpaque(false);
                return this.myTextField;
            }

            public void addDocumentChangeListener(DocumentListener listener2) {
                this.myTextField.addDocumentListener(listener2);
            }

            public void addKeyListener(KeyListener listener2) {
                this.myTextField.addKeyboardListener(listener2);
            }

            public void addIgnoreCaseListener(ItemListener listener2) {
            }

            public void onResultUpdated(SubstringFinder.FindResult result2) {
            }

            public void nextFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }

            public void prevFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }
        };
    }

    public void addMessageFilter(Project project, Filter filter) {
        this.addHyperlinkFilter(line2 -> {
            Filter.Result r = filter.applyFilter(line2, line2.length());
            if (r != null) {
                return new LinkResult(ContainerUtil.map((Collection)r.getResultItems(), item -> new LinkResultItem(item.getHighlightStartOffset(), item.getHighlightEndOffset(), new LinkInfo(() -> item.getHyperlinkInfo().navigate(project)))));
            }
            return null;
        });
    }

    public void runFilters(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(3);
        }
        ReadAction.run(() -> runnable2.run());
    }

    public void start(TtyConnector connector) {
        this.setTtyConnector(connector);
        this.start();
    }

    public JBTerminalSystemSettingsProviderBase getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public void moveDisposable(@NotNull Disposable newParent) {
        if (newParent == null) {
            JBTerminalWidget.$$$reportNull$$$0(4);
        }
        this.myDisposableWrapper = (JBTerminalWidgetDisposableWrapper)this.myDisposableWrapper.moveTo(newParent);
    }

    public void setVirtualFile(@Nullable VirtualFile virtualFile) {
        if (this.myVirtualFile != null && virtualFile != null) {
            throw new IllegalStateException("assigning a second virtual file to a terminal widget");
        }
        this.myVirtualFile = virtualFile;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void notifyStarted() {
        if (this.myListener != null) {
            this.myListener.onTerminalStarted();
        }
    }

    @Nullable
    public String getCommandHistoryFilePath() {
        return this.myCommandHistoryFilePath;
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            JBTerminalWidget.$$$reportNull$$$0(5);
        }
        if (SELECTED_TEXT_DATA_KEY.is(dataId)) {
            return this.getSelectedText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getSelectedText() {
        TerminalPanel terminalPanel = this.getTerminalPanel();
        TerminalSelection selection = terminalPanel.getSelection();
        if (selection != null) {
            Pair points = selection.pointsForRun(terminalPanel.getColumnCount());
            if (points.first != null && points.second != null) {
                TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
                buffer.lock();
                try {
                    String string = SelectionUtil.getSelectionText((Point)((Point)points.first), (Point)((Point)points.second), (TerminalTextBuffer)buffer);
                    return string;
                }
                finally {
                    buffer.unlock();
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBuffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/JBTerminalWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTerminalPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runFilters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "moveDisposable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JBTerminalWidgetDisposableWrapper
    extends DisposableWrapper<JBTerminalWidget> {
        private final JBTerminalWidget myObject;

        private JBTerminalWidgetDisposableWrapper(JBTerminalWidget object, Disposable parent) {
            super((Disposable)object, parent);
            this.myObject = object;
        }

        public void dispose() {
            VirtualFile virtualFile = this.myObject.getVirtualFile();
            if (virtualFile != null && virtualFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) != null) {
                return;
            }
            super.dispose();
        }

        @NotNull
        protected JBTerminalWidgetDisposableWrapper createNewWrapper(JBTerminalWidget object, @NotNull Disposable parent) {
            if (parent == null) {
                JBTerminalWidgetDisposableWrapper.$$$reportNull$$$0(0);
            }
            JBTerminalWidgetDisposableWrapper jBTerminalWidgetDisposableWrapper = new JBTerminalWidgetDisposableWrapper(object, parent);
            if (jBTerminalWidgetDisposableWrapper == null) {
                JBTerminalWidgetDisposableWrapper.$$$reportNull$$$0(1);
            }
            return jBTerminalWidgetDisposableWrapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/JBTerminalWidget$JBTerminalWidgetDisposableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/JBTerminalWidget$JBTerminalWidgetDisposableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewWrapper";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

