/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordAtCaretAction
extends TextComponentEditorAction
implements DumbAware {
    public SelectWordAtCaretAction() {
        super(new DefaultHandler());
        this.setInjectedContext(true);
    }

    public static class Handler
    extends EditorActionHandler {
        private final EditorActionHandler myDefaultHandler;

        public Handler(EditorActionHandler defaultHandler) {
            super(true);
            this.myDefaultHandler = defaultHandler;
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            if (guide != null && !caret.hasSelection() && Handler.isWhitespaceAtCaret(caret)) {
                Handler.selectWithGuide(caret, guide);
            } else {
                this.myDefaultHandler.execute(editor, caret, dataContext);
            }
        }

        private static boolean isWhitespaceAtCaret(Caret caret) {
            Document doc = caret.getEditor().getDocument();
            int offset = caret.getOffset();
            if (offset >= doc.getTextLength()) {
                return false;
            }
            char c2 = doc.getCharsSequence().charAt(offset);
            return c2 == ' ' || c2 == '\t' || c2 == '\n';
        }

        private static void selectWithGuide(Caret caret, IndentGuideDescriptor guide) {
            Editor editor = caret.getEditor();
            Document doc = editor.getDocument();
            int startOffset = editor.logicalPositionToOffset(new LogicalPosition(guide.startLine, 0));
            int endOffset = guide.endLine >= doc.getLineCount() ? doc.getTextLength() : doc.getLineStartOffset(guide.endLine);
            VirtualFile file2 = ((EditorEx)editor).getVirtualFile();
            if (file2 != null) {
                CharSequence chars = doc.getCharsSequence();
                int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t\n");
                HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(nonWhitespaceOffset);
                if (BraceMatchingUtil.isRBraceToken(iterator, chars, file2.getFileType()) && editor.offsetToLogicalPosition((int)iterator.getStart()).column == guide.indentLevel) {
                    endOffset = iterator.getEnd();
                    if ((endOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)endOffset, (String)" \t")) < chars.length() && chars.charAt(endOffset) == '\n') {
                        ++endOffset;
                    }
                }
            }
            caret.setSelection(startOffset, endOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/SelectWordAtCaretAction$Handler", "doExecute"));
        }
    }

    private static class DefaultHandler
    extends EditorActionHandler {
        private DefaultHandler() {
            super(true);
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                DefaultHandler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            Document document = editor.getDocument();
            if (EditorUtil.isPasswordEditor(editor)) {
                caret.setSelection(0, document.getTextLength());
                return;
            }
            int lineNumber = caret.getLogicalPosition().line;
            int caretOffset = caret.getOffset();
            if (lineNumber >= document.getLineCount()) {
                return;
            }
            boolean camel = editor.getSettings().isCamelWords();
            ArrayList<TextRange> ranges2 = new ArrayList<TextRange>();
            int textLength = document.getTextLength();
            if (caretOffset == textLength) {
                --caretOffset;
            }
            if (caretOffset < 0) {
                return;
            }
            SelectWordUtil.addWordOrLexemeSelection(camel, editor, caretOffset, ranges2);
            int line2 = document.getLineNumber(caretOffset);
            ranges2.add(new TextRange(document.getLineStartOffset(line2), document.getLineEndOffset(line2)));
            if (ranges2.isEmpty()) {
                return;
            }
            TextRange selectionRange = new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
            TextRange minimumRange = new TextRange(0, document.getTextLength());
            for (TextRange range2 : ranges2) {
                if (!range2.contains(selectionRange) || range2.equals((Object)selectionRange) || !minimumRange.contains(range2)) continue;
                minimumRange = range2;
            }
            caret.setSelection(minimumRange.getStartOffset(), minimumRange.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/SelectWordAtCaretAction$DefaultHandler", "doExecute"));
        }
    }
}

