/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileCustomWhiteListRule
extends CustomWhiteListRule {
    private static final Logger LOG = Logger.getInstance(LocalFileCustomWhiteListRule.class);
    private WeakReference<CachedWhitelistedItems> myWhitelistRef;
    private final String myRuleId;
    private final Class myResourceHolder;
    private final String myRelativePath;

    protected LocalFileCustomWhiteListRule(@NotNull String ruleId, @NotNull Class resource, @NotNull String path) {
        if (ruleId == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(0);
        }
        if (resource == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(1);
        }
        if (path == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(2);
        }
        this.myRuleId = ruleId;
        this.myResourceHolder = resource;
        this.myRelativePath = path;
    }

    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return this.myRuleId.equals(ruleId);
    }

    private boolean isWhitelisted(@NotNull String value) {
        if (value == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(3);
        }
        CachedWhitelistedItems whitelist = this.getWhitelist();
        return whitelist.contains(value);
    }

    @NotNull
    private synchronized CachedWhitelistedItems getWhitelist() {
        CachedWhitelistedItems whitelist = (CachedWhitelistedItems)SoftReference.dereference(this.myWhitelistRef);
        if (whitelist != null) {
            CachedWhitelistedItems cachedWhitelistedItems = whitelist;
            if (cachedWhitelistedItems == null) {
                LocalFileCustomWhiteListRule.$$$reportNull$$$0(4);
            }
            return cachedWhitelistedItems;
        }
        CachedWhitelistedItems items = this.create();
        this.myWhitelistRef = new WeakReference<CachedWhitelistedItems>(items);
        CachedWhitelistedItems cachedWhitelistedItems = items;
        if (cachedWhitelistedItems == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(5);
        }
        return cachedWhitelistedItems;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private CachedWhitelistedItems create() {
        block25: {
            Throwable throwable;
            BufferedReader reader;
            block22: {
                CachedWhitelistedItems cachedWhitelistedItems;
                block23: {
                    block24: {
                        InputStream resourceStream = this.myResourceHolder.getResourceAsStream(this.myRelativePath);
                        if (resourceStream == null) {
                            throw new IOException("Resource " + this.myRelativePath + " not found");
                        }
                        reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                        throwable = null;
                        List values = FileUtil.loadLines((BufferedReader)reader);
                        if (values.isEmpty()) break block22;
                        cachedWhitelistedItems = CachedWhitelistedItems.create(ContainerUtil.map2Set((Collection)values, value -> value.trim()));
                        if (reader == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    reader.close();
                }
                CachedWhitelistedItems cachedWhitelistedItems2 = cachedWhitelistedItems;
                if (cachedWhitelistedItems2 == null) {
                    LocalFileCustomWhiteListRule.$$$reportNull$$$0(6);
                }
                return cachedWhitelistedItems2;
            }
            try {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (reader != null) {
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        CachedWhitelistedItems cachedWhitelistedItems = CachedWhitelistedItems.empty();
        if (cachedWhitelistedItems == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(7);
        }
        return cachedWhitelistedItems;
    }

    @Override
    @NotNull
    protected final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (data == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(8);
        }
        if (context == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(9);
        }
        if (LocalFileCustomWhiteListRule.isThirdPartyValue(data) || this.isWhitelisted(data)) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                LocalFileCustomWhiteListRule.$$$reportNull$$$0(10);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = ValidationResultType.REJECTED;
        if (validationResultType == null) {
            LocalFileCustomWhiteListRule.$$$reportNull$$$0(11);
        }
        return validationResultType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomWhiteListRule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomWhiteListRule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitelist";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWhitelisted";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedWhitelistedItems {
        private final Set<String> myValues;

        private CachedWhitelistedItems(@NotNull Set<String> values) {
            if (values == null) {
                CachedWhitelistedItems.$$$reportNull$$$0(0);
            }
            this.myValues = values;
        }

        public boolean contains(@NotNull String value) {
            if (value == null) {
                CachedWhitelistedItems.$$$reportNull$$$0(1);
            }
            return this.myValues.contains(value);
        }

        @NotNull
        public static CachedWhitelistedItems create(@NotNull Set<String> values) {
            if (values == null) {
                CachedWhitelistedItems.$$$reportNull$$$0(2);
            }
            CachedWhitelistedItems cachedWhitelistedItems = new CachedWhitelistedItems(values);
            if (cachedWhitelistedItems == null) {
                CachedWhitelistedItems.$$$reportNull$$$0(3);
            }
            return cachedWhitelistedItems;
        }

        @NotNull
        public static CachedWhitelistedItems empty() {
            CachedWhitelistedItems cachedWhitelistedItems = new CachedWhitelistedItems(Collections.emptySet());
            if (cachedWhitelistedItems == null) {
                CachedWhitelistedItems.$$$reportNull$$$0(4);
            }
            return cachedWhitelistedItems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomWhiteListRule$CachedWhitelistedItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomWhiteListRule$CachedWhitelistedItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

