/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CopyProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JdkBundle;
import com.intellij.util.JdkBundleList;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchBootJdkAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SwitchBootJdkAction.class);
    private static final JavaVersion MIN_VERSION = JavaVersion.compose((int)8);
    private static final JavaVersion MAX_VERSION = null;
    private static final String WINDOWS_X64_JVM_LOCATION = "Program Files/Java";
    private static final String WINDOWS_X86_JVM_LOCATION = "Program Files (x86)/Java";
    private static final String[] MAC_OS_JVM_LOCATIONS = new String[]{"/Library/Java/JavaVirtualMachines"};
    private static final String[] LINUX_JVM_LOCATIONS = new String[]{"/usr/lib/jvm", "/usr/java"};
    private static final String CONFIG_FILE_EXT = !SystemInfo.isWindows ? ".jdk" : (SystemInfo.is64Bit ? "64.exe.jdk" : ".exe.jdk");

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchBootJdkAction.$$$reportNull$$$0(0);
        }
        this.perform(e.getProject());
    }

    public void perform(final Project project) {
        new Task.Modal(project, "Looking for Available JDKs", true){
            private JdkBundleList myBundleList;
            private File myConfigFile;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myBundleList = SwitchBootJdkAction.findJdkBundles(indicator);
                String selector = PathManager.getPathsSelector();
                File configDir = new File(selector != null ? PathManager.getDefaultConfigPathFor((String)selector) : PathManager.getConfigPath());
                String exeName = System.getProperty("idea.executable");
                if (exeName == null) {
                    exeName = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName());
                }
                this.myConfigFile = new File(configDir, exeName + CONFIG_FILE_EXT);
            }

            public void onSuccess() {
                SwitchBootJdkDialog dialog2 = new SwitchBootJdkDialog(this.getProject(), this.myBundleList, this.myConfigFile.exists());
                if (!dialog2.showAndGet()) {
                    return;
                }
                try {
                    SwitchBootJdkAction.storeSelection(this.myConfigFile, dialog2.getSelectedFile());
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                    String title = "Failed to store boot JDK selection";
                    String message = ex.getMessage();
                    Notifications.Bus.notify((Notification)new Notification("System Messages", title, message, NotificationType.ERROR), (Project)project);
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/SwitchBootJdkAction$1", "run"));
            }
        }.queue();
    }

    private static JdkBundleList findJdkBundles(@Nullable ProgressIndicator indicator) {
        JdkBundleList bundleList = new JdkBundleList();
        bundleList.addBundle(JdkBundle.createBoot());
        JdkBundle bundledJdk = JdkBundle.createBundled();
        if (bundledJdk != null && bundledJdk.isOperational()) {
            bundleList.addBundle(bundledJdk);
        }
        String[] locations = ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (SystemInfo.isWindows) {
            String dir = SystemInfo.is32Bit ? WINDOWS_X86_JVM_LOCATION : WINDOWS_X64_JVM_LOCATION;
            locations = (String[])Stream.of(File.listRoots()).map(root -> new File((File)root, dir).getPath()).toArray(String[]::new);
        } else if (SystemInfo.isMac) {
            locations = MAC_OS_JVM_LOCATIONS;
        } else if (SystemInfo.isLinux) {
            locations = LINUX_JVM_LOCATIONS;
        }
        for (String location : locations) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            bundleList.addBundlesFromLocation(location, MIN_VERSION, MAX_VERSION);
        }
        return bundleList;
    }

    private static void storeSelection(File configFile, File selectedBundle) throws IOException {
        if (selectedBundle != null) {
            File configDir = configFile.getParentFile();
            if (!configDir.isDirectory() && !configDir.mkdirs()) {
                throw new IOException("Cannot create JDK config directory '" + configDir + "'");
            }
            try {
                FileUtil.writeToFile((File)configFile, (String)selectedBundle.getPath());
            }
            catch (IOException e) {
                throw new IOException("Cannot write JDK config file '" + configFile + "': " + e.getMessage(), e);
            }
        } else if (!FileUtil.delete((File)configFile)) {
            throw new IOException("Cannot delete JDK config file '" + configFile + "'");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SwitchBootJdkAction", "actionPerformed"));
    }

    private static class SwitchBootJdkDialog
    extends DialogWrapper
    implements DataProvider,
    CopyProvider {
        private static final JdkBundleItem RESET = new JdkBundleItem(null);
        private static final JdkBundleItem CREATE = new JdkBundleItem(null);
        private static final Comparator<JdkBundle> BUNDLE_COMPARATOR = (b1, b2) -> {
            if (b1.isBoot()) {
                return -1;
            }
            if (b2.isBoot()) {
                return 1;
            }
            int diff = b2.getBundleVersion().compareTo(b1.getBundleVersion());
            if (diff != 0) {
                return diff;
            }
            return b1.getLocation().getPath().compareTo(b2.getLocation().getPath());
        };
        private final JdkBundleList myPathsList;
        private final DefaultComboBoxModel<JdkBundleItem> myModel;
        private final ComboBox<JdkBundleItem> myComboBox;

        private SwitchBootJdkDialog(Project project, JdkBundleList pathsList, boolean customConfig) {
            super(project, true);
            this.myPathsList = pathsList;
            this.myModel = new DefaultComboBoxModel();
            if (customConfig) {
                this.myModel.addElement(RESET);
            }
            ArrayList<JdkBundle> bundles = new ArrayList<JdkBundle>(pathsList.getBundles());
            bundles.sort(BUNDLE_COMPARATOR);
            for (JdkBundle bundle : bundles) {
                this.myModel.addElement(new JdkBundleItem(bundle));
            }
            this.myModel.addElement(CREATE);
            this.myComboBox = new ComboBox(this.myModel);
            this.myComboBox.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
            this.myComboBox.setRenderer((ListCellRenderer)((Object)new JdkBundleItemRenderer()));
            this.myComboBox.addActionListener(e -> {
                JdkBundleItem item;
                if (this.myComboBox.getSelectedItem() == CREATE) {
                    this.chooseBundle();
                }
                this.setOKActionEnabled((item = (JdkBundleItem)this.myComboBox.getSelectedItem()) == RESET || item != null && item.bundle != null && !item.bundle.isBoot());
            });
            this.setTitle("Switch IDE Boot JDK");
            this.setOKButtonText("Save and restart");
            this.init();
        }

        private void chooseBundle() {
            FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){
                private JdkBundle selectedBundle;

                public boolean isFileSelectable(VirtualFile file2) {
                    JdkBundle bundle;
                    this.selectedBundle = null;
                    if (super.isFileSelectable(file2) && (bundle = JdkBundle.createBundle(new File(file2.getPath()))) != null) {
                        this.selectedBundle = bundle;
                        return true;
                    }
                    return false;
                }

                public void validateSelectedFiles(@NotNull VirtualFile[] files2) throws Exception {
                    Bitness arch;
                    if (files2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.validateSelectedFiles(files2);
                    assert (files2.length == 1) : Arrays.toString(files2);
                    if (this.selectedBundle == null) {
                        throw new Exception("Not a valid JDK bundle.");
                    }
                    if (this.selectedBundle.getBundleVersion().compareTo(MIN_VERSION) < 0) {
                        throw new Exception("JDK version mismatch (required: min " + MIN_VERSION + ", selected: " + this.selectedBundle.getBundleVersion() + ")");
                    }
                    Bitness bitness = arch = SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32;
                    if (this.selectedBundle.getBitness() != arch) {
                        throw new Exception("JDK arch mismatch (required: " + arch + ", selected: " + this.selectedBundle.getBitness() + ")");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/actions/SwitchBootJdkAction$SwitchBootJdkDialog$1", "validateSelectedFiles"));
                }
            };
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null, files2 -> {
                if (files2.size() == 1) {
                    File jdkFile = new File(((VirtualFile)files2.get(0)).getPath());
                    JdkBundle existing = this.myPathsList.getBundle(jdkFile.getPath());
                    if (existing != null) {
                        ComboBoxModel model2 = this.myComboBox.getModel();
                        for (int i = 0; i < model2.getSize(); ++i) {
                            if (((JdkBundleItem)model2.getElementAt(i)).bundle != existing) continue;
                            this.myComboBox.setSelectedIndex(i);
                            break;
                        }
                    } else {
                        JdkBundle bundle = JdkBundle.createBundle(jdkFile);
                        if (bundle != null) {
                            this.myPathsList.addBundle(bundle);
                            JdkBundleItem item = new JdkBundleItem(bundle);
                            this.myModel.insertElementAt(item, this.myModel.getSize() - 1);
                            this.myComboBox.setSelectedItem((Object)item);
                        } else {
                            LOG.error("Cannot create bundle for path: " + jdkFile.getPath());
                        }
                    }
                }
            });
        }

        @Nullable
        protected JComponent createNorthPanel() {
            if (!ApplicationManager.getApplication().isInternal()) {
                JLabel warningLabel = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)("<b>Changing these values may cause unwanted behavior of " + ApplicationNamesInfo.getInstance().getFullProductName() + ".<br>Please do not change these unless you have been asked.</b>")));
                warningLabel.setIcon(UIUtil.getWarningIcon());
                warningLabel.setForeground((Color)JBColor.RED);
                NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)20)));
                panel2.add((Component)warningLabel, "North");
                panel2.add((Component)new JBLabel("Select Boot JDK"), "Center");
                return panel2;
            }
            return new JBLabel("Select Boot JDK");
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)this.myComboBox, "Center");
            DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("$Copy")});
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("SwitchBootJDKCopyAction", (ActionGroup)group, true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            panel2.add((Component)toolbar, "East");
            return panel2;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        @Nullable
        public File getSelectedFile() {
            JdkBundleItem item = (JdkBundleItem)this.myComboBox.getSelectedItem();
            return item != null && item.bundle != null ? item.bundle.getLocation() : null;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            File file2;
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(0);
            }
            if ((file2 = this.getSelectedFile()) != null) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(file2.getAbsolutePath()));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(1);
            }
            return this.getSelectedFile() != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(2);
            }
            return this.getSelectedFile() != null;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(3);
            }
            return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/SwitchBootJdkAction$SwitchBootJdkDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class JdkBundleItemRenderer
        extends SimpleListCellRenderer<JdkBundleItem> {
            private JdkBundleItemRenderer() {
            }

            public void customize(JList<? extends JdkBundleItem> list2, JdkBundleItem value, int index, boolean selected2, boolean hasFocus) {
                if (value == RESET) {
                    this.setText("<reset to default>");
                } else if (value == CREATE) {
                    this.setText("...");
                } else if (value != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('[').append(value.bundle.getBundleVersion());
                    if (value.bundle.isBoot()) {
                        sb.append(" boot");
                    }
                    if (value.bundle.isBundled()) {
                        sb.append(" bundled");
                    }
                    sb.append("] ").append(value.bundle.getLocation());
                    this.setText(sb.toString());
                    if (value.bundle.isBoot()) {
                        this.setForeground((Color)JBColor.GREEN);
                    }
                }
            }
        }

        private static class JdkBundleItem {
            private final JdkBundle bundle;

            private JdkBundleItem(JdkBundle bundle) {
                this.bundle = bundle;
            }
        }
    }
}

