/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TObjectLongHashMap;
import java.awt.Component;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class ActivityMonitorAction
extends DumbAwareAction {
    private static final String[] MEANINGLESS_PREFIXES_1 = new String[]{"com.intellij.", "com.jetbrains.", "org.jetbrains.", "org.intellij."};
    private static final String[] MEANINGLESS_PREFIXES_2 = new String[]{"util.", "openapi.", "plugins.", "extapi."};

    ActivityMonitorAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ActivityMonitorAction.$$$reportNull$$$0(0);
        }
        final JTextArea textArea = new JTextArea(12, 100);
        textArea.setText("Loading...");
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        final CompilationMXBean jitBean = ManagementFactory.getCompilationMXBean();
        ScheduledFuture<?> future2 = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){
            final TLongLongHashMap lastThreadTimes = new TLongLongHashMap();
            final TObjectLongHashMap<String> subsystemToSamples = new TObjectLongHashMap();
            long lastGcTime = this.totalGcTime();
            long lastJitTime = jitBean.getTotalCompilationTime();
            long lastUiUpdate = System.currentTimeMillis();
            private final Map<String, String> classToSubsystem = FactoryMap.create(className -> {
                IdeaPluginDescriptor plugin;
                String prefix;
                String pkg = StringUtil.getPackageName((String)className);
                if (pkg.isEmpty()) {
                    pkg = className;
                }
                if (!(prefix = this.getMeaninglessPrefix(pkg)).isEmpty()) {
                    pkg = pkg.substring(prefix.length()) + " (in " + StringUtil.trimEnd((String)prefix, (String)".") + ")";
                }
                return (plugin = PluginManager.getPlugin(PluginManagerCore.getPluginByClassName(className))) != null ? "Plugin " + plugin.getName() + ": " + pkg : pkg;
            });

            private String getMeaninglessPrefix(String qname) {
                String result2 = this.findPrefix(qname, MEANINGLESS_PREFIXES_1);
                if (!result2.isEmpty()) {
                    result2 = result2 + this.findPrefix(qname.substring(result2.length()), MEANINGLESS_PREFIXES_2);
                }
                return result2;
            }

            private String findPrefix(String qname, String[] prefixes) {
                for (String prefix : prefixes) {
                    if (!qname.startsWith(prefix)) continue;
                    return prefix;
                }
                return "";
            }

            private long totalGcTime() {
                return gcBeans.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
            }

            @NotNull
            private String getSubsystemName(long threadId) {
                if (threadId == Thread.currentThread().getId()) {
                    if ("<Activity Monitor>" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "<Activity Monitor>";
                }
                ThreadInfo info = threadBean.getThreadInfo(threadId);
                if (info == null) {
                    if ("<unidentified: thread finished>" == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return "<unidentified: thread finished>";
                }
                if (info.getThreadState() == Thread.State.RUNNABLE) {
                    StackTraceElement[] trace;
                    info = threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                    if (info == null) {
                        if ("<unidentified: thread finished>" == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return "<unidentified: thread finished>";
                    }
                    for (StackTraceElement element : trace = info.getStackTrace()) {
                        String className = element.getClassName();
                        if (this.isInfrastructureClass(className)) continue;
                        String string = this.classToSubsystem.get(className);
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return string;
                    }
                    String string = "<infrastructure: " + this.getCommonThreadName(info) + ">";
                    if (string == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = "<unidentified: " + this.getCommonThreadName(info) + ">";
                if (string == null) {
                    1.$$$reportNull$$$0(5);
                }
                return string;
            }

            private String getCommonThreadName(ThreadInfo info) {
                String name = info.getThreadName();
                if (ThreadDumper.isEDT((String)name)) {
                    return "UI thread";
                }
                int numberStart = CharArrayUtil.shiftBackward((CharSequence)name, (int)(name.length() - 1), (String)"0123456789/ ") + 1;
                if (numberStart > 0) {
                    return name.substring(0, numberStart);
                }
                return name;
            }

            private boolean isInfrastructureClass(String className) {
                return className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("com.yourkit.") || className.startsWith("com.fasterxml.jackson.") || className.startsWith("net.sf.cglib.") || className.startsWith("org.jetbrains.org.objectweb.asm.") || className.startsWith("org.picocontainer.") || className.startsWith("net.jpountz.lz4.") || className.startsWith("net.n3.nanoxml.") || className.startsWith("org.apache.") || className.startsWith("one.util.streamex") || className.startsWith("java.") || className.startsWith("gnu.") || className.startsWith("kotlin.") || className.startsWith("groovy.") || className.startsWith("org.codehaus.groovy.") || className.startsWith("org.gradle.") || className.startsWith("com.google.common.") || className.startsWith("com.google.gson.") || className.startsWith("com.intellij.psi.impl.source.tree.") || className.startsWith("com.intellij.psi.util.Cached") || className.startsWith("com.intellij.openapi.extensions.") || className.startsWith("com.intellij.openapi.util.") || className.startsWith("com.intellij.util.") || className.startsWith("com.intellij.concurrency.") || className.startsWith("com.intellij.psi.stubs.") || className.startsWith("com.intellij.ide.IdeEventQueue") || className.startsWith("com.intellij.openapi.fileTypes.") || className.startsWith("com.intellij.openapi.vfs.newvfs.persistent.PersistentFS") || className.startsWith("com.intellij.openapi.vfs.newvfs.persistent.FSRecords") || className.startsWith("javax.");
            }

            @Override
            public void run() {
                for (long id : threadBean.getAllThreadIds()) {
                    long cpuTime = threadBean.getThreadCpuTime(id);
                    long prev = this.lastThreadTimes.put(id, cpuTime);
                    if (prev == 0L || cpuTime <= prev) continue;
                    String subsystem = this.getSubsystemName(id);
                    this.subsystemToSamples.put((Object)subsystem, this.subsystemToSamples.get((Object)subsystem) + cpuTime - prev);
                }
                long now = System.currentTimeMillis();
                long sinceLastUpdate = now - this.lastUiUpdate;
                if (sinceLastUpdate > 2000L) {
                    this.lastUiUpdate = now;
                    this.scheduleUiUpdate(sinceLastUpdate);
                }
            }

            private void scheduleUiUpdate(long sinceLastUpdate) {
                List<Pair<String, Long>> times = this.takeSnapshot();
                String text2 = " %CPU  Subsystem\n\n" + ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).filter(p -> (Long)p.second > 10L)).sorted(Comparator.comparing(p -> (Long)p.second).reversed())).limit(8L)).map(p -> String.format("%5.1f  %s", (double)((Long)p.second).longValue() * 100.0 / (double)sinceLastUpdate, p.first)).joining((CharSequence)"\n");
                ApplicationManager.getApplication().invokeLater(() -> {
                    textArea.setText(text2);
                    textArea.setCaretPosition(0);
                }, ModalityState.any());
            }

            @NotNull
            private List<Pair<String, Long>> takeSnapshot() {
                long jitTime;
                ArrayList<Pair<String, Long>> times = new ArrayList<Pair<String, Long>>();
                this.subsystemToSamples.forEachEntry((pkg, time) -> times.add(Pair.create((Object)pkg, (Object)TimeUnit.NANOSECONDS.toMillis(time))));
                this.subsystemToSamples.clear();
                long gcTime = this.totalGcTime();
                if (gcTime != this.lastGcTime) {
                    times.add(Pair.create((Object)"<Garbage collection>", (Object)(gcTime - this.lastGcTime)));
                    this.lastGcTime = gcTime;
                }
                if ((jitTime = jitBean.getTotalCompilationTime()) != this.lastJitTime) {
                    times.add((Pair<String, Long>)Pair.create((Object)"<JIT compiler>", (Object)(jitTime - this.lastJitTime)));
                    this.lastJitTime = jitTime;
                }
                ArrayList<Pair<String, Long>> arrayList = times;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(6);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/actions/ActivityMonitorAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubsystemName";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "takeSnapshot";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, 0L, 20L, TimeUnit.MILLISECONDS);
        DialogWrapper dialog2 = new DialogWrapper(false){
            {
                super(x0);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JBScrollPane pane2 = new JBScrollPane((Component)textArea);
                pane2.setPreferredSize(textArea.getPreferredSize());
                return pane2;
            }

            protected String getDimensionServiceKey() {
                return "Performance.Activity.Monitor";
            }

            @NotNull
            protected Action[] createActions() {
                Action[] actionArray = new Action[]{this.getOKAction()};
                if (actionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ActivityMonitorAction$2", "createActions"));
            }
        };
        dialog2.setTitle("Activity Monitor");
        dialog2.setModal(false);
        Disposer.register((Disposable)dialog2.getDisposable(), () -> future2.cancel(false));
        dialog2.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ActivityMonitorAction", "actionPerformed"));
    }
}

