/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    private final Project myProject;

    public FileLevelIntentionComponent(String description, @NotNull HighlightSeverity severity, @Nullable GutterMark gutterMark, final @Nullable List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, final @NotNull Project project, final @NotNull PsiFile psiFile, final @NotNull Editor editor, @Nullable String tooltip2) {
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(3);
        }
        super(FileLevelIntentionComponent.getColor(project, severity));
        this.myProject = project;
        ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> intention : intentions) {
                HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)intention.getFirst();
                info.intentionsToShow.add(descriptor2);
                IntentionAction action2 = descriptor2.getAction();
                if (action2 instanceof EmptyIntentionAction) continue;
                String text2 = action2.getText();
                this.createActionLabel(text2, () -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile, editor, action2, text2);
                });
            }
        }
        this.myLabel.setText(description);
        this.myLabel.setToolTipText(tooltip2);
        if (gutterMark != null) {
            this.myLabel.setIcon(gutterMark.getIcon());
        }
        if (intentions != null && !intentions.isEmpty()) {
            this.myGearLabel.setIcon(AllIcons.General.GearPlain);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    HighlightInfo.IntentionActionDescriptor descriptor2;
                    IntentionActionWithTextCaching actionWithTextCaching;
                    CachedIntentions cachedIntentions;
                    IntentionListStep step;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((step = new IntentionListStep(null, editor, psiFile, project, cachedIntentions = new CachedIntentions(project, psiFile, editor))).hasSubstep(actionWithTextCaching = cachedIntentions.wrapAction(descriptor2 = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst(), (PsiElement)psiFile, psiFile, editor))) {
                        step = step.getSubStep(actionWithTextCaching, null);
                    }
                    ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(-dimension.width + FileLevelIntentionComponent.this.myGearLabel.getWidth(), FileLevelIntentionComponent.this.getHeight());
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent$1", "onClick"));
                }
            }.installOn((Component)this.myGearLabel);
        }
    }

    @NotNull
    private static Color getColor(@NotNull Project project, @NotNull HighlightSeverity severity) {
        if (project == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(4);
        }
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(5);
        }
        if (SeverityRegistrar.getSeverityRegistrar(project).compare(severity, HighlightSeverity.ERROR) >= 0) {
            Color color = LightColors.RED;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(6);
            }
            return color;
        }
        if (SeverityRegistrar.getSeverityRegistrar(project).compare(severity, HighlightSeverity.WARNING) >= 0) {
            Color color = LightColors.YELLOW;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(7);
            }
            return color;
        }
        Color color = LightColors.GREEN;
        if (color == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(8);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

