/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationHolderImpl
extends SmartList<Annotation>
implements AnnotationHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl");
    private final AnnotationSession myAnnotationSession;
    private final boolean myBatchMode;

    public AnnotationHolderImpl(@NotNull AnnotationSession session2) {
        if (session2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(0);
        }
        this(session2, false);
    }

    public AnnotationHolderImpl(@NotNull AnnotationSession session2, boolean batchMode) {
        if (session2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(1);
        }
        this.myAnnotationSession = session2;
        this.myBatchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.myBatchMode;
    }

    public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(2);
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.ERROR, elt.getTextRange(), message);
    }

    public Annotation createErrorAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(3);
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.ERROR, node.getTextRange(), message);
    }

    public Annotation createErrorAnnotation(@NotNull TextRange range2, String message) {
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(4);
        }
        return this.createAnnotation(HighlightSeverity.ERROR, range2, message);
    }

    public Annotation createWarningAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(5);
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WARNING, elt.getTextRange(), message);
    }

    public Annotation createWarningAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(6);
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WARNING, node.getTextRange(), message);
    }

    public Annotation createWarningAnnotation(@NotNull TextRange range2, String message) {
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(7);
        }
        return this.createAnnotation(HighlightSeverity.WARNING, range2, message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(8);
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, elt.getTextRange(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(9);
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, node.getTextRange(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull TextRange range2, String message) {
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(10);
        }
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, range2, message);
    }

    public Annotation createInfoAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(11);
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.INFORMATION, elt.getTextRange(), message);
    }

    public Annotation createInfoAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(12);
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.INFORMATION, node.getTextRange(), message);
    }

    private void assertMyFile(PsiElement node) {
        if (node == null) {
            return;
        }
        PsiFile myFile = this.myAnnotationSession.getFile();
        PsiFile containingFile = node.getContainingFile();
        LOG.assertTrue(containingFile != null, (Object)node);
        VirtualFile containingVFile = containingFile.getVirtualFile();
        VirtualFile myVFile = myFile.getVirtualFile();
        if (!Comparing.equal((Object)containingVFile, (Object)myVFile)) {
            LOG.error("Annotation must be registered for an element inside '" + myFile + "' which is in '" + myVFile + "'.\nElement passed: '" + node + "' is inside the '" + containingFile + "' which is in '" + containingVFile + "'");
        }
    }

    public Annotation createInfoAnnotation(@NotNull TextRange range2, String message) {
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(13);
        }
        return this.createAnnotation(HighlightSeverity.INFORMATION, range2, message);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range2, @Nullable String message) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(14);
        }
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(15);
        }
        String tooltip2 = message == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
        return this.createAnnotation(severity, range2, message, tooltip2);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range2, @Nullable String message, @Nullable String tooltip2) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(16);
        }
        if (range2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(17);
        }
        Annotation annotation = new Annotation(range2.getStartOffset(), range2.getEndOffset(), severity, message, tooltip2);
        this.add(annotation);
        return annotation;
    }

    public boolean hasAnnotations() {
        return !this.isEmpty();
    }

    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(18);
        }
        return annotationSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentAnnotationSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWarningAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWeakWarningAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInfoAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

