/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FilePosition;
import com.intellij.build.Filterable;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DerivedResult;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView,
Filterable<ExecutionNode>,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String SPLITTER_PROPERTY = "BuildView.Splitter.Proportion";
    private final JPanel myPanel;
    private final Map<Object, ExecutionNode> nodesMap;
    private final Project myProject;
    private final ConsoleViewHandler myConsoleViewHandler;
    private final String myWorkingDir;
    private final AtomicBoolean myFinishedBuildEventReceived;
    private final AtomicBoolean myDisposed;
    private final AtomicBoolean myShownFirstError;
    private final boolean myFocusFirstError;
    private final StructureTreeModel<SimpleTreeStructure> myTreeModel;
    private final Tree myTree;
    private final ExecutionNode myRootNode;
    private final ExecutionNode myBuildProgressRootNode;
    private final Set<Predicate<ExecutionNode>> myNodeFilters;
    private final ProblemOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;
    private final Set<BuildEvent> myDeferredEvents;

    public BuildTreeConsoleView(Project project, BuildDescriptor buildDescriptor, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
        if (buildViewSettingsProvider == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel();
        this.nodesMap = ContainerUtil.newConcurrentMap();
        this.myFinishedBuildEventReceived = new AtomicBoolean();
        this.myDisposed = new AtomicBoolean();
        this.myShownFirstError = new AtomicBoolean();
        this.myDeferredEvents = ContainerUtil.newConcurrentSet();
        this.myNodeFilters = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        this.myWorkingDir = FileUtil.toSystemIndependentName((String)buildDescriptor.getWorkingDir());
        this.myFocusFirstError = !(buildDescriptor instanceof DefaultBuildDescriptor) || ((DefaultBuildDescriptor)buildDescriptor).isActivateToolWindowWhenFailed();
        this.myRootNode = new ExecutionNode(this.myProject, null);
        this.myRootNode.setAutoExpandNode(true);
        this.myBuildProgressRootNode = new ExecutionNode(this.myProject, this.myRootNode);
        this.myBuildProgressRootNode.setAutoExpandNode(true);
        this.myRootNode.add(this.myBuildProgressRootNode);
        SimpleTreeStructure.Impl treeStructure = new SimpleTreeStructure.Impl((SimpleNode)this.myRootNode);
        this.myTreeModel = new StructureTreeModel<SimpleTreeStructure.Impl>(treeStructure, (Disposable)this);
        this.myTree = BuildTreeConsoleView.initTree(new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), (Disposable)this));
        JPanel myContentPanel = new JPanel();
        myContentPanel.setLayout(new CardLayout());
        myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)0), TREE);
        this.myPanel.setLayout(new BorderLayout());
        OnePixelSplitter myThreeComponentsSplitter = new OnePixelSplitter(SPLITTER_PROPERTY, 0.33f);
        myThreeComponentsSplitter.setFirstComponent((JComponent)myContentPanel);
        this.myConsoleViewHandler = new ConsoleViewHandler(this.myProject, this.myTree, this.myBuildProgressRootNode, (Disposable)this, executionConsole, buildViewSettingsProvider);
        myThreeComponentsSplitter.setSecondComponent(this.myConsoleViewHandler.getComponent());
        this.myPanel.add((Component)myThreeComponentsSplitter, "Center");
        BuildTreeFilters.install(this);
        this.myRootNode.setFilter(this.getFilter());
        this.myOccurrenceNavigatorSupport = new ProblemOccurrenceNavigatorSupport(this.myTree);
    }

    private void installContextMenu(@NotNull StartBuildEvent startBuildEvent) {
        if (startBuildEvent == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            AnAction[] restartActions;
            DefaultActionGroup group = new DefaultActionGroup();
            DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
            for (AnAction anAction : restartActions = startBuildEvent.getRestartActions()) {
                rerunActionGroup.add(anAction);
            }
            if (restartActions.length > 0) {
                group.addAll((ActionGroup)rerunActionGroup);
                group.addSeparator();
            }
            EditSourceAction edit = new EditSourceAction();
            ActionUtil.copyFrom((AnAction)edit, (String)"EditSource");
            group.add((AnAction)edit);
            group.addSeparator();
            group.addAll((ActionGroup)BuildTreeFilters.createFilteringActionsGroup(this));
            group.addSeparator();
            CommonActionsManager actionsManager = CommonActionsManager.getInstance();
            AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
            group.add(prevAction);
            AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
            group.add(nextAction);
            PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)group, (String)"BuildView");
        });
    }

    public void clear() {
        this.getRootElement().removeChildren();
        this.nodesMap.clear();
        this.myConsoleViewHandler.clear();
        this.myTreeModel.invalidate();
    }

    @Override
    public boolean isFilteringEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        Predicate<ExecutionNode> predicate = executionNode -> executionNode == this.getBuildProgressRootNode() || executionNode.isRunning() || executionNode.isFailed() || this.myNodeFilters.stream().anyMatch(predicate -> predicate.test(executionNode));
        if (predicate == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(2);
        }
        return predicate;
    }

    @Override
    public void addFilter(@NotNull Predicate<ExecutionNode> executionTreeFilter) {
        if (executionTreeFilter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(3);
        }
        this.myNodeFilters.add(executionTreeFilter);
        this.updateFilter();
    }

    @Override
    public void removeFilter(@NotNull Predicate<ExecutionNode> filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(4);
        }
        this.myNodeFilters.remove(filter);
        this.updateFilter();
    }

    @Override
    public boolean contains(@NotNull Predicate<ExecutionNode> filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(5);
        }
        return this.myNodeFilters.contains(filter);
    }

    private void updateFilter() {
        ExecutionNode rootElement = this.getRootElement();
        rootElement.setFilter(this.getFilter());
        this.scheduleUpdate(rootElement);
    }

    private ExecutionNode getRootElement() {
        return this.myRootNode;
    }

    private ExecutionNode getBuildProgressRootNode() {
        return this.myBuildProgressRootNode;
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(7);
        }
    }

    @Nullable
    private ExecutionNode getOrMaybeCreateParentNode(@NotNull BuildEvent event) {
        ExecutionNode parentNode;
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(8);
        }
        ExecutionNode executionNode = parentNode = event.getParentId() == null ? null : this.nodesMap.get(event.getParentId());
        if (event instanceof MessageEvent) {
            parentNode = this.createMessageParentNodes((MessageEvent)event, parentNode);
        }
        return parentNode;
    }

    private void onEventInternal(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(9);
        }
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(10);
        }
        ExecutionNode parentNode = this.getOrMaybeCreateParentNode(event);
        Object eventId = event.getId();
        ExecutionNode currentNode = this.nodesMap.get(eventId);
        ExecutionNode buildProgressRootNode = this.getBuildProgressRootNode();
        if (event instanceof StartEvent || event instanceof MessageEvent) {
            if (currentNode == null) {
                if (event instanceof DuplicateMessageAware) {
                    if (this.myFinishedBuildEventReceived.get()) {
                        if (parentNode != null && parentNode.findFirstChild(node -> event.getMessage().equals(node.getName())) != null) {
                            return;
                        }
                    } else {
                        this.myDeferredEvents.add(event);
                        return;
                    }
                }
                if (event instanceof StartBuildEvent) {
                    currentNode = buildProgressRootNode;
                    this.installContextMenu((StartBuildEvent)event);
                    String buildTitle = ((StartBuildEvent)event).getBuildTitle();
                    currentNode.setTitle(buildTitle);
                    currentNode.setAutoExpandNode(true);
                } else {
                    currentNode = new ExecutionNode(this.myProject, parentNode);
                    if (event instanceof MessageEvent) {
                        MessageEvent messageEvent = (MessageEvent)event;
                        currentNode.setStartTime(messageEvent.getEventTime());
                        currentNode.setEndTime(messageEvent.getEventTime());
                        Navigatable messageEventNavigatable = messageEvent.getNavigatable(this.myProject);
                        currentNode.setNavigatable(messageEventNavigatable);
                        MessageEventResult messageEventResult = messageEvent.getResult();
                        currentNode.setResult((EventResult)messageEventResult);
                        if (messageEventResult instanceof FailureResult) {
                            for (Failure failure : ((FailureResult)messageEventResult).getFailures()) {
                                this.showErrorIfFirst(currentNode, failure.getNavigatable());
                            }
                        }
                        if (messageEvent.getKind() == MessageEvent.Kind.ERROR) {
                            this.showErrorIfFirst(currentNode, messageEventNavigatable);
                        }
                        if (parentNode != null) {
                            if (parentNode != buildProgressRootNode) {
                                this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                                this.myConsoleViewHandler.addOutput(parentNode, "\n", true);
                            }
                            this.reportMessageKind(messageEvent, parentNode);
                        }
                        this.myConsoleViewHandler.addOutput(currentNode, buildId, event);
                    }
                    currentNode.setAutoExpandNode(currentNode == buildProgressRootNode || parentNode == buildProgressRootNode);
                }
            } else {
                LOG.warn("start event id collision found:" + eventId + ", was also in node: " + currentNode.getTitle());
                return;
            }
            this.nodesMap.put(eventId, currentNode);
            if (parentNode != null) {
                parentNode.add(currentNode);
            }
        } else {
            currentNode = this.nodesMap.get(eventId);
            if (currentNode == null) {
                if (event instanceof ProgressBuildEvent) {
                    currentNode = new ExecutionNode(this.myProject, parentNode);
                    this.nodesMap.put(eventId, currentNode);
                    if (parentNode != null) {
                        parentNode.add(currentNode);
                    }
                } else if (event instanceof OutputBuildEvent && parentNode != null) {
                    this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                }
            }
        }
        if (currentNode == null) {
            return;
        }
        currentNode.setName(event.getMessage());
        currentNode.setHint(event.getHint());
        if (currentNode.getStartTime() == 0L) {
            currentNode.setStartTime(event.getEventTime());
        }
        if (event instanceof FinishEvent) {
            currentNode.setEndTime(event.getEventTime());
            EventResult result2 = ((FinishEvent)event).getResult();
            if (result2 instanceof DerivedResult) {
                result2 = BuildTreeConsoleView.calculateDerivedResult((DerivedResult)result2, currentNode);
            }
            currentNode.setResult(result2);
            SkippedResultImpl skippedResult = new SkippedResultImpl();
            this.finishChildren(currentNode, (EventResult)skippedResult);
            if (result2 instanceof FailureResult) {
                for (Failure failure : ((FailureResult)result2).getFailures()) {
                    this.addChildFailureNode(currentNode, failure, event.getMessage());
                }
            }
        }
        if (event instanceof FinishBuildEvent) {
            this.myFinishedBuildEventReceived.set(true);
            String aHint = event.getHint();
            String time = DateFormatUtil.formatDateTime((long)event.getEventTime());
            aHint = aHint == null ? "at " + time : aHint + " at " + time;
            currentNode.setHint(aHint);
            this.myDeferredEvents.forEach(buildEvent -> this.onEventInternal(buildId, (BuildEvent)buildEvent));
            if (this.myConsoleViewHandler.myExecutionNode == null) {
                this.invokeLater(() -> this.myConsoleViewHandler.setNode(buildProgressRootNode));
            }
        }
        this.scheduleUpdate(currentNode);
    }

    private static EventResult calculateDerivedResult(DerivedResult result2, ExecutionNode node) {
        if (node.getResult() != null) {
            return node.getResult();
        }
        if (node.isFailed()) {
            return result2.createFailureResult();
        }
        return result2.createDefaultResult();
    }

    private void reportMessageKind(@NotNull MessageEvent messageEvent, @NotNull ExecutionNode parentNode) {
        MessageEvent.Kind eventKind;
        if (messageEvent == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(11);
        }
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(12);
        }
        if ((eventKind = messageEvent.getKind()) == MessageEvent.Kind.ERROR || eventKind == MessageEvent.Kind.WARNING || eventKind == MessageEvent.Kind.INFO) {
            ExecutionNode p = parentNode;
            Ref child2 = new Ref();
            do {
                boolean isUpdateNeeded;
                ExecutionNode executionNode = p;
                executionNode.reportChildMessageKind(eventKind);
                boolean bl = isUpdateNeeded = eventKind == MessageEvent.Kind.WARNING && !executionNode.hasWarnings() || eventKind == MessageEvent.Kind.INFO && !executionNode.hasInfos() || !child2.isNull() && Arrays.stream(executionNode.getChildren()).noneMatch(node -> child2.get() == node);
                if (isUpdateNeeded) {
                    this.scheduleUpdate(executionNode);
                }
                child2.set((Object)executionNode);
            } while ((p = p.getParent()) instanceof ExecutionNode);
            this.scheduleUpdate(this.getRootElement());
        }
    }

    private void showErrorIfFirst(@NotNull ExecutionNode node, @Nullable Navigatable navigatable) {
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(13);
        }
        if (this.myShownFirstError.compareAndSet(false, true)) {
            if (this.myFocusFirstError && navigatable != null && navigatable != NonNavigatable.INSTANCE) {
                ApplicationManager.getApplication().invokeLater(() -> navigatable.navigate(true), ModalityState.defaultModalityState(), this.myProject.getDisposed());
            }
            ExecutionNode parentOrNode = node.getParent() == null ? node : node.getParent();
            this.myTreeModel.invalidate((Object)parentOrNode, true).onProcessed(p -> TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)BuildTreeConsoleView.visitor(node)));
        }
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static TreeVisitor visitor(@NotNull ExecutionNode executionNode) {
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(16);
        }
        TreeVisitor treeVisitor = path -> {
            Object object = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (executionNode == object) {
                return TreeVisitor.Action.INTERRUPT;
            }
            return TreeVisitor.Action.CONTINUE;
        };
        if (treeVisitor == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(17);
        }
        return treeVisitor;
    }

    private void addChildFailureNode(@NotNull ExecutionNode parentNode, @NotNull Failure failure, @NotNull String defaultFailureMessage) {
        List<Failure> failures;
        EventResult result2;
        String failureNodeName;
        ExecutionNode failureNode;
        int sepIndex;
        String text2;
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(18);
        }
        if (failure == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(19);
        }
        if (defaultFailureMessage == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(20);
        }
        if ((text2 = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage())) == null && failure.getError() != null) {
            text2 = failure.getError().getMessage();
        }
        if (text2 == null) {
            text2 = defaultFailureMessage;
        }
        if ((sepIndex = (text2 = StringUtil.stripHtml((String)text2, (boolean)true)).indexOf(". ")) < 0) {
            sepIndex = text2.indexOf("\n");
        }
        if (sepIndex > 0) {
            text2 = text2.substring(0, sepIndex);
        }
        if ((failureNode = parentNode.findFirstChild(arg_0 -> BuildTreeConsoleView.lambda$addChildFailureNode$10(failureNodeName = StringUtil.trimEnd((String)text2, (char)'.'), arg_0))) == null) {
            failureNode = new ExecutionNode(this.myProject, parentNode);
            failureNode.setName(failureNodeName);
            parentNode.add(failureNode);
        }
        if (failure.getNavigatable() == null) {
            failureNode.setNavigatable(failure.getNavigatable());
        }
        if ((result2 = failureNode.getResult()) instanceof FailureResult) {
            failures = new ArrayList<Failure>(((FailureResult)result2).getFailures());
            failures.add(failure);
        } else {
            failures = Collections.singletonList(failure);
        }
        failureNode.setResult((EventResult)new FailureResultImpl(failures));
        this.myConsoleViewHandler.addOutput(failureNode, failure);
        this.showErrorIfFirst(failureNode, failure.getNavigatable());
    }

    private void finishChildren(@NotNull ExecutionNode node, @NotNull EventResult result2) {
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(22);
        }
        this.invokeLater(() -> {
            for (SimpleNode child2 : node.getChildren()) {
                ExecutionNode executionChild;
                if (!(child2 instanceof ExecutionNode) || !(executionChild = (ExecutionNode)child2).isRunning()) continue;
                this.invokeLater(() -> {
                    if (executionChild.isRunning()) {
                        this.finishChildren(executionChild, result2);
                        executionChild.setResult(result2);
                    }
                });
            }
        });
    }

    protected void expand(Tree tree) {
        TreeUtil.expand((JTree)tree, path -> {
            ExecutionNode node = (ExecutionNode)((Object)((Object)TreeUtil.getLastUserObject(ExecutionNode.class, (TreePath)path)));
            if (node != null && node.isAutoExpandNode() && node.getChildCount() > 0) {
                return TreeVisitor.Action.CONTINUE;
            }
            return TreeVisitor.Action.SKIP_CHILDREN;
        }, path -> {});
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(23);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(24);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(25);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(26);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(27);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTree;
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    public boolean isDisposed() {
        return this.myDisposed.get();
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(28);
        }
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(29);
        }
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> this.onEventInternal(buildId, event));
    }

    void scheduleUpdate(ExecutionNode executionNode) {
        ExecutionNode node = executionNode.getParent() == null ? executionNode : executionNode.getParent();
        this.myTreeModel.invalidate((Object)node, true).onProcessed(p -> this.expand(this.myTree));
    }

    private ExecutionNode createMessageParentNodes(MessageEvent messageEvent, ExecutionNode parentNode) {
        Object messageEventParentId = messageEvent.getParentId();
        if (messageEventParentId == null) {
            return null;
        }
        if (messageEvent instanceof FileMessageEvent) {
            FilePosition filePosition = ((FileMessageEvent)messageEvent).getFilePosition();
            String filePath = FileUtil.toSystemIndependentName((String)filePosition.getFile().getPath());
            String parentsPath = "";
            String relativePath = FileUtil.getRelativePath((String)this.myWorkingDir, (String)filePath, (char)'/');
            if (relativePath != null) {
                parentsPath = this.myWorkingDir;
            }
            relativePath = StringUtil.isEmpty((String)parentsPath) ? filePath : FileUtil.getRelativePath((String)parentsPath, (String)filePath, (char)'/');
            parentNode = BuildTreeConsoleView.getOrCreateMessagesNode(messageEvent, filePath, parentNode, relativePath, () -> {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)filePosition.getFile(), (boolean)false);
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }, messageEvent.getNavigatable(this.myProject), this.nodesMap, this.myProject);
        }
        return parentNode;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTree != null) {
                this.myTree.setRootVisible(false);
                this.myTree.setShowsRootHandles(true);
            }
        });
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(30);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        return null;
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExecutionNode each : this.getSelectedNodes()) {
            List<Navigatable> navigatable = each.getNavigatables();
            navigatables.addAll(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] getSelectedNodes() {
        ExecutionNode[] result2 = new ExecutionNode[]{};
        if (this.myTree != null) {
            List nodes = TreeUtil.collectSelectedObjects((JTree)this.myTree, path -> (ExecutionNode)((Object)((Object)TreeUtil.getLastUserObject(ExecutionNode.class, (TreePath)path))));
            return nodes.toArray(result2);
        }
        return result2;
    }

    @ApiStatus.Internal
    JTree getTree() {
        return this.myTree;
    }

    private static Tree initTree(@NotNull AsyncTreeModel model2) {
        if (model2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(31);
        }
        MyTree tree = new MyTree((TreeModel)((Object)model2));
        UIUtil.putClientProperty((JComponent)((Object)tree), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        tree.setRootVisible(false);
        EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
        EditSourceOnEnterKeyHandler.install((JComponent)((Object)tree), null);
        new TreeSpeedSearch((JTree)((Object)tree)).setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions((JTree)((Object)tree));
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyNodeRenderer()));
        return tree;
    }

    @NotNull
    private static ExecutionNode getOrCreateMessagesNode(MessageEvent messageEvent, String nodeId, ExecutionNode parentNode, String nodeName, @Nullable Supplier<? extends Icon> iconProvider, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> nodesMap, Project project) {
        ExecutionNode node = nodesMap.get(nodeId);
        if (node == null) {
            node = new ExecutionNode(project, parentNode);
            node.setName(nodeName);
            node.setAutoExpandNode(true);
            node.setStartTime(messageEvent.getEventTime());
            node.setEndTime(messageEvent.getEventTime());
            if (iconProvider != null) {
                node.setIconProvider(iconProvider);
            }
            if (navigatable != null) {
                node.setNavigatable(navigatable);
            }
            parentNode.add(node);
            nodesMap.put(nodeId, node);
        }
        ExecutionNode executionNode = node;
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(32);
        }
        return executionNode;
    }

    private void invokeLater(@NotNull Runnable task2) {
        if (task2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(33);
        }
        this.myTreeModel.getInvoker().invokeLater(task2);
    }

    private static /* synthetic */ boolean lambda$addChildFailureNode$10(String failureNodeName, ExecutionNode executionNode) {
        return failureNodeName.equals(executionNode.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 27: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 27: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildViewSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBuildEvent";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionTreeFilter";
                break;
            }
            case 4: 
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: 
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageEvent";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFailureMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "visitor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMessagesNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installContextMenu";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 27: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrMaybeCreateParentNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onEventInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportMessageKind";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showErrorIfFirst";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addChildFailureNode";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "finishChildren";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "initTree";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 27: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private String myDurationText;
        private Color myDurationColor;
        private int myDurationWidth;
        private int myDurationOffset;

        private MyNodeRenderer() {
            this.putClientProperty(DefaultTreeUI.SHRINK_LONG_RENDERER, true);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyNodeRenderer.$$$reportNull$$$0(0);
            }
            super.customizeCellRenderer(tree, value, selected2, expanded, leaf, row, hasFocus);
            this.myDurationText = null;
            this.myDurationColor = null;
            this.myDurationWidth = 0;
            this.myDurationOffset = 0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObj = node.getUserObject();
            if (userObj instanceof ExecutionNode) {
                this.myDurationText = ((ExecutionNode)((Object)userObj)).getDuration();
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected2 ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            Shape clip = null;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
            if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
                g.setColor(this.myDurationColor);
                g.setFont(RelativeFont.SMALL.derive(this.getFont()));
                g.drawString(this.myDurationText, width + this.myDurationOffset / 2, MyNodeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
                clip = g.getClip();
                g.clipRect(0, 0, width, height);
            }
            super.paintComponent(g);
            if (clip != null) {
                g.setClip(clip);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BuildTreeConsoleView.TREE, "com/intellij/build/BuildTreeConsoleView$MyNodeRenderer", "customizeCellRenderer"));
        }
    }

    private static class MyTree
    extends Tree {
        private MyTree(TreeModel treemodel) {
            super(treemodel);
        }

        public void setUI(TreeUI ui) {
            super.setUI(ui instanceof DefaultTreeUI ? ui : DefaultTreeUI.createUI((JComponent)((Object)this)));
            this.setLargeModel(true);
        }
    }

    private static class ScrollEditorToTheEndAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ConsoleViewHandler myConsoleViewHandler;

        ScrollEditorToTheEndAction(@NotNull ConsoleViewHandler handler2) {
            if (handler2 == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(0);
            }
            this.myConsoleViewHandler = handler2;
            String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
            this.getTemplatePresentation().setDescription(message);
            this.getTemplatePresentation().setText(message);
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(1);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return false;
            }
            Document document = editor.getDocument();
            return document.getLineCount() == 0 || document.getLineNumber(editor.getCaretModel().getOffset()) == document.getLineCount() - 1;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(2);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return;
            }
            if (state) {
                EditorUtil.scrollToTheEnd(editor);
            } else {
                int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
                LogicalPosition currentPosition = editor.getCaretModel().getLogicalPosition();
                LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
                editor.getCaretModel().moveToLogicalPosition(position);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ScrollEditorToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProblemOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        ProblemOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject;
            if (node == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(0);
            }
            if (!((userObject = node.getUserObject()) instanceof ExecutionNode)) {
                return null;
            }
            ExecutionNode executionNode = (ExecutionNode)((Object)userObject);
            if (executionNode.getChildCount() > 0 || !executionNode.hasWarnings() && !executionNode.isFailed()) {
                return null;
            }
            List<Navigatable> navigatables = executionNode.getNavigatables();
            if (!navigatables.isEmpty()) {
                return navigatables.get(0);
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConsoleViewHandler {
        private static final String EMPTY_CONSOLE_NAME = "empty";
        private final Project myProject;
        private final JPanel myPanel;
        private final CompositeView<ExecutionConsole> myView;
        private final AtomicReference<String> myNodeConsoleViewName;
        private final Map<String, List<Consumer<BuildTextConsoleView>>> deferredNodeOutput;
        @NotNull
        private final BuildViewSettingsProvider myViewSettingsProvider;
        @Nullable
        private ExecutionNode myExecutionNode;

        ConsoleViewHandler(@NotNull Project project, @NotNull Tree tree, @NotNull ExecutionNode buildProgressRootNode, @NotNull Disposable parentDisposable, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
            if (project == null) {
                ConsoleViewHandler.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                ConsoleViewHandler.$$$reportNull$$$0(1);
            }
            if (buildProgressRootNode == null) {
                ConsoleViewHandler.$$$reportNull$$$0(2);
            }
            if (parentDisposable == null) {
                ConsoleViewHandler.$$$reportNull$$$0(3);
            }
            if (buildViewSettingsProvider == null) {
                ConsoleViewHandler.$$$reportNull$$$0(4);
            }
            this.myNodeConsoleViewName = new AtomicReference();
            this.deferredNodeOutput = ContainerUtil.newConcurrentMap();
            this.myProject = project;
            this.myPanel = new JPanel(new BorderLayout());
            this.myViewSettingsProvider = buildViewSettingsProvider;
            this.myView = new CompositeView<ExecutionConsole>(null){

                @Override
                public void addView(@NotNull ExecutionConsole view, @NotNull String viewName, boolean enable) {
                    if (view == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (viewName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.addView(view, viewName, enable);
                    UIUtil.removeScrollBorder((Component)view.getComponent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "view";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "viewName";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$1";
                    objectArray[2] = "addView";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (executionConsole != null && buildViewSettingsProvider.isSideBySideView()) {
                String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(buildProgressRootNode);
                this.myView.addView(executionConsole, nodeConsoleViewName, true);
                this.myNodeConsoleViewName.set(nodeConsoleViewName);
            }
            ConsoleViewImpl emptyConsole = new ConsoleViewImpl(project, GlobalSearchScope.EMPTY_SCOPE, true, false);
            this.myView.addView((ExecutionConsole)emptyConsole, EMPTY_CONSOLE_NAME, false);
            if (!buildViewSettingsProvider.isSideBySideView()) {
                this.myPanel.setVisible(false);
            }
            JComponent consoleComponent = emptyConsole.getComponent();
            consoleComponent.setFocusable(true);
            this.myPanel.add((Component)this.myView.getComponent(), "Center");
            DefaultActionGroup consoleActionsGroup = new DefaultActionGroup();
            consoleActionsGroup.add((AnAction)new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

                @Override
                @Nullable
                protected Editor getEditor(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return this.getEditor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$2", "getEditor"));
                }
            });
            consoleActionsGroup.add((AnAction)new ScrollEditorToTheEndAction(this));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuildConsole", (ActionGroup)consoleActionsGroup, false);
            this.myPanel.add((Component)toolbar.getComponent(), "East");
            tree.addTreeSelectionListener(e -> {
                TreePath path = e.getPath();
                if (path == null || !e.isAddedPath()) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                this.setNode(selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null);
            });
            Disposer.register((Disposable)parentDisposable, this.myView);
            Disposer.register((Disposable)parentDisposable, (Disposable)emptyConsole);
        }

        @Nullable
        private ExecutionConsole getCurrentConsole() {
            String nodeConsoleViewName = this.myNodeConsoleViewName.get();
            if (nodeConsoleViewName == null) {
                return null;
            }
            return this.myView.getView(nodeConsoleViewName);
        }

        @Nullable
        private Editor getEditor() {
            ExecutionConsole console = this.getCurrentConsole();
            if (console instanceof ConsoleViewImpl) {
                return ((ConsoleViewImpl)console).getEditor();
            }
            return null;
        }

        private boolean setNode(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(5);
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            this.myNodeConsoleViewName.set(nodeConsoleViewName);
            ExecutionConsole view = this.myView.getView(nodeConsoleViewName);
            if (view != null) {
                List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
                if (view instanceof BuildTextConsoleView && deferredOutput != null && !deferredOutput.isEmpty()) {
                    this.deferredNodeOutput.remove(nodeConsoleViewName);
                    deferredOutput.forEach(consumer -> consumer.accept((BuildTextConsoleView)view));
                }
                this.myView.enableView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
                return true;
            }
            List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
            if (deferredOutput != null && !deferredOutput.isEmpty()) {
                BuildTextConsoleView textConsoleView = new BuildTextConsoleView(this.myProject, true);
                this.deferredNodeOutput.remove(nodeConsoleViewName);
                deferredOutput.forEach(consumer -> consumer.accept(textConsoleView));
                this.myView.addView((ExecutionConsole)textConsoleView, nodeConsoleViewName, false);
                this.myView.enableView(nodeConsoleViewName, false);
            } else if (this.myViewSettingsProvider.isSideBySideView()) {
                this.myView.enableView(EMPTY_CONSOLE_NAME, false);
                return true;
            }
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                BuildTextConsoleView taskOutputView = new BuildTextConsoleView(this.myProject, true);
                EventResult eventResult = node.getResult();
                boolean hasChanged = taskOutputView.appendEventResult(eventResult);
                if (!hasChanged) {
                    return false;
                }
                taskOutputView.scrollTo(0);
                this.myView.addView((ExecutionConsole)taskOutputView, nodeConsoleViewName, false);
                this.myView.enableView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
            }
            return true;
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull String text2, boolean stdOut) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                ConsoleViewHandler.$$$reportNull$$$0(7);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(text2, stdOut));
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull Object buildId, BuildEvent event) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(8);
            }
            if (buildId == null) {
                ConsoleViewHandler.$$$reportNull$$$0(9);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.onEvent(buildId, event));
        }

        private void addOutput(@NotNull ExecutionNode node, Failure failure) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(10);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(failure));
        }

        private void addOutput(@NotNull ExecutionNode node, Consumer<BuildTextConsoleView> consumer) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(11);
            }
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                return;
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            ExecutionConsole viewView = this.myView.getView(nodeConsoleViewName);
            if (viewView instanceof BuildTextConsoleView) {
                consumer.accept((BuildTextConsoleView)viewView);
            }
            if (viewView == null) {
                this.deferredNodeOutput.computeIfAbsent(nodeConsoleViewName, s -> new ArrayList()).add(consumer);
            }
        }

        @NotNull
        private static String getNodeConsoleViewName(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(12);
            }
            String string = String.valueOf(System.identityHashCode((Object)node));
            if (string == null) {
                ConsoleViewHandler.$$$reportNull$$$0(13);
            }
            return string;
        }

        private void setNode(@Nullable DefaultMutableTreeNode node) {
            if (node == null || node.getUserObject() == this.myExecutionNode) {
                return;
            }
            if (node.getUserObject() instanceof ExecutionNode) {
                this.myExecutionNode = (ExecutionNode)((Object)node.getUserObject());
                if (this.setNode((ExecutionNode)((Object)node.getUserObject()))) {
                    return;
                }
            }
            this.myExecutionNode = null;
            if (this.myView.getView("consoleView") != null) {
                this.myView.enableView("consoleView", false);
                this.myPanel.setVisible(true);
            } else {
                this.myPanel.setVisible(false);
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public void clear() {
            this.myPanel.setVisible(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = BuildTreeConsoleView.TREE;
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildProgressRootNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildViewSettingsProvider";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildId";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeConsoleViewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setNode";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addOutput";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeConsoleViewName";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

