/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.LightResourceClassService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.augment.ManifestClass;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.color.ColorSelector;
import org.jetbrains.android.dom.drawable.DrawableSelector;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.BoolElement;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.FractionElement;
import org.jetbrains.android.dom.resources.IntegerElement;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.Plurals;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.ScalarResourceElement;
import org.jetbrains.android.dom.resources.StringArray;
import org.jetbrains.android.dom.resources.StringElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidResourceUtil");
    public static final Set<ResourceType> VALUE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, new ResourceType[]{ResourceType.COLOR, ResourceType.DIMEN, ResourceType.STRING, ResourceType.STYLE, ResourceType.ARRAY, ResourceType.PLURALS, ResourceType.ID, ResourceType.BOOL, ResourceType.INTEGER, ResourceType.FRACTION, ResourceType.LAYOUT});
    public static final Set<ResourceType> ALL_VALUE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    static final String ROOT_TAG_PROPERTY = "ROOT_TAG";
    static final String LAYOUT_WIDTH_PROPERTY = "LAYOUT_WIDTH";
    static final String LAYOUT_HEIGHT_PROPERTY = "LAYOUT_HEIGHT";
    private static final String RESOURCE_CLASS_SUFFIX = ".R";
    public static final Comparator<PsiElement> RESOURCE_ELEMENT_COMPARATOR = (e1, e2) -> {
        PsiFile file2;
        if (e1 instanceof LazyValueResourceElementWrapper && e2 instanceof LazyValueResourceElementWrapper) {
            return ((LazyValueResourceElementWrapper)e1).compareTo((LazyValueResourceElementWrapper)e2);
        }
        PsiFile file1 = e1.getContainingFile();
        int delta = AndroidResourceUtil.compareResourceFiles(file1, file2 = e2.getContainingFile());
        if (delta != 0) {
            return delta;
        }
        return e1.getTextOffset() - e2.getTextOffset();
    };

    private AndroidResourceUtil() {
    }

    @NotNull
    public static String normalizeXmlResourceValue(@NotNull String value2) {
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(0);
        }
        String string = ValueXmlHelper.escapeResourceString((String)value2, (boolean)false);
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String packageToRClass(@NotNull String packageName) {
        if (packageName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(2);
        }
        return packageName + RESOURCE_CLASS_SUFFIX;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull String resourceName, boolean onlyInOwnPackages) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(3);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(4);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(5);
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resClassName, Collections.singleton(resourceName), onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(6);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull Collection<String> resourceNames, boolean onlyInOwnPackages) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(7);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(8);
        }
        if (resourceNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiField> result2 = new ArrayList<PsiField>();
        for (PsiClass psiClass : AndroidResourceUtil.findRJavaClasses(facet, onlyInOwnPackages)) {
            AndroidResourceUtil.findResourceFieldsFromClass(psiClass, resClassName, resourceNames, result2);
        }
        PsiField[] psiFieldArray = result2.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(10);
        }
        return psiFieldArray;
    }

    private static void findResourceFieldsFromClass(@NotNull PsiClass rClass, @NotNull String resClassName, @NotNull Collection<String> resourceNames, @NotNull List<PsiField> result2) {
        PsiClass resourceTypeClass;
        if (rClass == null) {
            AndroidResourceUtil.$$$reportNull$$$0(11);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(12);
        }
        if (resourceNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(14);
        }
        if ((resourceTypeClass = rClass.findInnerClassByName(resClassName, false)) != null) {
            for (String resourceName : resourceNames) {
                String fieldName = AndroidResourceUtil.getRJavaFieldName(resourceName);
                PsiField field2 = resourceTypeClass.findFieldByName(fieldName, false);
                if (field2 == null) continue;
                result2.add(field2);
            }
        }
    }

    @NotNull
    private static Collection<? extends PsiClass> findRJavaClasses(@NotNull AndroidFacet facet, boolean onlyInOwnPackages) {
        String targetPackage;
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(15);
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        if (facet.getManifest() == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                AndroidResourceUtil.$$$reportNull$$$0(16);
            }
            return set;
        }
        if (((Boolean)StudioFlags.IN_MEMORY_R_CLASSES.get()).booleanValue()) {
            LightResourceClassService resourceClassService = ProjectSystemUtil.getProjectSystem(facet.getModule().getProject()).getLightResourceClassService();
            Collection<? extends PsiClass> collection = resourceClassService.getLightRClassesContainingModuleResources(module);
            if (collection == null) {
                AndroidResourceUtil.$$$reportNull$$$0(17);
            }
            return collection;
        }
        HashSet dependentModules = new HashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
        HashSet<PsiClass> rClasses = new HashSet<PsiClass>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        String string = targetPackage = onlyInOwnPackages ? null : AndroidManifestUtils.getPackageName(facet);
        if (targetPackage != null) {
            GlobalSearchScope[] scopes = new GlobalSearchScope[dependentModules.size()];
            int i2 = 0;
            for (Module dependentModule : dependentModules) {
                scopes[i2++] = dependentModule.getModuleScope();
            }
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(targetPackage), GlobalSearchScope.union((GlobalSearchScope[])scopes))));
        }
        for (Module dependentModule : dependentModules) {
            String dependentPackage;
            AndroidFacet dependentFacet = AndroidFacet.getInstance(dependentModule);
            if (dependentFacet == null || (dependentPackage = AndroidManifestUtils.getPackageName(dependentFacet)) == null || dependentPackage.equals(targetPackage)) continue;
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(dependentPackage), dependentModule.getModuleScope())));
        }
        HashSet<PsiClass> hashSet = rClasses;
        if (hashSet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @NotNull
    public static PsiField[] findResourceFieldsForFileResource(@NotNull PsiFile file, boolean onlyInOwnPackages) {
        AndroidFacet facet;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(19);
        }
        if ((facet = AndroidFacet.getInstance((PsiElement)file)) == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(20);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceType(file);
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(21);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceName = AndroidCommonUtils.getResourceName((String)resourceType, (String)file.getName());
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType, resourceName, onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(22);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFieldsForValueResource(XmlTag tag, boolean onlyInOwnPackages) {
        ResourceType resourceType;
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(23);
            }
            return PsiField.EMPTY_ARRAY;
        }
        ResourceFolderType fileResType = ResourceHelper.getFolderType(tag.getContainingFile());
        ResourceType resourceType2 = resourceType = fileResType == ResourceFolderType.VALUES ? AndroidResourceUtil.getResourceTypeForResourceTag(tag) : null;
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(24);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String name = tag.getAttributeValue("name");
        if (name == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(25);
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType.getName(), name, onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(26);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findStyleableAttributeFields(XmlTag tag, boolean onlyInOwnPackages) {
        XmlTag parentTag;
        String tagName = tag.getName();
        if ("declare-styleable".equals(tagName)) {
            String styleableName = tag.getAttributeValue("name");
            if (styleableName == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(27);
                }
                return PsiField.EMPTY_ARRAY;
            }
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(28);
                }
                return PsiField.EMPTY_ARRAY;
            }
            HashSet names = Sets.newHashSet();
            for (XmlTag attr : tag.getSubTags()) {
                String attrName;
                if (!"attr".equals(attr.getName()) || (attrName = attr.getAttributeValue("name")) == null) continue;
                names.add(styleableName + '_' + attrName);
            }
            if (!names.isEmpty()) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), names, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(29);
                }
                return psiFieldArray;
            }
        } else if ("attr".equals(tagName) && (parentTag = tag.getParentTag()) != null && "declare-styleable".equals(parentTag.getName())) {
            String styleName = parentTag.getAttributeValue("name");
            String attributeName = tag.getAttributeValue("name");
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet != null && styleName != null && attributeName != null) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), styleName + '_' + attributeName, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(30);
                }
                return psiFieldArray;
            }
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(31);
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getRJavaFieldName(@NotNull String resourceName) {
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(32);
        }
        if (resourceName.indexOf(46) == -1) {
            String string = resourceName;
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        String[] identifiers = resourceName.split("\\.");
        StringBuilder result2 = new StringBuilder(resourceName.length());
        int n = identifiers.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2.append(identifiers[i2]);
            if (i2 >= n - 1) continue;
            result2.append('_');
        }
        String string = result2.toString();
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static boolean isCorrectAndroidResourceName(@NotNull String resourceName) {
        String[] identifiers;
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(35);
        }
        if (resourceName.isEmpty()) {
            return false;
        }
        if (resourceName.startsWith(".") || resourceName.endsWith(".")) {
            return false;
        }
        for (String identifier : identifiers = resourceName.split("\\.")) {
            if (StringUtil.isJavaIdentifier((String)identifier)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ResourceType getResourceTypeForResourceTag(@NotNull XmlTag tag) {
        if (tag == null) {
            AndroidResourceUtil.$$$reportNull$$$0(36);
        }
        return ResourceType.fromXmlTag((Object)tag, XmlTag::getName, XmlTag::getAttributeValue);
    }

    @Nullable
    public static String getResourceClassName(@NotNull PsiField field2) {
        PsiClass parentClass;
        PsiClass resourceClass;
        if (field2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(37);
        }
        if ((resourceClass = field2.getContainingClass()) != null && (parentClass = resourceClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && parentClass.getContainingClass() == null) {
            return resourceClass.getName();
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        AndroidFacet facet;
        if (field2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(38);
        }
        List<PsiElement> list = (facet = AndroidFacet.getInstance((PsiElement)field2)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager().findResourcesByField(field2) : Collections.emptyList();
        if (list == null) {
            AndroidResourceUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    public static boolean isResourceField(@NotNull PsiField field2) {
        AndroidFacet facet;
        PsiClass rClass;
        if (field2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(40);
        }
        if ((rClass = field2.getContainingClass()) == null) {
            return false;
        }
        return (rClass = rClass.getContainingClass()) != null && "R".equals(rClass.getName()) && (facet = AndroidFacet.getInstance((PsiElement)field2)) != null && AndroidResourceUtil.isRJavaClass(rClass);
    }

    public static boolean isStringResource(@NotNull XmlTag tag) {
        if (tag == null) {
            AndroidResourceUtil.$$$reportNull$$$0(41);
        }
        return tag.getName().equals("string") && tag.getAttribute("name") != null;
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttributeValue value2) {
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(42);
        }
        if (value2.getParent() instanceof XmlAttribute) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findIdFields((XmlAttribute)value2.getParent());
            if (psiFieldArray == null) {
                AndroidResourceUtil.$$$reportNull$$$0(43);
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(44);
        }
        return PsiField.EMPTY_ARRAY;
    }

    public static boolean isIdDeclaration(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@+id/");
    }

    public static boolean isIdReference(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@id/");
    }

    public static boolean isIdDeclaration(@NotNull XmlAttributeValue value2) {
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(45);
        }
        return AndroidResourceUtil.isIdDeclaration(value2.getValue());
    }

    public static boolean isConstraintReferencedIds(@Nullable String nsURI, @Nullable String nsPrefix, @Nullable String key) {
        return "http://schemas.android.com/apk/res-auto".equals(nsURI) && "app".equals(nsPrefix) && "constraint_referenced_ids".equals(key);
    }

    public static boolean isConstraintReferencedIds(@NotNull XmlAttributeValue value2) {
        PsiElement parent;
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(46);
        }
        if ((parent = value2.getParent()) instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            String nsURI = xmlAttribute.getNamespace();
            String nsPrefix = xmlAttribute.getNamespacePrefix();
            String key = xmlAttribute.getLocalName();
            return AndroidResourceUtil.isConstraintReferencedIds(nsURI, nsPrefix, key);
        }
        return false;
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttribute attribute) {
        AndroidFacet facet;
        String id;
        if (attribute == null) {
            AndroidResourceUtil.$$$reportNull$$$0(47);
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        String value2 = attribute.getValue();
        if (valueElement != null && value2 != null && AndroidResourceUtil.isIdDeclaration(valueElement) && (id = AndroidResourceUtil.getResourceNameByReferenceText(value2)) != null && (facet = AndroidFacet.getInstance((PsiElement)attribute)) != null) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.ID.getName(), id, false);
            if (psiFieldArray == null) {
                AndroidResourceUtil.$$$reportNull$$$0(48);
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(49);
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getValidResourceFileName(@NotNull String base) {
        if (base == null) {
            AndroidResourceUtil.$$$reportNull$$$0(50);
        }
        String string = StringUtil.toLowerCase((String)base.replace('-', '_').replace(' ', '_'));
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    public static String getResourceNameByReferenceText(@NotNull String text) {
        int i2;
        if (text == null) {
            AndroidResourceUtil.$$$reportNull$$$0(52);
        }
        if ((i2 = text.indexOf(47)) < text.length() - 1) {
            return text.substring(i2 + 1);
        }
        return null;
    }

    @NotNull
    public static ResourceElement addValueResource(@NotNull ResourceType resType, @NotNull Resources resources, @Nullable String value2) {
        if (resType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(53);
        }
        if (resources == null) {
            AndroidResourceUtil.$$$reportNull$$$0(54);
        }
        switch (resType) {
            case STRING: {
                StringElement stringElement = resources.addString();
                if (stringElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(55);
                }
                return stringElement;
            }
            case PLURALS: {
                Plurals plurals = resources.addPlurals();
                if (plurals == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(56);
                }
                return plurals;
            }
            case DIMEN: {
                if (value2 != null && value2.trim().endsWith("%")) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    Item item2 = item;
                    if (item2 == null) {
                        AndroidResourceUtil.$$$reportNull$$$0(57);
                    }
                    return item2;
                }
                if (value2 != null && value2.indexOf(46) > 0) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    item.getFormat().setStringValue("float");
                    Item item3 = item;
                    if (item3 == null) {
                        AndroidResourceUtil.$$$reportNull$$$0(58);
                    }
                    return item3;
                }
                ScalarResourceElement scalarResourceElement = resources.addDimen();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(59);
                }
                return scalarResourceElement;
            }
            case COLOR: {
                ScalarResourceElement scalarResourceElement = resources.addColor();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(60);
                }
                return scalarResourceElement;
            }
            case DRAWABLE: {
                ScalarResourceElement scalarResourceElement = resources.addDrawable();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(61);
                }
                return scalarResourceElement;
            }
            case STYLE: {
                Style style = resources.addStyle();
                if (style == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(62);
                }
                return style;
            }
            case ARRAY: {
                StringArray stringArray = resources.addStringArray();
                if (stringArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(63);
                }
                return stringArray;
            }
            case INTEGER: {
                IntegerElement integerElement = resources.addInteger();
                if (integerElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(64);
                }
                return integerElement;
            }
            case FRACTION: {
                FractionElement fractionElement = resources.addFraction();
                if (fractionElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(65);
                }
                return fractionElement;
            }
            case BOOL: {
                BoolElement boolElement = resources.addBool();
                if (boolElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(66);
                }
                return boolElement;
            }
            case ID: {
                Item item = resources.addItem();
                item.getType().setValue((Object)ResourceType.ID.getName());
                Item item4 = item;
                if (item4 == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(67);
                }
                return item4;
            }
            case ATTR: {
                Attr attr = resources.addAttr();
                if (attr == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(68);
                }
                return attr;
            }
            case STYLEABLE: {
                DeclareStyleable declareStyleable = resources.addDeclareStyleable();
                if (declareStyleable == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(69);
                }
                return declareStyleable;
            }
        }
        throw new IllegalArgumentException("Incorrect resource type");
    }

    @NotNull
    public static List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType, @NotNull Collection<VirtualFile> resourceDirs) {
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(70);
        }
        if (resourceDirs == null) {
            AndroidResourceUtil.$$$reportNull$$$0(71);
        }
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        for (VirtualFile resourcesDir : resourceDirs) {
            if (resourcesDir == null || !resourcesDir.isValid()) continue;
            for (VirtualFile child : resourcesDir.getChildren()) {
                ResourceFolderType type = ResourceFolderType.getFolderType((String)child.getName());
                if (!resourceType.equals((Object)type)) continue;
                dirs.add(child);
            }
        }
        ArrayList<VirtualFile> arrayList = dirs;
        if (arrayList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    @Nullable
    public static String getDefaultResourceFileName(@NotNull ResourceType type) {
        if (type == null) {
            AndroidResourceUtil.$$$reportNull$$$0(73);
        }
        if (ResourceType.PLURALS == type || ResourceType.STRING == type) {
            return "strings.xml";
        }
        if (VALUE_RESOURCE_TYPES.contains(type)) {
            if (type == ResourceType.LAYOUT || type == ResourceType.DRAWABLE && !ApplicationManager.getApplication().isUnitTestMode()) {
                return "refs.xml";
            }
            return type.getName() + "s.xml";
        }
        if (ResourceType.ATTR == type || ResourceType.STYLEABLE == type) {
            return "attrs.xml";
        }
        return null;
    }

    @NotNull
    public static List<ResourceElement> getValueResourcesFromElement(@NotNull ResourceType resourceType, @NotNull Resources resources) {
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(74);
        }
        if (resources == null) {
            AndroidResourceUtil.$$$reportNull$$$0(75);
        }
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        switch (resourceType) {
            case STRING: {
                result2.addAll(resources.getStrings());
                break;
            }
            case PLURALS: {
                result2.addAll(resources.getPluralses());
                break;
            }
            case DRAWABLE: {
                result2.addAll(resources.getDrawables());
                break;
            }
            case COLOR: {
                result2.addAll(resources.getColors());
                break;
            }
            case DIMEN: {
                result2.addAll(resources.getDimens());
                break;
            }
            case STYLE: {
                result2.addAll(resources.getStyles());
                break;
            }
            case ARRAY: {
                result2.addAll(resources.getStringArrays());
                result2.addAll(resources.getIntegerArrays());
                result2.addAll(resources.getArrays());
                break;
            }
            case INTEGER: {
                result2.addAll(resources.getIntegers());
                break;
            }
            case FRACTION: {
                result2.addAll(resources.getFractions());
                break;
            }
            case BOOL: {
                result2.addAll(resources.getBools());
                break;
            }
        }
        for (Item item : resources.getItems()) {
            String type = (String)item.getType().getValue();
            if (!resourceType.getName().equals(type)) continue;
            result2.add(item);
        }
        ArrayList<ResourceElement> arrayList = result2;
        if (arrayList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(76);
        }
        return arrayList;
    }

    public static boolean isInResourceSubdirectory(@NotNull PsiFile file, @Nullable String resourceType) {
        PsiDirectory dir;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(77);
        }
        if ((dir = (file = file.getOriginalFile()).getContainingDirectory()) == null) {
            return false;
        }
        return AndroidResourceUtil.isResourceSubdirectory(dir, resourceType);
    }

    public static boolean isResourceSubdirectory(@NotNull PsiDirectory directory, @Nullable String resourceType) {
        if (directory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(78);
        }
        PsiDirectory dir = directory;
        String dirName = dir.getName();
        if (resourceType != null) {
            int typeLength = resourceType.length();
            int dirLength = dirName.length();
            if (dirLength < typeLength || !dirName.startsWith(resourceType) || dirLength > typeLength && dirName.charAt(typeLength) != '-') {
                return false;
            }
        }
        if ((dir = dir.getParent()) == null) {
            return false;
        }
        if ("default".equals(dir.getName())) {
            dir = dir.getParentDirectory();
        }
        return dir != null && AndroidResourceUtil.isResourceDirectory(dir);
    }

    public static boolean isLocalResourceDirectory(@NotNull VirtualFile dir, @NotNull Project project) {
        Module module;
        if (dir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(79);
        }
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(80);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)project)) != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(dir);
        }
        return false;
    }

    public static boolean isResourceFile(@NotNull VirtualFile file, @NotNull AndroidFacet facet) {
        VirtualFile parent;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(81);
        }
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(82);
        }
        VirtualFile resDir = (parent = file.getParent()) != null ? parent.getParent() : null;
        return resDir != null && ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(resDir);
    }

    public static boolean isResourceDirectory(@NotNull PsiDirectory directory) {
        PsiDirectory dir;
        VirtualFile vf;
        if (directory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(83);
        }
        if (AndroidResourceUtil.isLocalResourceDirectory(vf = (dir = directory).getVirtualFile(), dir.getProject())) {
            return true;
        }
        if (!"res".equals(dir.getName())) {
            return false;
        }
        if ((dir = dir.getParent()) != null) {
            if (dir.findFile("AndroidManifest.xml") != null) {
                return true;
            }
            if ((dir = dir.getParent()) != null) {
                if (AndroidResourceUtil.containsAndroidJar(dir)) {
                    return true;
                }
                if ((dir = dir.getParent()) != null) {
                    return AndroidResourceUtil.containsAndroidJar(dir);
                }
            }
        }
        return false;
    }

    private static boolean containsAndroidJar(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(84);
        }
        return psiDirectory.findFile("android.jar") != null;
    }

    public static boolean isRJavaClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AndroidResourceUtil.$$$reportNull$$$0(85);
        }
        if (((Boolean)StudioFlags.IN_MEMORY_R_CLASSES.get()).booleanValue()) {
            return psiClass instanceof AndroidRClassBase;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiClass);
        if (facet == null) {
            return false;
        }
        if (!"R".equals(psiClass.getName())) {
            return false;
        }
        if (file.getName().equals("R.java") && file instanceof PsiJavaFile) {
            String manifestPackage;
            PsiJavaFile javaFile = (PsiJavaFile)file;
            Manifest manifest = facet.getManifest();
            if (manifest != null && (manifestPackage = (String)manifest.getPackage().getValue()) != null && javaFile.getPackageName().equals(manifestPackage)) {
                return true;
            }
            for (String aPackage : AndroidUtils.getDepLibsPackages(facet.getModule())) {
                if (!javaFile.getPackageName().equals(aPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isManifestClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AndroidResourceUtil.$$$reportNull$$$0(86);
        }
        if (((Boolean)StudioFlags.IN_MEMORY_R_CLASSES.get()).booleanValue()) {
            return psiClass instanceof ManifestClass;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiClass);
        if (facet == null) {
            return false;
        }
        if (!"Manifest".equals(psiClass.getName())) {
            return false;
        }
        if (file.getName().equals("Manifest.java") && file instanceof PsiJavaFile) {
            Manifest manifest = facet.getManifest();
            PsiJavaFile javaFile = (PsiJavaFile)file;
            return manifest != null && javaFile.getPackageName().equals(manifest.getPackage().getValue());
        }
        return false;
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @Nullable String resourceValue2, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull Processor<ResourceElement> afterAddedProcessor) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(87);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(88);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(89);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(90);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(91);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(92);
        }
        if (afterAddedProcessor == null) {
            AndroidResourceUtil.$$$reportNull$$$0(93);
        }
        try {
            return AndroidResourceUtil.addValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, resourceValue2, afterAddedProcessor);
        }
        catch (Exception e) {
            String message = CreateElementActionBase.filterMessage((String)e.getMessage());
            if (message == null || message.isEmpty()) {
                LOG.error((Throwable)e);
            } else {
                LOG.info((Throwable)e);
                AndroidUtils.reportError(project, message);
            }
            return false;
        }
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value2) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(94);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(95);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(96);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(97);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(98);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(99);
        }
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(100);
        }
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, value2, null);
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value2, @Nullable List<ResourceElement> outTags) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(101);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(102);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(103);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(104);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(105);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(106);
        }
        if (value2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(107);
        }
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, value2, resourceType, fileName, dirNames, (Processor<ResourceElement>)((Processor)element -> {
            if (!value2.isEmpty()) {
                String s = resourceType == ResourceType.STRING ? AndroidResourceUtil.normalizeXmlResourceValue(value2) : value2;
                element.setStringValue(s);
            } else if (resourceType == ResourceType.STYLEABLE || resourceType == ResourceType.STYLE) {
                element.setStringValue("value");
                element.getXmlTag().getValue().setText("");
            }
            if (outTags != null) {
                outTags.add((ResourceElement)element);
            }
            return true;
        }));
    }

    private static boolean addValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @Nullable String resourceValue2, @NotNull Processor<ResourceElement> afterAddedProcessor) throws Exception {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(108);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(109);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(110);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(111);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(112);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(113);
        }
        if (afterAddedProcessor == null) {
            AndroidResourceUtil.$$$reportNull$$$0(114);
        }
        if (dirNames.isEmpty()) {
            return false;
        }
        VirtualFile[] resFiles = new VirtualFile[dirNames.size()];
        int n = dirNames.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String dirName = dirNames.get(i2);
            resFiles[i2] = (VirtualFile)WriteAction.compute(() -> AndroidResourceUtil.findOrCreateResourceFile(project, resDir, fileName, dirName));
            if (resFiles[i2] != null) continue;
            return false;
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])resFiles)) {
            return false;
        }
        Resources[] resourcesElements = new Resources[resFiles.length];
        for (int i3 = 0; i3 < resFiles.length; ++i3) {
            Resources resources = AndroidUtils.loadDomElement(project, resFiles[i3], Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i3] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.length);
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY)).withName("Add Resource").run(() -> {
            for (Resources resources : resourcesElements) {
                ResourceElement element = AndroidResourceUtil.addValueResource(resourceType, resources, resourceValue2);
                element.getName().setValue((Object)resourceName);
                afterAddedProcessor.process((Object)element);
            }
        });
        return true;
    }

    public static boolean changeValueResource(final @NotNull Project project, @NotNull VirtualFile resDir, final @NotNull String name, final @NotNull ResourceType resourceType, final @NotNull String newValue, @NotNull String fileName, @NotNull List<String> dirNames, final boolean useGlobalCommand) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(115);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(116);
        }
        if (name == null) {
            AndroidResourceUtil.$$$reportNull$$$0(117);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(118);
        }
        if (newValue == null) {
            AndroidResourceUtil.$$$reportNull$$$0(119);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(120);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(121);
        }
        if (dirNames.isEmpty()) {
            return false;
        }
        ArrayList resFiles = Lists.newArrayListWithExpectedSize((int)dirNames.size());
        for (String dirName : dirNames) {
            VirtualFile resFile = AndroidResourceUtil.findResourceFile(resDir, fileName, dirName);
            if (resFile == null) continue;
            resFiles.add(resFile);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(project, resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.size()];
        for (int i2 = 0; i2 < resFiles.size(); ++i2) {
            Resources resources = AndroidUtils.loadDomElement(project, (VirtualFile)resFiles.get(i2), Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i2] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files2 = psiFiles.toArray(PsiFile.EMPTY_ARRAY);
        WriteCommandAction<Boolean> action2 = new WriteCommandAction<Boolean>(project, "Change " + resourceType.getName() + " Resource", files2){

            protected void run(@NotNull Result<Boolean> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (useGlobalCommand) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                result2.setResult((Object)false);
                for (Resources resources : resourcesElements) {
                    for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources)) {
                        String value2 = element.getName().getStringValue();
                        if (!name.equals(value2)) continue;
                        element.setStringValue(newValue);
                        result2.setResult((Object)true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$1", "run"));
            }
        };
        return (Boolean)action2.execute().getResultObject();
    }

    @Nullable
    private static VirtualFile findResourceFile(@NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) {
        VirtualFile dir;
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(122);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(123);
        }
        if (dirName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(124);
        }
        if ((dir = resDir.findChild(dirName)) == null) {
            return null;
        }
        return dir.findChild(fileName);
    }

    @Nullable
    private static VirtualFile findOrCreateResourceFile(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) throws Exception {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(125);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(126);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(127);
        }
        if (dirName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(128);
        }
        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
        if (dir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.dir.error", dirPath));
            return null;
        }
        VirtualFile file = dir.findChild(fileName);
        if (file != null) {
            return file;
        }
        AndroidFileTemplateProvider.createFromTemplate(project, dir, "valueResourceFile.xml", fileName);
        VirtualFile result2 = dir.findChild(fileName);
        if (result2 == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.file.error", dirPath + File.separatorChar + fileName));
        }
        return result2;
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, boolean localOnly) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(129);
        }
        if (exp == null) {
            AndroidResourceUtil.$$$reportNull$$$0(130);
        }
        return AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, null, localOnly);
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, @Nullable String className, boolean localOnly) {
        String resFieldName;
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(131);
        }
        if (exp == null) {
            AndroidResourceUtil.$$$reportNull$$$0(132);
        }
        if ((resFieldName = exp.getReferenceName()) == null || resFieldName.isEmpty()) {
            return null;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression resClassReference = (PsiReferenceExpression)qExp;
        String resClassName = resClassReference.getReferenceName();
        if (resClassName == null || resClassName.isEmpty() || className != null && !className.equals(resClassName)) {
            return null;
        }
        qExp = resClassReference.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolvedElement = ((PsiReferenceExpression)qExp).resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return null;
        }
        Module resolvedModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)resolvedElement);
        PsiClass aClass = (PsiClass)resolvedElement;
        String classShortName = aClass.getName();
        boolean fromManifest = "Manifest".equals(classShortName);
        if (!fromManifest && !"R".equals(classShortName)) {
            return null;
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        if (!localOnly && ("android.R".equals(qName) || "com.android.internal.R".equals(qName))) {
            return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, ResourceNamespace.ANDROID, false);
        }
        if (fromManifest ? !AndroidResourceUtil.isManifestClass(aClass) : !AndroidResourceUtil.isRJavaClass(aClass)) {
            return null;
        }
        return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, AndroidResourceUtil.getRClassNamespace(facet, qName), fromManifest);
    }

    @NotNull
    public static ResourceNamespace getRClassNamespace(@NotNull AndroidFacet facet, String qName) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(133);
        }
        ResourceNamespace resourceNamespace = ResourceRepositoryManager.getOrCreateInstance(facet).getNamespacing() == AaptOptions.Namespacing.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)StringUtil.getPackageName((String)qName));
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        if (resourceNamespace2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(134);
        }
        return resourceNamespace2;
    }

    public static int compareResourceFiles(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        if (file1 != null && file1.equals(file2) || file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            VirtualFile parent1 = file1.getParent();
            VirtualFile parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getPath().compareTo(file2.getPath());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static int compareResourceFiles(@Nullable PsiFile file1, @Nullable PsiFile file2) {
        if (file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            PsiDirectory parent1 = file1.getParent();
            PsiDirectory parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && parent1 != parent2) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getName().compareTo(file2.getName());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(135);
        }
        if (files2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(136);
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files2).hasReadonlyFiles();
    }

    @NotNull
    public static Map<VirtualFile, AndroidFacet> getResourceDirectoriesForFacets(@NotNull List<AndroidFacet> facets) {
        if (facets == null) {
            AndroidResourceUtil.$$$reportNull$$$0(137);
        }
        HashMap<VirtualFile, AndroidFacet> resDirectories = new HashMap<VirtualFile, AndroidFacet>();
        for (AndroidFacet facet : facets) {
            for (VirtualFile resourceDir : ResourceFolderManager.getInstance(facet).getFolders()) {
                if (resDirectories.containsKey(resourceDir)) continue;
                resDirectories.put(resourceDir, facet);
            }
        }
        HashMap<VirtualFile, AndroidFacet> hashMap = resDirectories;
        if (hashMap == null) {
            AndroidResourceUtil.$$$reportNull$$$0(138);
        }
        return hashMap;
    }

    @NotNull
    public static XmlFile createFileResource(@NotNull String fileName, @NotNull PsiDirectory resSubdir, @NotNull String rootTagName, @NotNull String resourceType, boolean valuesResourceFile) throws Exception {
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(139);
        }
        if (resSubdir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(140);
        }
        if (rootTagName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(141);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(142);
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)resSubdir.getProject());
        String templateName = AndroidResourceUtil.getTemplateName(resourceType, valuesResourceFile, rootTagName);
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        Properties properties = new Properties();
        if (!valuesResourceFile) {
            properties.setProperty(ROOT_TAG_PROPERTY, rootTagName);
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resSubdir);
            AndroidPlatform platform = module != null ? AndroidPlatform.getInstance(module) : null;
            int apiLevel = platform != null ? platform.getApiLevel() : -1;
            String value2 = apiLevel == -1 || apiLevel >= 8 ? "match_parent" : "fill_parent";
            properties.setProperty(LAYOUT_WIDTH_PROPERTY, value2);
            properties.setProperty(LAYOUT_HEIGHT_PROPERTY, value2);
        }
        PsiElement createdElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)resSubdir);
        assert (createdElement instanceof XmlFile);
        XmlFile xmlFile = (XmlFile)createdElement;
        if (xmlFile == null) {
            AndroidResourceUtil.$$$reportNull$$$0(143);
        }
        return xmlFile;
    }

    private static String getTemplateName(@NotNull String resourceType, boolean valuesResourceFile, @NotNull String rootTagName) {
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(144);
        }
        if (rootTagName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(145);
        }
        if (valuesResourceFile) {
            return "valueResourceFile.xml";
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType) && !"layout".equals(rootTagName) && !"merge".equals(rootTagName)) {
            return "LinearLayout".equals(rootTagName) ? "layoutResourceFile_vertical.xml" : "layoutResourceFile.xml";
        }
        if (ResourceType.NAVIGATION.getName().equals(resourceType)) {
            return "navigationResourceFile.xml";
        }
        return "resourceFile.xml";
    }

    @NotNull
    public static String getFieldNameByResourceName(@NotNull String styleName) {
        if (styleName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(146);
        }
        int n = styleName.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = styleName.charAt(i2);
            if (c != '.' && c != '-' && c != ':') continue;
            String string = styleName.replace('.', '_').replace('-', '_').replace(':', '_');
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(147);
            }
            return string;
        }
        String string = styleName;
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(148);
        }
        return string;
    }

    @Nullable
    public static List<VirtualFile> findOrCreateStateListFiles(final @NotNull Project project, final @NotNull VirtualFile resDir, final @NotNull ResourceFolderType folderType, final @NotNull ResourceType resourceType, final @NotNull String stateListName, final @NotNull List<String> dirNames) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(149);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(150);
        }
        if (folderType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(151);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(152);
        }
        if (stateListName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(153);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(154);
        }
        final PsiManager manager = PsiManager.getInstance((Project)project);
        final ArrayList files2 = Lists.newArrayListWithCapacity((int)dirNames.size());
        boolean foundFiles = (Boolean)new WriteCommandAction<Boolean>(project, "Find statelists files", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result2) {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                result2.setResult((Object)true);
                try {
                    String fileName = stateListName;
                    if (!stateListName.endsWith(".xml")) {
                        fileName = fileName + ".xml";
                    }
                    for (String dirName : dirNames) {
                        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
                        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
                        if (dir == null) {
                            throw new IOException("cannot make " + resDir + File.separatorChar + dirName);
                        }
                        VirtualFile file = dir.findChild(fileName);
                        if (file != null) {
                            files2.add(file);
                            continue;
                        }
                        PsiDirectory directory = manager.findDirectory(dir);
                        if (directory == null) {
                            throw new IOException("cannot find " + resDir + File.separatorChar + dirName);
                        }
                        AndroidResourceUtil.createFileResource(fileName, directory, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(folderType), resourceType.getName(), false);
                        file = dir.findChild(fileName);
                        if (file == null) {
                            throw new IOException("cannot find " + Joiner.on((char)File.separatorChar).join((Object)resDir, (Object)dirPath, new Object[]{fileName}));
                        }
                        files2.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                    result2.setResult((Object)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$2", "run"));
            }
        }.execute().getResultObject();
        return foundFiles ? files2 : null;
    }

    public static void updateStateList(@NotNull Project project, final @NotNull StateList stateList, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(155);
        }
        if (stateList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(156);
        }
        if (files2 == null) {
            AndroidResourceUtil.$$$reportNull$$$0(157);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(project, files2)) {
            return;
        }
        ArrayList psiFiles = Lists.newArrayListWithCapacity((int)files2.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files2) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        final ArrayList selectors = Lists.newArrayListWithCapacity((int)files2.size());
        Class selectorClass = stateList.getFolderType() == ResourceFolderType.COLOR ? ColorSelector.class : DrawableSelector.class;
        for (VirtualFile file : files2) {
            AndroidDomElement selector = AndroidUtils.loadDomElement(project, file, selectorClass);
            if (selector == null) {
                AndroidUtils.reportError(project, file.getName() + " is not a statelist file");
                return;
            }
            selectors.add(selector);
        }
        new WriteCommandAction.Simple(project, "Change State List", psiFiles.toArray(PsiFile.EMPTY_ARRAY)){

            protected void run() {
                for (AndroidDomElement selector : selectors) {
                    XmlTag tag = selector.getXmlTag();
                    for (XmlTag subtag : tag.getSubTags()) {
                        subtag.delete();
                    }
                    for (StateListState state : stateList.getStates()) {
                        XmlTag child = tag.createChildTag("item", tag.getNamespace(), null, false);
                        child = tag.addSubTag(child, false);
                        Map<String, Boolean> attributes = state.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            child.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", attributes.get(attributeName).toString());
                        }
                        if (!StringUtil.isEmpty((String)state.getAlpha())) {
                            child.setAttribute("alpha", "http://schemas.android.com/apk/res/android", state.getAlpha());
                        }
                        if (selector instanceof ColorSelector) {
                            child.setAttribute("color", "http://schemas.android.com/apk/res/android", state.getValue());
                            continue;
                        }
                        if (!(selector instanceof DrawableSelector)) continue;
                        child.setAttribute("drawable", "http://schemas.android.com/apk/res/android", state.getValue());
                    }
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.execute();
    }

    @NotNull
    public static String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(158);
        }
        if (namespaceUri == null) {
            AndroidResourceUtil.$$$reportNull$$$0(159);
        }
        XmlTag rootTag = file.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        if (StringUtil.isEmpty((String)namespaceUri)) {
            if ("" == null) {
                AndroidResourceUtil.$$$reportNull$$$0(160);
            }
            return "";
        }
        String prefix = rootTag.getPrefixByNamespace(namespaceUri);
        if (prefix != null) {
            String string = prefix;
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(161);
            }
            return string;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        prefix = suggestedPrefix != null ? suggestedPrefix : ("http://schemas.android.com/tools".equals(namespaceUri) ? "tools" : ("http://schemas.android.com/apk/res/android".equals(namespaceUri) ? "android" : ("http://schemas.android.com/aapt".equals(namespaceUri) ? "aapt" : "app")));
        if (rootTag.getAttribute("xmlns:" + prefix) != null) {
            String base = prefix;
            int i2 = 2;
            while (true) {
                prefix = base + Integer.toString(i2);
                if (rootTag.getAttribute("xmlns:" + prefix) == null) break;
                ++i2;
            }
        }
        String name = "xmlns:" + prefix;
        XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(name, namespaceUri);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute next = attributes.length > 0 ? attributes[0] : null;
        for (XmlAttribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (attributeName.startsWith("xmlns:") && attributeName.compareTo(name) <= 0) continue;
            next = attribute;
            break;
        }
        if (next != null) {
            rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)next);
        } else {
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String string = prefix;
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(162);
        }
        return string;
    }

    static {
        ALL_VALUE_RESOURCE_TYPES.addAll(VALUE_RESOURCE_TYPES);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.ATTR);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.STYLEABLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 134: 
            case 138: 
            case 143: 
            case 147: 
            case 148: 
            case 160: 
            case 161: 
            case 162: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 134: 
            case 138: 
            case 143: 
            case 147: 
            case 148: 
            case 160: 
            case 161: 
            case 162: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 134: 
            case 138: 
            case 143: 
            case 147: 
            case 148: 
            case 160: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidResourceUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 82: 
            case 129: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
            case 5: 
            case 32: 
            case 35: 
            case 89: 
            case 96: 
            case 103: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceNames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 77: 
            case 81: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 54: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 70: 
            case 74: 
            case 90: 
            case 97: 
            case 104: 
            case 111: 
            case 118: 
            case 142: 
            case 144: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirs";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 78: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: 
            case 87: 
            case 94: 
            case 101: 
            case 108: 
            case 115: 
            case 125: 
            case 135: 
            case 149: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 88: 
            case 95: 
            case 102: 
            case 109: 
            case 116: 
            case 122: 
            case 126: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDir";
                break;
            }
            case 91: 
            case 98: 
            case 105: 
            case 112: 
            case 120: 
            case 123: 
            case 127: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 92: 
            case 99: 
            case 106: 
            case 113: 
            case 121: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 93: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterAddedProcessor";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 124: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 136: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resSubdir";
                break;
            }
            case 141: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleName";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateListName";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateList";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidResourceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeXmlResourceValue";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFields";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findRJavaClasses";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFieldsForFileResource";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFieldsForValueResource";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findStyleableAttributeFields";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRJavaFieldName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdFields";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidResourceFileName";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "addValueResource";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourcesFromElement";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getRClassNamespace";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectoriesForFacets";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileResource";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldNameByResourceName";
                break;
            }
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureNamespaceImported";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeXmlResourceValue";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 134: 
            case 138: 
            case 143: 
            case 147: 
            case 148: 
            case 160: 
            case 161: 
            case 162: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packageToRClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFields";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFieldsFromClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRJavaClasses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFieldsForFileResource";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRJavaFieldName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectAndroidResourceName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypeForResourceTag";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getResourceClassName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isResourceField";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isStringResource";
                break;
            }
            case 42: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findIdFields";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isIdDeclaration";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isConstraintReferencedIds";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getValidResourceFileName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNameByReferenceText";
                break;
            }
            case 53: 
            case 54: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addValueResource";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResourceFileName";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourcesFromElement";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isInResourceSubdirectory";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isResourceSubdirectory";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isLocalResourceDirectory";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDirectory";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "containsAndroidJar";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isRJavaClass";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isManifestClass";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "createValueResource";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "changeValueResource";
                break;
            }
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFile";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateResourceFile";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getReferredResourceOrManifestField";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getRClassNamespace";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirectoriesForFacets";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "createFileResource";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateName";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getFieldNameByResourceName";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateStateListFiles";
                break;
            }
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "updateStateList";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespaceImported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 76: 
            case 134: 
            case 138: 
            case 143: 
            case 147: 
            case 148: 
            case 160: 
            case 161: 
            case 162: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyReferredResourceFieldInfo {
        @NotNull
        private final String myClassName;
        @NotNull
        private final String myFieldName;
        @Nullable
        private final Module myResolvedModule;
        @NotNull
        private final ResourceNamespace myNamespace;
        private final boolean myFromManifest;

        public MyReferredResourceFieldInfo(@NotNull String className, @NotNull String fieldName, @Nullable Module resolvedModule, @NotNull ResourceNamespace namespace, boolean fromManifest) {
            if (className == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(1);
            }
            if (namespace == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(2);
            }
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.myNamespace = namespace;
            this.myResolvedModule = resolvedModule;
            this.myFromManifest = fromManifest;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFieldName() {
            String string = this.myFieldName;
            if (string == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            ResourceNamespace resourceNamespace = this.myNamespace;
            if (resourceNamespace == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(5);
            }
            return resourceNamespace;
        }

        @Nullable
        public Module getResolvedModule() {
            return this.myResolvedModule;
        }

        public boolean isFromManifest() {
            return this.myFromManifest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

