/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class UserDeviceManager
implements Disposable {
    private final VirtualFileListener myListener = new VirtualFileListener(){

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            VirtualFile file = event.getFile();
            if (UserDeviceManager.this.myUserDevicesFile != null && "devices.xml".equals(file.getName()) && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)UserDeviceManager.this.myUserDevicesFile.getPath()), (String)file.getPath())) {
                UserDeviceManager.this.userDevicesChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/UserDeviceManager$1", "contentsChanged"));
        }
    };
    private boolean myUserDevicesParsed;
    private File myUserDevicesFile;
    private static Set<String> ourWatchedRoots = new HashSet();

    public UserDeviceManager() {
        LocalFileSystem.getInstance().addVirtualFileListener(this.myListener);
    }

    protected void userDevicesChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Device> parseUserDevices(@NotNull ILogger logger) {
        File userDevicesFile;
        if (logger == null) {
            UserDeviceManager.$$$reportNull$$$0(0);
        }
        if ((userDevicesFile = this.getUserDevicesFile(logger)) == null) {
            List<Device> list = Collections.emptyList();
            if (list == null) {
                UserDeviceManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile vUserDeviceFile = LocalFileSystem.getInstance().findFileByIoFile(userDevicesFile);
        if (vUserDeviceFile == null) {
            List<Device> list = Collections.emptyList();
            if (list == null) {
                UserDeviceManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<Device> userDevices = new ArrayList<Device>();
        try {
            if (userDevicesFile.exists()) {
                userDevices.addAll(DeviceParser.parse((File)userDevicesFile).values());
            }
        }
        catch (SAXException e) {
            if (this.myUserDevicesParsed) {
                logger.error((Throwable)e, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
            } else {
                String newName2 = userDevicesFile.getAbsoluteFile() + ".old";
                File renamedConfig = new File(newName2);
                int i2 = 0;
                while (renamedConfig.exists()) {
                    renamedConfig = new File(newName2 + '.' + i2);
                    ++i2;
                }
                logger.error((Throwable)e, "Error parsing " + userDevicesFile.getAbsolutePath() + ", backing up to " + renamedConfig.getAbsolutePath(), new Object[0]);
                if (!userDevicesFile.renameTo(renamedConfig)) {
                    logger.error((Throwable)e, "Cannot rename file " + userDevicesFile.getAbsolutePath() + " to " + renamedConfig.getAbsolutePath(), new Object[0]);
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error(null, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
        }
        catch (IOException e) {
            logger.error(null, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
        }
        finally {
            this.myUserDevicesParsed = true;
        }
        ArrayList<Device> arrayList = userDevices;
        if (arrayList == null) {
            UserDeviceManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private File getUserDevicesFile(ILogger logger) {
        if (this.myUserDevicesFile == null) {
            try {
                String myFolderToStoreDevicesXml = AndroidLocation.getFolder();
                this.myUserDevicesFile = new File(myFolderToStoreDevicesXml, "devices.xml");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                logger.warning("Couldn't load user devices: " + e.getMessage(), new Object[0]);
                this.myUserDevicesFile = null;
                return null;
            }
            UserDeviceManager.addDevicesXmlWatchedRootIfNecessary(this.myUserDevicesFile);
        }
        return this.myUserDevicesFile;
    }

    private static void addDevicesXmlWatchedRootIfNecessary(@NotNull File root) {
        String path;
        if (root == null) {
            UserDeviceManager.$$$reportNull$$$0(4);
        }
        if (ourWatchedRoots.add(path = FileUtil.toSystemIndependentName((String)root.getPath()))) {
            LocalFileSystem.getInstance().addRootToWatch(path, true);
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/UserDeviceManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/UserDeviceManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUserDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseUserDevices";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDevicesXmlWatchedRootIfNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

