/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.projectmodel.Library;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.utils.SdkUtils;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private final LayoutLibrary myLayoutLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");
    private static final Map<Module, ModuleClassLoader> ourCache = ContainerUtil.createWeakMap();

    private ModuleClassLoader(@NotNull LayoutLibrary layoutLibrary, @NotNull Module module) {
        if (layoutLibrary == null) {
            ModuleClassLoader.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(1);
        }
        super(layoutLibrary.getClassLoader(), layoutLibrary.getApiLevel());
        this.myLayoutLibrary = layoutLibrary;
        this.myModuleReference = new WeakReference<Module>(module);
        ModuleClassLoader.registerResources(module);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        block15: {
            block14: {
                if (ModuleClassLoader.LOG.isDebugEnabled()) {
                    ModuleClassLoader.LOG.debug(String.format("findClass(%s)", new Object[]{name}));
                }
                module = (Module)this.myModuleReference.get();
                try {
                    if (this.myInsideJarClassLoader || module == null || !ModuleClassLoader.isResourceClassName(name)) ** GOTO lbl38
                    facet = AndroidFacet.getInstance(module);
                    if (facet == null) ** GOTO lbl36
                    repositoryManager = ResourceRepositoryManager.getOrCreateInstance(facet);
                    data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, repositoryManager);
                    if (data == null) break block14;
                    data = this.convertClass(data);
                    if (ModuleClassLoader.LOG.isDebugEnabled()) {
                        ModuleClassLoader.LOG.debug("  Defining class from AAR registry");
                    }
                    v0 = this.defineClassAndPackage(name, data, 0, data.length);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                    if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                        clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                        clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
                    }
                    if (clazz != null) {
                        if (ModuleClassLoader.LOG.isDebugEnabled()) {
                            ModuleClassLoader.LOG.debug("  Defining RecyclerView helper class");
                        }
                        v1 = this.defineClassAndPackage(name, clazz, 0, clazz.length);
                        if (v1 == null) {
                            ModuleClassLoader.$$$reportNull$$$0(4);
                        }
                        return v1;
                    }
                    ModuleClassLoader.LOG.debug((Throwable)e);
                    throw e;
                }
                if (v0 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(2);
                }
                return v0;
            }
            break block15;
lbl36:
            // 1 sources

            if (ModuleClassLoader.LOG.isDebugEnabled()) {
                ModuleClassLoader.LOG.debug("  LocalResourceRepositoryInstance not found");
            }
        }
        if (ModuleClassLoader.LOG.isDebugEnabled()) {
            ModuleClassLoader.LOG.debug(String.format("  super.findClass(%s)", new Object[]{LogAnonymizerUtil.anonymizeClassName((String)name)}));
        }
        v2 = super.findClass(name);
        if (v2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(3);
        }
        return v2;
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(@NotNull String name) throws ClassNotFoundException {
        Module module;
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name);
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(6);
            }
            return clazz;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("  ClassNotFoundException(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        boolean loadFromProject;
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(7);
        }
        if (loadFromProject = name.startsWith("android.support.constraint.solver")) {
            Class<?> clazz;
            block8: {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) break block8;
                Class<?> clazz2 = loadedClass;
                if (clazz2 == null) {
                    ModuleClassLoader.$$$reportNull$$$0(8);
                }
                return clazz2;
            }
            try {
                clazz = this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) {
                ModuleClassLoader.$$$reportNull$$$0(9);
            }
            return clazz;
        }
        Class<?> clazz = super.loadClass(name);
        if (clazz == null) {
            ModuleClassLoader.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(@NotNull Module module, @NotNull String name) {
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(12);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile classFile = ProjectSystemUtil.getModuleSystem(module).findClassFile(name);
        if (classFile == null) {
            return null;
        }
        return this.loadClassFile(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String name, @Nullable Object myCredential) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(13);
        }
        if (ModuleClassLoader.isResourceClassName(name)) {
            return false;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(name);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel().isClassFileOutOfDate(module, name, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(14);
        }
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(@NotNull String name, @NotNull VirtualFile classFile) {
        if (name == null) {
            ModuleClassLoader.$$$reportNull$$$0(15);
        }
        if (classFile == null) {
            ModuleClassLoader.$$$reportNull$$$0(16);
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = new HashMap<String, VirtualFile>();
            this.myClassFilesLastModified = new HashMap<String, ClassModificationTimestamp>();
        }
        this.myClassFiles.put(name, classFile);
        this.myClassFilesLastModified.put(name, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(name, classFile);
    }

    private static void registerResources(@NotNull Module module) {
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(17);
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        for (Library library : moduleSystem.getResolvedDependentLibraries()) {
            if (!(library instanceof ExternalLibrary) || !((ExternalLibrary)library).hasResources()) continue;
            ModuleClassLoader.registerLibraryResources(module, (ExternalLibrary)library);
        }
    }

    private static void registerLibraryResources(@NotNull Module module, @NotNull ExternalLibrary library) {
        ResourceNamespace resourcesNamespace;
        LocalResourceRepository rClassContents;
        String packageName;
        AndroidFacet facet;
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(18);
        }
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(19);
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(facet);
        LocalResourceRepository appResources = repositoryManager.getAppResources(true);
        ResourceClassRegistry registry = ResourceClassRegistry.get(module.getProject());
        if (repositoryManager.getNamespacing() == AaptOptions.Namespacing.DISABLED) {
            packageName = ModuleClassLoader.getPackageName(library);
            if (packageName == null) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            LocalResourceRepository aarResources = repositoryManager.findLibraryResources(library);
            if (!(aarResources instanceof SingleNamespaceResourceRepository)) {
                return;
            }
            rClassContents = aarResources;
            SingleNamespaceResourceRepository resources = (SingleNamespaceResourceRepository)aarResources;
            resourcesNamespace = resources.getNamespace();
            packageName = resources.getPackageName();
        }
        registry.addLibrary((ResourceRepository)rClassContents, ResourceIdManager.get(module), packageName, resourcesNamespace);
    }

    @Nullable
    private static String getPackageName(@NotNull ExternalLibrary library) {
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(20);
        }
        if (library.getPackageName() != null) {
            return library.getPackageName();
        }
        PathString manifestFile = library.getManifestFile();
        if (manifestFile != null) {
            try {
                return AndroidManifestUtils.getPackageNameFromManifestFile(manifestFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<URL> getExternalJars() {
        URL customWidgetsUrl;
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            List<URL> list = Collections.emptyList();
            if (list == null) {
                ModuleClassLoader.$$$reportNull$$$0(21);
            }
            return list;
        }
        ArrayList<URL> result2 = new ArrayList<URL>();
        if (((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue() && (customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl()) != null) {
            result2.add(customWidgetsUrl);
        }
        ModuleClassLoader.getExternalLibraryJars(module).filter(file -> "jar".equals(Files.getFileExtension((String)file.getName())) && file.exists()).forEach(jarFile -> ModuleClassLoader.addFileUrl(jarFile, result2));
        ArrayList<URL> arrayList = result2;
        if (arrayList == null) {
            ModuleClassLoader.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static Stream<File> getExternalLibraryJars(@NotNull Module module) {
        AndroidModel model;
        AndroidFacet facet;
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(23);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null && facet.requiresAndroidModel() && (model = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            Stream<File> stream = model.getClassJarProvider().getModuleExternalLibraries(module).stream();
            if (stream == null) {
                ModuleClassLoader.$$$reportNull$$$0(24);
            }
            return stream;
        }
        Stream<File> stream = AndroidRootUtil.getExternalLibraries(module).stream().map(VfsUtilCore::virtualToIoFile);
        if (stream == null) {
            ModuleClassLoader.$$$reportNull$$$0(25);
        }
        return stream;
    }

    private static void addFileUrl(@NotNull File file, @NotNull List<URL> result2) {
        if (file == null) {
            ModuleClassLoader.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            ModuleClassLoader.$$$reportNull$$$0(27);
        }
        try {
            result2.add(SdkUtils.fileToUrl((File)file));
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(28);
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        ModuleClassLoader loader;
        if (library == null) {
            ModuleClassLoader.$$$reportNull$$$0(29);
        }
        if (module == null) {
            ModuleClassLoader.$$$reportNull$$$0(30);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ModuleClassLoader.get(%s)", LogAnonymizerUtil.anonymize((Module)module)));
        }
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            loader = ourCache.get(module);
        }
        if (loader != null) {
            if (library != loader.myLayoutLibrary) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because the layout library has changed");
                }
                loader = null;
            } else if (!loader.isUpToDate()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because some files have changed");
                }
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Recreating jar class loader because dependencies have changed.");
                    }
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  New class loader");
            }
            loader = new ModuleClassLoader(library, module);
            map2 = ourCache;
            synchronized (map2) {
                ourCache.put(module, loader);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("  Re-used class loader");
        }
        ModuleClassLoader moduleClassLoader = loader;
        if (moduleClassLoader == null) {
            ModuleClassLoader.$$$reportNull$$$0(31);
        }
        return moduleClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            ourCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(Module module) {
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            ourCache.remove(module);
        }
    }

    public boolean isClassLoaded(@NotNull String className) {
        if (className == null) {
            ModuleClassLoader.$$$reportNull$$$0(32);
        }
        return this.findLoadedClass(className) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLibrary";
                break;
            }
            case 1: 
            case 11: 
            case 17: 
            case 18: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 19: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ModuleClassLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalJars";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraryJars";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromModuleOrDependency";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSourceModified";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClassName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerResources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryResources";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExternalLibraryJars";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addFileUrl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getClassFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isClassLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

