/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkResourceManager
extends ResourceManager {
    private final AndroidPlatform myPlatform;
    private final boolean myPublicOnly;

    public FrameworkResourceManager(@NotNull Project project, @NotNull AndroidPlatform androidPlatform, boolean publicOnly) {
        if (project == null) {
            FrameworkResourceManager.$$$reportNull$$$0(0);
        }
        if (androidPlatform == null) {
            FrameworkResourceManager.$$$reportNull$$$0(1);
        }
        super(project);
        this.myPlatform = androidPlatform;
        this.myPublicOnly = publicOnly;
    }

    @Override
    @NotNull
    public ResourceRepository getResourceRepository() {
        AndroidTargetData targetData = this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget());
        ResourceRepository frameworkResources = targetData.getFrameworkResources(false);
        Object object = frameworkResources == null ? new LocalResourceRepository.EmptyRepository(ResourceNamespace.ANDROID) : frameworkResources;
        if (object == null) {
            FrameworkResourceManager.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            FrameworkResourceManager.$$$reportNull$$$0(3);
        }
        if (name == null) {
            FrameworkResourceManager.$$$reportNull$$$0(4);
        }
        return !this.myPublicOnly || this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).isResourcePublic(type, name);
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        VirtualFile resDir = this.getResourceDir();
        HashMultimap result2 = HashMultimap.create();
        if (resDir != null) {
            result2.put(null, (Object)resDir);
        }
        HashMultimap hashMultimap = result2;
        if (hashMultimap == null) {
            FrameworkResourceManager.$$$reportNull$$$0(5);
        }
        return hashMultimap;
    }

    @Nullable
    private VirtualFile getResourceDir() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            FrameworkResourceManager.$$$reportNull$$$0(6);
        }
        return dir.equals(this.getResourceDir());
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        VirtualFile dir = this.getResourceDir();
        List<Object> list = dir != null ? Collections.singletonList(dir) : Collections.emptyList();
        if (list == null) {
            FrameworkResourceManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static FrameworkResourceManager getInstance(@NotNull ConvertContext context) {
        AndroidFacet facet;
        if (context == null) {
            FrameworkResourceManager.$$$reportNull$$$0(8);
        }
        return (facet = AndroidFacet.getInstance(context)) != null ? ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager() : null;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        AttributeDefinitions attributeDefinitions = this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).getPublicAttrDefs(this.myProject);
        if (attributeDefinitions == null) {
            FrameworkResourceManager.$$$reportNull$$$0(9);
        }
        return attributeDefinitions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidPlatform";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/FrameworkResourceManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/FrameworkResourceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

