/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParentStyleUsageData
implements StyleUsageData {
    private final AndroidResourceReferenceBase myReference;
    private final Style myStyle;

    ParentStyleUsageData(@NotNull Style style, @NotNull AndroidResourceReferenceBase reference2) {
        if (style == null) {
            ParentStyleUsageData.$$$reportNull$$$0(0);
        }
        if (reference2 == null) {
            ParentStyleUsageData.$$$reportNull$$$0(1);
        }
        this.myReference = reference2;
        this.myStyle = style;
    }

    @Override
    public PsiFile getFile() {
        XmlTag tag = this.myStyle.getXmlTag();
        return tag != null ? tag.getContainingFile() : null;
    }

    @Override
    public void inline(@NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef) {
        if (attributeValues == null) {
            ParentStyleUsageData.$$$reportNull$$$0(2);
        }
        Map<String, String> id2Value = ParentStyleUsageData.toId2ValueMap(attributeValues);
        for (StyleItem styleItem : this.myStyle.getItems()) {
            String name = styleItem.getName().getStringValue();
            if (name == null) continue;
            id2Value.remove(name);
        }
        for (Map.Entry entry : id2Value.entrySet()) {
            StyleItem newItem = this.myStyle.addItem();
            newItem.getName().setStringValue((String)entry.getKey());
            newItem.setStringValue((String)entry.getValue());
        }
        String styleName = this.myStyle.getName().getStringValue();
        boolean bl = parentStyleRef != null && parentStyleRef.getStylePackage() == null && styleName != null && (styleName.startsWith(parentStyleRef.getStyleName() + ".") || styleName.equals(parentStyleRef.getStyleName()));
        this.myStyle.getParentStyle().setValue(parentStyleRef != null && !bl ? ResourceValue.referenceTo('\u0000', parentStyleRef.getStylePackage(), null, parentStyleRef.getStyleName()) : null);
    }

    private static Map<String, String> toId2ValueMap(Map<AndroidAttributeInfo, String> info2ValueMap) {
        HashMap result2 = new HashMap(info2ValueMap.size());
        for (Map.Entry<AndroidAttributeInfo, String> entry : info2ValueMap.entrySet()) {
            result2.put(entry.getKey().getAttributeId(), entry.getValue());
        }
        return result2;
    }

    @Override
    @NotNull
    public AndroidResourceReferenceBase getReference() {
        AndroidResourceReferenceBase androidResourceReferenceBase = this.myReference;
        if (androidResourceReferenceBase == null) {
            ParentStyleUsageData.$$$reportNull$$$0(3);
        }
        return androidResourceReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/ParentStyleUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/ParentStyleUsageData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

