/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.projectsystem.LightResourceClassService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StyleItemNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.CodeUsageInfo;
import org.jetbrains.android.refactoring.DomValueUsageInfo;
import org.jetbrains.android.refactoring.MigrateToResourceNamespacesKt;
import org.jetbrains.android.refactoring.MigrateToResourceNamespacesProcessor;
import org.jetbrains.android.refactoring.ResourceUsageInfo;
import org.jetbrains.android.refactoring.StyleItemUsageInfo;
import org.jetbrains.android.refactoring.XmlAttributeUsageInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0015\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020\u000fH\u0016J\u001b\u0010%\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140*H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToResourceNamespacesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "invokingFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "allFacets", "", "kotlin.jvm.PlatformType", "elementFactory", "Lcom/intellij/psi/XmlElementFactory;", "addXmlnsDeclaration", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "prefix", "", "uri", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findCodeUsages", "", "Lorg/jetbrains/android/refactoring/ResourceUsageInfo;", "findManifestUsages", "findOrCreateNamespacePrefix", "inferredPackage", "findResUsages", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "findXmlUsages", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "currentFacet", "getCommandName", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "intellij.android.core"})
public final class MigrateToResourceNamespacesProcessor
extends BaseRefactoringProcessor {
    private final List<AndroidFacet> allFacets;
    private final XmlElementFactory elementFactory;
    private final AndroidFacet invokingFacet;

    @NotNull
    public String getCommandName() {
        return "Migrate to resource namespaces";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        ProgressIndicator progressIndicator;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressIndicator");
        progressIndicator2.setText("Analyzing XML resource files...");
        boolean bl = false;
        List result2 = new ArrayList();
        Collection collection = result2;
        Iterable iterable = this.findResUsages();
        boolean bl2 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing manifest files...");
        collection = result2;
        iterable = this.findManifestUsages();
        bl2 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing code files...");
        collection = result2;
        iterable = this.findCodeUsages();
        bl2 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Inferring namespaces...");
        progressIndicator.setText2((String)null);
        boolean bl3 = false;
        List leafRepos = new ArrayList();
        ResourceRepositoryManager.getAppResources(this.invokingFacet).getLeafResourceRepositories(leafRepos);
        Table table2 = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), (Supplier)findUsages.inferredNamespaces.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)table2, (String)"Tables.newCustomTable(Ma\u2026MapOf<String, String>() }");
        Table inferredNamespaces2 = table2;
        double total = result2.size();
        Iterable $this$forEachIndexed$iv = result2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void resourceUsageInfo;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ResourceUsageInfo resourceUsageInfo2 = (ResourceUsageInfo)((Object)item$iv);
            int index = n2;
            boolean bl5 = false;
            ProgressManager.checkCanceled();
            resourceUsageInfo.setInferredPackage((String)inferredNamespaces2.row((Object)resourceUsageInfo.getResourceType()).computeIfAbsent(resourceUsageInfo.getName(), (Function)new Function<String, String>((ResourceUsageInfo)resourceUsageInfo, inferredNamespaces2, leafRepos, progressIndicator, total){
                final /* synthetic */ ResourceUsageInfo $resourceUsageInfo;
                final /* synthetic */ Table $inferredNamespaces$inlined;
                final /* synthetic */ List $leafRepos$inlined;
                final /* synthetic */ ProgressIndicator $progressIndicator$inlined;
                final /* synthetic */ double $total$inlined;
                {
                    this.$resourceUsageInfo = resourceUsageInfo;
                    this.$inferredNamespaces$inlined = table2;
                    this.$leafRepos$inlined = list;
                    this.$progressIndicator$inlined = progressIndicator;
                    this.$total$inlined = d;
                }

                @Nullable
                public final String apply(String it) {
                    for (SingleNamespaceResourceRepository repo : this.$leafRepos$inlined) {
                        if (!repo.hasResources(ResourceNamespace.RES_AUTO, this.$resourceUsageInfo.getResourceType(), this.$resourceUsageInfo.getName())) continue;
                        SingleNamespaceResourceRepository singleNamespaceResourceRepository = repo;
                        if (singleNamespaceResourceRepository == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.resources.SingleNamespaceResourceRepository");
                        }
                        return singleNamespaceResourceRepository.getPackageName();
                    }
                    return null;
                }
            }));
            progressIndicator.setFraction((double)(index + 1) / total);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ResourceUsageInfo[] resourceUsageInfoArray = thisCollection$iv.toArray(new ResourceUsageInfo[0]);
        if (resourceUsageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resourceUsageInfoArray;
    }

    private final Collection<ResourceUsageInfo> findResUsages() {
        boolean bl = false;
        List result2 = new ArrayList();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(myProject)");
        PsiManager psiManager2 = psiManager;
        for (AndroidFacet facet : this.allFacets) {
            ResourceRepositoryManager repositoryManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)ResourceRepositoryManager.getOrCreateInstance(facet), (String)"ResourceRepositoryManage\u2026etOrCreateInstance(facet)");
            if (repositoryManager.getNamespacing() != AaptOptions.Namespacing.DISABLED) continue;
            LocalResourceRepository localResourceRepository = repositoryManager.getModuleResources(true);
            if (localResourceRepository == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"repositoryManager.getModuleResources(true)!!");
            for (VirtualFile resourceDir : localResourceRepository.getResourceDirs()) {
                VfsUtil.processFilesRecursively((VirtualFile)resourceDir, (Processor)((Processor)new Processor<VirtualFile>(this, psiManager2, result2, facet){
                    final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ List $result;
                    final /* synthetic */ AndroidFacet $facet;

                    public final boolean process(VirtualFile vf) {
                        PsiFile psiFile;
                        VirtualFile virtualFile = vf;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"vf");
                        if (Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)StdFileTypes.XML) && (psiFile = this.$psiManager.findFile(vf)) instanceof XmlFile) {
                            Collection collection = this.$result;
                            XmlFile xmlFile = (XmlFile)psiFile;
                            AndroidFacet androidFacet = this.$facet;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
                            Iterable iterable = MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, xmlFile, androidFacet);
                            boolean bl = false;
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        }
                        return true;
                    }
                    {
                        this.this$0 = migrateToResourceNamespacesProcessor;
                        this.$psiManager = psiManager;
                        this.$result = list;
                        this.$facet = androidFacet;
                    }
                }));
            }
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findManifestUsages() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(myProject)");
        PsiManager psiManager2 = psiManager;
        boolean bl = false;
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            Collection collection = result2;
            List<IdeaSourceProvider> list = IdeaSourceProvider.getCurrentSourceProviders(facet);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"IdeaSourceProvider.getCu\u2026entSourceProviders(facet)");
            Sequence sequence = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)findManifestUsages.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, XmlFile>(psiManager2){
                final /* synthetic */ PsiManager $psiManager;

                @Nullable
                public final XmlFile invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    PsiFile psiFile = this.$psiManager.findFile(it);
                    if (!(psiFile instanceof XmlFile)) {
                        psiFile = null;
                    }
                    return (XmlFile)psiFile;
                }
                {
                    this.$psiManager = psiManager;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<XmlFile, Sequence<? extends ResourceUsageInfo>>(this, facet){
                final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                final /* synthetic */ AndroidFacet $facet;

                @NotNull
                public final Sequence<ResourceUsageInfo> invoke(@NotNull XmlFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    AndroidFacet androidFacet = this.$facet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
                    return CollectionsKt.asSequence((Iterable)MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, it, androidFacet));
                }
                {
                    this.this$0 = migrateToResourceNamespacesProcessor;
                    this.$facet = androidFacet;
                    super(1);
                }
            }));
            boolean bl2 = false;
            CollectionsKt.addAll((Collection)collection, (Sequence)sequence);
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findXmlUsages(XmlFile xmlFile, AndroidFacet currentFacet) {
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressIndicator");
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"xmlFile.virtualFile");
        progressIndicator2.setText2(virtualFile.getPath());
        boolean bl = false;
        List result2 = new ArrayList();
        DomManager domManager = DomManager.getDomManager((Project)this.myProject);
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getModuleResources(currentFacet);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"ResourceRepositoryManage\u2026leResources(currentFacet)");
        LocalResourceRepository moduleRepo = localResourceRepository;
        Function2<ResourceType, String, Boolean> $fun$referenceNeedsRewriting$1 = new Function2<ResourceType, String, Boolean>(moduleRepo){
            final /* synthetic */ LocalResourceRepository $moduleRepo;

            public final boolean invoke(@NotNull ResourceType resourceType, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return !this.$moduleRepo.hasResources(ResourceNamespace.RES_AUTO, resourceType, name);
            }
            {
                this.$moduleRepo = localResourceRepository;
                super(2);
            }
        };
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(domManager, result2, $fun$referenceNeedsRewriting$1){
            final /* synthetic */ DomManager $domManager;
            final /* synthetic */ List $result;
            final /* synthetic */ findXmlUsages.1 $referenceNeedsRewriting$1;

            public void visitXmlTag(@NotNull XmlTag tag) {
                Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                DomElement domElement = this.$domManager.getDomElement(tag);
                if (domElement instanceof GenericDomValue) {
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
                GenericAttributeValue domElement = this.$domManager.getDomElement(attribute);
                if (domElement instanceof GenericDomValue) {
                    if (Intrinsics.areEqual((Object)attribute.getNamespace(), (Object)"http://schemas.android.com/apk/res-auto")) {
                        Collection collection = this.$result;
                        XmlAttributeUsageInfo xmlAttributeUsageInfo = new XmlAttributeUsageInfo(attribute);
                        boolean bl = false;
                        collection.add(xmlAttributeUsageInfo);
                    }
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)attribute);
                }
                super.visitXmlAttribute(attribute);
            }

            private final void handleGenericDomValue(GenericDomValue<?> domValue, XmlElement sourceXmlElement) {
                block11: {
                    boolean bl;
                    Object object;
                    String string;
                    XmlElement psiElement;
                    block13: {
                        block12: {
                            Converter converter;
                            block10: {
                                Converter converter2 = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), domValue);
                                XmlElement xmlElement = DomUtil.getValueElement(domValue);
                                if (xmlElement == null) {
                                    return;
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement, (String)"DomUtil.getValueElement(domValue) ?: return");
                                psiElement = xmlElement;
                                converter = converter2;
                                if (!(converter instanceof ResourceReferenceConverter)) break block10;
                                for (PsiReference reference2 : psiElement.getReferences()) {
                                    String name;
                                    ResourceType resourceType;
                                    ResourceValue resourceValue2;
                                    if (!(reference2 instanceof AndroidResourceReference)) continue;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)((AndroidResourceReference)reference2).getResourceValue(), (String)"reference.resourceValue");
                                    if (resourceValue2.getPackage() != null) continue;
                                    String string2 = resourceValue2.getResourceType();
                                    if (string2 != null && StringsKt.startsWith$default((CharSequence)string2, (char)'+', (boolean)false, (int)2, null)) continue;
                                    if (StringKt.nullize((String)resourceValue2.getResourceName(), (boolean)true) == null) {
                                        continue;
                                    }
                                    if (resourceValue2.getType() == null) {
                                        continue;
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"resourceValue.type ?: continue@references");
                                    if (!this.$referenceNeedsRewriting$1.invoke(resourceType, name)) continue;
                                    Collection collection = this.$result;
                                    DomValueUsageInfo domValueUsageInfo = new DomValueUsageInfo(resourceValue2, (ResourceReferenceConverter)converter2, reference2, sourceXmlElement);
                                    boolean bl2 = false;
                                    collection.add(domValueUsageInfo);
                                }
                                break block11;
                            }
                            if (!(converter instanceof StyleItemNameConverter)) break block11;
                            string = domValue.getStringValue();
                            if (string == null) break block12;
                            object = string;
                            boolean bl3 = false;
                            bl = false;
                            String p1 = object;
                            boolean bl4 = false;
                            string = ResourceUrl.parseAttrReference((String)p1);
                            if (string != null) break block13;
                        }
                        return;
                    }
                    String url = string;
                    if (((ResourceUrl)url).namespace == null) {
                        ResourceType resourceType = ((ResourceUrl)url).type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"url.type");
                        String string3 = ((ResourceUrl)url).name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.name");
                        if (this.$referenceNeedsRewriting$1.invoke(resourceType, string3)) {
                            PsiElement psiElement2;
                            object = this.$result;
                            PsiElement $this$parentOfType$iv = (PsiElement)psiElement;
                            boolean $i$f$parentOfType = false;
                            PsiElement psiElement3 = psiElement2 = PsiTreeUtilKt.parentOfType((PsiElement)$this$parentOfType$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)});
                            if (psiElement3 == null) {
                                Intrinsics.throwNpe();
                            }
                            String string4 = url;
                            XmlAttribute xmlAttribute = (XmlAttribute)psiElement3;
                            StyleItemUsageInfo styleItemUsageInfo = new StyleItemUsageInfo(xmlAttribute, (ResourceUrl)string4);
                            bl = false;
                            object.add(styleItemUsageInfo);
                        }
                    }
                }
            }
            {
                this.$domManager = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                this.$referenceNeedsRewriting$1 = $captured_local_variable$2;
            }
        });
        progressIndicator.setText2((String)null);
        return result2;
    }

    private final Collection<ResourceUsageInfo> findCodeUsages() {
        boolean bl = false;
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            Collection<? extends PsiClass> rClasses;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ResourceRepositoryManager.getModuleResources(facet)), (String)"ResourceRepositoryManage\u2026getModuleResources(facet)");
            Project project = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
            LightResourceClassService lightResourceClassService = ProjectSystemUtil.getProjectSystem(project).getLightResourceClassService();
            AndroidFacet androidFacet = facet;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"facet");
            Intrinsics.checkExpressionValueIsNotNull(lightResourceClassService.getLightRClassesAccessibleFromModule(androidFacet.getModule(), false), (String)"myProject.getProjectSyst\u2026dule(facet.module, false)");
            Module module = facet.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
            Intrinsics.checkExpressionValueIsNotNull((Object)module.getModuleScope(), (String)"facet.module.moduleScope");
            for (PsiClass psiClass : rClasses) {
                GlobalSearchScope scope;
                Iterator iterator = ReferencesSearch.search((PsiElement)((PsiElement)psiClass), (SearchScope)((SearchScope)scope)).iterator();
                while (iterator.hasNext()) {
                    ResourceType resourceType;
                    LocalResourceRepository moduleRepo;
                    String name;
                    PsiReferenceExpression nameRef;
                    PsiReferenceExpression typeRef;
                    PsiReferenceExpression classRef;
                    PsiReference psiReference;
                    PsiReference psiReference2 = psiReference = (PsiReference)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference2, (String)"psiReference");
                    PsiElement psiElement = psiReference2.getElement();
                    if (!(psiElement instanceof PsiReferenceExpression)) {
                        psiElement = null;
                    }
                    if ((PsiReferenceExpression)psiElement == null) {
                        continue;
                    }
                    PsiElement psiElement2 = classRef.getParent();
                    if (!(psiElement2 instanceof PsiReferenceExpression)) {
                        psiElement2 = null;
                    }
                    if ((PsiReferenceExpression)psiElement2 == null) {
                        continue;
                    }
                    PsiElement psiElement3 = typeRef.getParent();
                    if (!(psiElement3 instanceof PsiReferenceExpression)) {
                        psiElement3 = null;
                    }
                    if ((PsiReferenceExpression)psiElement3 == null) {
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)nameRef.getQualifierExpression(), (Object)typeRef) ^ true || Intrinsics.areEqual((Object)typeRef.getQualifierExpression(), (Object)classRef) ^ true) continue;
                    if (nameRef.getReferenceName() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"nameRef.referenceName ?: continue");
                    String string = typeRef.getReferenceName();
                    if (string == null) {
                        continue;
                    }
                    if (ResourceType.fromClassName((String)string) == null) {
                        continue;
                    }
                    if (moduleRepo.hasResources(ResourceNamespace.RES_AUTO, resourceType, name)) continue;
                    Collection collection = result2;
                    CodeUsageInfo codeUsageInfo = new CodeUsageInfo((PsiElement)nameRef, psiReference, resourceType, name);
                    boolean bl2 = false;
                    collection.add(codeUsageInfo);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        v0 = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ProgressManager.getInstance()");
        v1 = progressIndicator = v0.getProgressIndicator();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"progressIndicator");
        v1.setIndeterminate(false);
        progressIndicator.setText("Rewriting resource references...");
        v2 = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"PsiMigrationManager.getI\u2026Project).startMigration()");
        psiMigration = v2;
        try {
            totalUsages = usages.length;
            $this$forEachIndexed$iv = usages;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (UsageInfo item$iv : $this$forEachIndexed$iv) {
                v3 = index$iv++;
                var13_19 = item$iv;
                index = v3;
                $i$a$-forEachIndexed-MigrateToResourceNamespacesProcessor$performRefactoring$1 = false;
                if (!(usageInfo instanceof ResourceUsageInfo)) {
                    var16_24 = "Don't know how to handle " + usageInfo.getClass().getName() + '.';
                    var17_28 = false;
                    throw (Throwable)new IllegalStateException(var16_24.toString());
                }
                if (((ResourceUsageInfo)usageInfo).getInferredPackage() == null) {
                    continue;
                }
                var17_27 = usageInfo;
                if (!(var17_27 instanceof DomValueUsageInfo)) ** GOTO lbl58
                xmlElement = ((DomValueUsageInfo)usageInfo).getXmlElement();
                var19_32 = xmlElement;
                if (var19_32 instanceof XmlTag) {
                    v4 = (XmlTag)xmlElement;
                } else {
                    if (!(var19_32 instanceof XmlAttribute)) continue;
                    v4 = ((XmlAttribute)xmlElement).getParent();
                }
                v5 = tag = v4;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"tag");
                namespace = this.findOrCreateNamespacePrefix(v5, inferredPackage);
                resourceValue = ((DomValueUsageInfo)usageInfo).getResourceValue();
                v6 = ((DomValueUsageInfo)usageInfo).getConverter().toString(ResourceValue.referenceTo(resourceValue.getPrefix(), (String)namespace, resourceValue.getResourceType(), resourceValue.getResourceName()), null);
                if (v6 == null) {
                    v6 = "";
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"usageInfo.converter.toSt\u2026 null\n            ) ?: \"\"");
                newStringValue = v6;
                var23_37 = xmlElement;
                if (var23_37 instanceof XmlTag) {
                    v7 = ((XmlTag)xmlElement).getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"xmlElement.value");
                    v7.setText(newStringValue);
                } else if (var23_37 instanceof XmlAttribute) {
                    ((XmlAttribute)xmlElement).setValue(newStringValue);
                } else {
                    var24_39 = "Don't know how to handle " + xmlElement;
                    var25_40 = 0;
                    throw (Throwable)new IllegalStateException(var24_39.toString());
lbl58:
                    // 1 sources

                    if (var17_27 instanceof XmlAttributeUsageInfo) {
                        block25: {
                            v8 = ((XmlAttributeUsageInfo)usageInfo).getElement();
                            if (!(v8 instanceof XmlAttribute)) {
                                v8 = null;
                            }
                            if ((XmlAttribute)v8 == null) {
                                continue;
                            }
                            v9 = element.getParent();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"element.parent");
                            prefix = this.findOrCreateNamespacePrefix(v9, inferredPackage);
                            Intrinsics.checkExpressionValueIsNotNull((Object)element.getReferences(), (String)"element.references");
                            var21_35 = false;
                            var22_36 = namespace;
                            var23_38 = false;
                            var24_39 = var22_36;
                            var25_40 = ((PsiReference[])var24_39).length;
                            for (var26_41 = 0; var26_41 < var25_40; ++var26_41) {
                                it = var27_42 = var24_39[var26_41];
                                $i$a$-find-MigrateToResourceNamespacesProcessor$performRefactoring$1$1 = false;
                                if (!(it instanceof SchemaPrefixReference)) continue;
                                v10 = var27_42;
                                break block25;
                            }
                            v10 = null;
                        }
                        if (v10 != null) {
                            v10.handleElementRename(prefix);
                        }
                    } else if (var17_27 instanceof StyleItemUsageInfo) {
                        v11 = tag = ((StyleItemUsageInfo)usageInfo).getXmlAttribute().getParent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"tag");
                        prefix = this.findOrCreateNamespacePrefix(v11, inferredPackage);
                        newUrl = ResourceUrl.create((String)prefix, (ResourceType)ResourceType.ATTR, (String)((ResourceUsageInfo)usageInfo).getName());
                        v12 = ((StyleItemUsageInfo)usageInfo).getXmlAttribute();
                        v13 = newUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"newUrl");
                        v12.setValue(v13.getQualifiedName());
                    } else if (var17_27 instanceof CodeUsageInfo) {
                        reference = ((CodeUsageInfo)usageInfo).getClassReference();
                        v14 = this.myProject;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"myProject");
                        v15 = AndroidResourceUtil.packageToRClass(inferredPackage);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"AndroidResourceUtil.pack\u2026ToRClass(inferredPackage)");
                        v16 = reference.getElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"reference.element");
                        v17 = v16.getResolveScope();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"reference.element.resolveScope");
                        reference.bindToElement((PsiElement)AndroidRefactoringUtil.findOrCreateClass(v14, psiMigration, v15, v17));
                    }
                }
                progressIndicator.setFraction((double)(index + 1) / totalUsages);
            }
        }
        finally {
            psiMigration.finish();
        }
        progressIndicator.setText("Updating Gradle build files...");
        progressIndicator.setFraction(0.0);
        v18 = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"ProjectBuildModel.get(myProject)");
        projectBuildModel = v18;
        totalFacets = this.allFacets.size();
        $this$forEachIndexed$iv = this.allFacets;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            var12_18 = index$iv++;
            var13_20 = false;
            if (var12_18 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var14_21 = var12_18;
            $i$a$-forEachIndexed-MigrateToResourceNamespacesProcessor$performRefactoring$1 = (AndroidFacet)item$iv;
            index = var14_21;
            $i$a$-forEachIndexed-MigrateToResourceNamespacesProcessor$performRefactoring$2 = false;
            v19 = facet;
            Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"facet");
            if (projectBuildModel.getModuleBuildModel(v19.getModule()) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildModel, (String)"projectBuildModel.getMod\u2026 ?: return@forEachIndexed");
            moduleBuildModel.android().aaptOptions().namespaced().setValue(true);
            moduleBuildModel.applyChanges();
            progressIndicator.setFraction((double)(index + 1) / totalFacets);
        }
        v20 = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"myProject");
        AndroidRefactoringUtil.syncBeforeFinishingRefactoring(v20);
    }

    private final String findOrCreateNamespacePrefix(XmlTag tag, String inferredPackage) {
        String string = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/" + inferredPackage);
        if (string == null) {
            boolean bl;
            MigrateToResourceNamespacesProcessor migrateToResourceNamespacesProcessor = this;
            boolean bl2 = false;
            boolean bl3 = false;
            MigrateToResourceNamespacesProcessor $this$run = migrateToResourceNamespacesProcessor;
            boolean bl4 = false;
            String newPrefix = MigrateToResourceNamespacesKt.access$choosePrefix(inferredPackage);
            String string2 = tag.getNamespaceByPrefix(newPrefix);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tag.getNamespaceByPrefix(newPrefix)");
            CharSequence charSequence = string2;
            boolean bl5 = false;
            if (charSequence.length() > 0) {
                int i2 = 2;
                while (true) {
                    String string3 = tag.getNamespaceByPrefix(newPrefix + i2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"tag.getNamespaceByPrefix(newPrefix + i)");
                    CharSequence charSequence2 = string3;
                    bl = false;
                    if (!(charSequence2.length() > 0)) break;
                    ++i2;
                }
                newPrefix = newPrefix + i2;
            }
            PsiElement $this$parentOfType$iv = (PsiElement)tag;
            boolean $i$f$parentOfType = false;
            XmlDocument xmlDocument = (XmlDocument)PsiTreeUtilKt.parentOfType((PsiElement)$this$parentOfType$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlDocument.class)});
            if (xmlDocument != null && (xmlDocument = xmlDocument.getRootTag()) != null) {
                charSequence = xmlDocument;
                bl5 = false;
                bl = false;
                CharSequence it = charSequence;
                boolean bl6 = false;
                CharSequence charSequence3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence3, (String)"it");
                $this$run.addXmlnsDeclaration((XmlTag)charSequence3, newPrefix, "http://schemas.android.com/apk/res/" + inferredPackage);
            }
            string = newPrefix;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void addXmlnsDeclaration(XmlTag tag, String prefix, String uri) {
        Object v3;
        XmlTag xmlTag;
        PsiElement psiElement;
        block1: {
            void $this$firstOrNull$iv;
            PsiElement psiElement2 = (PsiElement)this.elementFactory.createAttribute("xmlns:" + prefix, uri, (PsiElement)tag);
            XmlAttribute[] xmlAttributeArray = tag.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttributeArray, (String)"tag.attributes");
            XmlAttribute[] xmlAttributeArray2 = xmlAttributeArray;
            psiElement = psiElement2;
            xmlTag = tag;
            boolean $i$f$firstOrNull = false;
            void var6_8 = $this$firstOrNull$iv;
            int n = ((void)var6_8).length;
            for (int j = 0; j < n; ++j) {
                void element$iv;
                void it = element$iv = var6_8[j];
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                if (!(Intrinsics.areEqual((Object)v2.getNamespacePrefix(), (Object)"xmlns") ^ true)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        Object var14_14 = v3;
        xmlTag.addBefore(psiElement, (PsiElement)var14_14);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(refUsages, (String)"refUsages");
        Object object = refUsages.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"refUsages.get()");
        Object[] objectArray = (Object[])object;
        boolean bl2 = false;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        if (!(objectArray2.length == 0)) {
            bl = true;
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)"No cross-namespace resource references found", (String)"Migrate to resource namespaces");
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Resource references to migrate";
            }
        };
    }

    public MigrateToResourceNamespacesProcessor(@NotNull AndroidFacet invokingFacet) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)invokingFacet), (String)"invokingFacet");
        Module module = invokingFacet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"invokingFacet.module");
        super(module.getProject());
        this.invokingFacet = invokingFacet;
        Object t = StudioFlags.IN_MEMORY_R_CLASSES.get();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"StudioFlags.IN_MEMORY_R_CLASSES.get()");
        boolean bl = (Boolean)t;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "IN_MEMORY_R_CLASSES has to be enabled for the refactoring to work.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<AndroidFacet> list = AndroidUtils.getAllAndroidDependencies(this.invokingFacet.getModule(), true);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"AndroidUtils.getAllAndro\u2026vokingFacet.module, true)");
        this.allFacets = CollectionsKt.plus((Collection)list, (Object)((Object)this.invokingFacet));
        this.elementFactory = XmlElementFactory.getInstance((Project)this.myProject);
    }

    public static final /* synthetic */ Collection access$findXmlUsages(MigrateToResourceNamespacesProcessor $this, XmlFile xmlFile, AndroidFacet currentFacet) {
        return $this.findXmlUsages(xmlFile, currentFacet);
    }
}

