/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AndroidBaseXmlRefactoringAction
extends BaseRefactoringAction {
    AndroidBaseXmlRefactoringAction() {
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull DataContext context) {
        XmlTag[] tags2;
        if (element == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(3);
        }
        if ((tags2 = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context)).length > 0) {
            return AndroidFacet.getInstance((PsiElement)tags2[0]) != null && this.isEnabledForTags(tags2);
        }
        TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor2);
        if (range != null) {
            Pair<PsiElement, PsiElement> psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file, range.getStartOffset(), range.getEndOffset());
            return psiRange != null && this.isEnabledForPsiRange((PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
        }
        if (element == null || AndroidFacet.getInstance(element) == null || PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class) != null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        return tag != null && this.isEnabledForTags(new XmlTag[]{tag});
    }

    @Nullable
    private static TextRange getNonEmptySelectionRange(Editor editor2) {
        int end;
        int start;
        SelectionModel model;
        if (editor2 != null && (model = editor2.getSelectionModel()).hasSelection() && (start = model.getSelectionStart()) < (end = model.getSelectionEnd())) {
            return TextRange.create((int)start, (int)end);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getExtractableRange(PsiFile file, int start, int end) {
        PsiElement e;
        PsiElement parent;
        PsiElement startElement = file.findElementAt(start);
        PsiElement psiElement = parent = startElement != null ? startElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getStartOffset() == startElement.getTextRange().getStartOffset()) {
            startElement = parent;
            parent = parent.getParent();
        }
        PsiElement endElement = file.findElementAt(end - 1);
        PsiElement psiElement2 = parent = endElement != null ? endElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getEndOffset() == endElement.getTextRange().getEndOffset()) {
            endElement = parent;
            parent = parent.getParent();
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        PsiElement commonParent = startElement.getParent();
        if (commonParent == null || !(commonParent instanceof XmlTag) || commonParent != endElement.getParent()) {
            return null;
        }
        boolean containTag = false;
        for (e = startElement; e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlText || e instanceof XmlTag || e instanceof PsiWhiteSpace || e instanceof PsiComment)) {
                return null;
            }
            if (e instanceof XmlTag) {
                containTag = true;
            }
            if (e == endElement) break;
        }
        return e != null && containTag ? Pair.create((Object)startElement, (Object)endElement) : null;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(4);
        }
        if (elements.length == 0) {
            return false;
        }
        PsiElement element = elements[0];
        if (AndroidFacet.getInstance(element) == null) {
            return false;
        }
        XmlTag[] tags2 = new XmlTag[elements.length];
        for (int i2 = 0; i2 < tags2.length; ++i2) {
            if (!(elements[i2] instanceof XmlTag)) {
                return false;
            }
            tags2[i2] = (XmlTag)elements[i2];
        }
        return this.isEnabledForTags(tags2);
    }

    protected abstract boolean isEnabledForTags(@NotNull XmlTag[] var1);

    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        if (from == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language == XMLLanguage.INSTANCE;
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return file instanceof XmlFile && AndroidFacet.getInstance((PsiElement)file) != null && this.isMyFile(file);
    }

    protected abstract boolean isMyFile(PsiFile var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(6);
        }
        final DataContext context = e.getDataContext();
        DataContext patchedContext = new DataContext(){

            public Object getData(@NotNull @NonNls String dataId) {
                Object data;
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((data = context.getData(dataId)) != null) {
                    return data;
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    XmlTag[] tags2 = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                    return tags2.length == 1 ? tags2[0] : null;
                }
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "org/jetbrains/android/refactoring/AndroidBaseXmlRefactoringAction$1", "getData"));
            }
        };
        super.update(new AnActionEvent(e.getInputEvent(), patchedContext, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
    }

    protected abstract void doRefactorForTags(@NotNull Project var1, @NotNull XmlTag[] var2);

    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement from, @NotNull PsiElement to) {
        if (project == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(8);
        }
        if (from == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(9);
        }
        if (to == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(10);
        }
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(11);
        }
        XmlTag[] componentTags = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(dataContext);
        return new MyHandler(componentTags);
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    @NotNull
    protected static XmlTag[] getXmlTagsFromExternalContext(DataContext dataContext) {
        PsiElement[] data = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (data instanceof XmlTag[]) {
            XmlTag[] xmlTagArray = (XmlTag[])data;
            if (xmlTagArray == null) {
                AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(12);
            }
            return xmlTagArray;
        }
        if (XmlTag.EMPTY == null) {
            AndroidBaseXmlRefactoringAction.$$$reportNull$$$0(13);
        }
        return XmlTag.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidBaseXmlRefactoringAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidBaseXmlRefactoringAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlTagsFromExternalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForPsiRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRefactorForPsiRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyHandler
    implements RefactoringActionHandler {
        private final XmlTag[] myTagsFromExternalContext;

        private MyHandler(XmlTag[] tagsFromExternalContext) {
            if (tagsFromExternalContext == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            this.myTagsFromExternalContext = tagsFromExternalContext;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
            if (project == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor2);
            if (range != null) {
                Pair psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file, range.getStartOffset(), range.getEndOffset());
                if (psiRange != null) {
                    AndroidBaseXmlRefactoringAction.this.doRefactorForPsiRange(project, file, (PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
                }
                return;
            }
            PsiElement element = BaseRefactoringAction.getElementAtCaret((Editor)editor2, (PsiFile)file);
            if (element == null) {
                return;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{tag});
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
            if (project == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            if (elements == null) {
                MyHandler.$$$reportNull$$$0(3);
            }
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            if (elements.length != 1) {
                return;
            }
            PsiElement element = elements[0];
            if (!(element instanceof XmlTag)) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{(XmlTag)element});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagsFromExternalContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/AndroidBaseXmlRefactoringAction$MyHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

