/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAppPropertiesEditor {
    private JTextField myApplicationNameField;
    private JTextField myPackageNameField;
    private JCheckBox myHelloAndroidCheckBox;
    private JPanel myActivtiyPanel;
    private JTextField myActivityNameField;
    private JLabel myErrorLabel;
    private JPanel myContentPanel;
    private final ModulesProvider myModulesProvider;
    private boolean myApp;
    private boolean myPackageNameFieldChangedByUser;

    public AndroidAppPropertiesEditor(String moduleName, ModulesProvider modulesProvider) {
        this.myModulesProvider = modulesProvider;
        this.$$$setupUI$$$();
        String defaultAppName = moduleName != null ? moduleName : "myapp";
        this.myApplicationNameField.setText(defaultAppName);
        this.myApplicationNameField.selectAll();
        this.myPackageNameField.setText(AndroidAppPropertiesEditor.getDefaultPackageNameByModuleName(defaultAppName));
        this.myHelloAndroidCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidAppPropertiesEditor.this.updateActivityPanel();
            }
        });
        this.myPackageNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                AndroidAppPropertiesEditor.this.myPackageNameFieldChangedByUser = true;
                String message = AndroidAppPropertiesEditor.this.validatePackageName(!AndroidAppPropertiesEditor.this.myApp);
                AndroidAppPropertiesEditor.this.myErrorLabel.setText(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/newProject/AndroidAppPropertiesEditor$2", "textChanged"));
            }
        });
        this.myActivityNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                String message = AndroidAppPropertiesEditor.this.validateActivityName();
                AndroidAppPropertiesEditor.this.myErrorLabel.setText(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/newProject/AndroidAppPropertiesEditor$3", "textChanged"));
            }
        });
        this.myApplicationNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!AndroidAppPropertiesEditor.this.myPackageNameFieldChangedByUser) {
                    AndroidAppPropertiesEditor.this.updatePackageNameField();
                    AndroidAppPropertiesEditor.this.myPackageNameFieldChangedByUser = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/newProject/AndroidAppPropertiesEditor$4", "textChanged"));
            }
        });
    }

    private void updatePackageNameField() {
        String appName = this.myApplicationNameField.getText().trim();
        if (!appName.isEmpty()) {
            this.myPackageNameField.setText(AndroidAppPropertiesEditor.getDefaultPackageNameByModuleName(appName));
        }
    }

    public void update(boolean app) {
        this.myApplicationNameField.setEnabled(app);
        this.myHelloAndroidCheckBox.setEnabled(app);
        if (app) {
            this.updateActivityPanel();
        } else {
            UIUtil.setEnabled((Component)this.myActivtiyPanel, (boolean)app, (boolean)true);
        }
        this.myApp = app;
        String message = this.validatePackageName(!app);
        this.myErrorLabel.setText(message);
    }

    @NotNull
    public static String getDefaultPackageNameByModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(0);
        }
        String string = "com.example." + AndroidAppPropertiesEditor.toIdentifier(moduleName);
        if (string == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String toIdentifier(@NotNull String s) {
        if (s == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = s.charAt(i2);
            if (Character.isJavaIdentifierPart(c)) {
                if (i2 == 0 && !Character.isJavaIdentifierStart(c)) {
                    result2.append('_');
                }
                result2.append(c);
                continue;
            }
            result2.append('_');
        }
        String string = result2.toString();
        if (string == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void updateActivityPanel() {
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        UIUtil.setEnabled((Component)this.myActivtiyPanel, (boolean)this.myHelloAndroidCheckBox.isSelected(), (boolean)true);
    }

    private String validatePackageName(boolean library) {
        String candidate = this.myPackageNameField.getText().trim();
        return AndroidAppPropertiesEditor.doValidatePackageName(library, candidate, this.myModulesProvider);
    }

    @NotNull
    static String doValidatePackageName(boolean library, @NotNull String candidate, @Nullable ModulesProvider modulesProvider) {
        if (candidate == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(4);
        }
        if (candidate.isEmpty()) {
            String string = AndroidBundle.message("specify.package.name.error", new Object[0]);
            if (string == null) {
                AndroidAppPropertiesEditor.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (!AndroidUtils.isValidAndroidPackageName(candidate)) {
            String string = candidate;
            if (string == null) {
                AndroidAppPropertiesEditor.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (!AndroidCommonUtils.contains2Identifiers((String)candidate)) {
            String string = AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]);
            if (string == null) {
                AndroidAppPropertiesEditor.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!library) {
            for (Module module : modulesProvider.getModules()) {
                String packageName;
                Manifest manifest;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() || (manifest = facet.getManifest()) == null || !candidate.equals(packageName = (String)manifest.getPackage().getValue())) continue;
                String string = "Package name '" + packageName + "' is already used by module '" + module.getName() + "'";
                if (string == null) {
                    AndroidAppPropertiesEditor.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        if ("" == null) {
            AndroidAppPropertiesEditor.$$$reportNull$$$0(9);
        }
        return "";
    }

    private String validateActivityName() {
        String candidate = this.myActivityNameField.getText().trim();
        if (!AndroidUtils.isIdentifier(candidate)) {
            return AndroidBundle.message("not.valid.activity.name.error", candidate);
        }
        return "";
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public void validate(boolean library) throws ConfigurationException {
        String message = this.validatePackageName(library);
        if (!message.isEmpty()) {
            throw new ConfigurationException(message);
        }
        if (!library && !(message = this.validateActivityName()).isEmpty()) {
            throw new ConfigurationException(message);
        }
    }

    public String getActivityName() {
        return this.myHelloAndroidCheckBox.isSelected() ? this.myActivityNameField.getText().trim() : "";
    }

    public String getPackageName() {
        return this.myPackageNameField.getText().trim();
    }

    public String getApplicationName() {
        return this.myApplicationNameField.getText().trim();
    }

    public JTextField getApplicationNameField() {
        return this.myApplicationNameField;
    }

    public JTextField getPackageNameField() {
        return this.myPackageNameField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/newProject/AndroidAppPropertiesEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/newProject/AndroidAppPropertiesEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPackageNameByModuleName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toIdentifier";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidatePackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPackageNameByModuleName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doValidatePackageName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Application name:");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(4);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationNameField = jTextField3 = new JTextField();
        jTextField3.setText("");
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Package name:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHelloAndroidCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Create \"Hello, World!\" activity");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myActivtiyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        ((Component)jLabel4).setEnabled(true);
        jLabel4.setText("Activity name");
        jLabel4.setDisplayedMnemonic('Y');
        jLabel4.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myActivityNameField = jTextField = new JTextField();
        jTextField.setEditable(true);
        ((Component)jTextField).setEnabled(true);
        jTextField.setText("MyActivity");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

