/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class TypographyQuickFix
implements AndroidLintQuickFix {
    private final Issue myIssue;
    private final String myMessage;

    public TypographyQuickFix(@NotNull Issue issue2, @NotNull String message) {
        if (issue2 == null) {
            TypographyQuickFix.$$$reportNull$$$0(0);
        }
        if (message == null) {
            TypographyQuickFix.$$$reportNull$$$0(1);
        }
        this.myIssue = issue2;
        this.myMessage = message;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag;
        if (startElement == null) {
            TypographyQuickFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            TypographyQuickFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TypographyQuickFix.$$$reportNull$$$0(4);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class)) == null) {
            return;
        }
        for (PsiElement child : tag.getChildren()) {
            XmlText xmlText;
            String value2;
            if (!(child instanceof XmlText) || (value2 = (xmlText = (XmlText)child).getValue()) == null) continue;
            List edits = TypographyDetector.getEdits((String)this.myIssue.getId(), (String)this.myMessage, (String)value2);
            StringBuilder builder = new StringBuilder(value2);
            for (TypographyDetector.ReplaceEdit edit : edits) {
                String with2 = edit.replaceWith;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    with2 = with2.replace('\u2013', '~').replace('\u2018', '{').replace('\u2019', '}');
                }
                builder.replace(edit.offset, edit.offset + edit.length, with2);
            }
            String newValue = builder.toString();
            if (newValue.equals(value2)) continue;
            xmlText.setValue(newValue);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            TypographyQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            TypographyQuickFix.$$$reportNull$$$0(6);
        }
        if (contextType == null) {
            TypographyQuickFix.$$$reportNull$$$0(7);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.replace.with.suggested.characters", new Object[0]);
        if (string == null) {
            TypographyQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/TypographyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/TypographyQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

