/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class ResourceFolderManager
extends AndroidFacetScopedService
implements ModificationTracker {
    private static final Key<ResourceFolderManager> KEY = Key.create((String)ResourceFolderManager.class.getName());
    private List<VirtualFile> myResDirCache;
    private long myGeneration;
    private final List<ResourceFolderListener> myListeners = Lists.newArrayList();
    private boolean myVariantListenerAdded;

    ResourceFolderManager(AndroidFacet facet) {
        super(facet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ResourceFolderManager getInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(0);
        }
        Key<ResourceFolderManager> key = KEY;
        // MONITORENTER : key
        ResourceFolderManager resourceFolderManager2 = (ResourceFolderManager)facet.getUserData(KEY);
        if (resourceFolderManager2 == null) {
            resourceFolderManager2 = new ResourceFolderManager(facet);
            facet.putUserData(KEY, resourceFolderManager2);
        }
        ResourceFolderManager resourceFolderManager = resourceFolderManager2;
        // MONITOREXIT : key
        if (resourceFolderManager != null) return resourceFolderManager;
        ResourceFolderManager.$$$reportNull$$$0(1);
        return resourceFolderManager;
    }

    public void invalidate() {
        List<VirtualFile> old = this.myResDirCache;
        if (old == null || this.isDisposed()) {
            return;
        }
        this.myResDirCache = null;
        this.getFolders();
        if (!old.equals(this.myResDirCache)) {
            this.notifyChanged(old, this.myResDirCache);
        }
    }

    @NotNull
    public List<VirtualFile> getFolders() {
        if (this.myResDirCache == null) {
            this.myResDirCache = this.computeFolders();
        }
        List<VirtualFile> list = this.myResDirCache;
        if (list == null) {
            ResourceFolderManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public VirtualFile getPrimaryFolder() {
        List<VirtualFile> dirs = this.getFolders();
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    private List<VirtualFile> computeFolders() {
        AndroidFacet facet = this.getFacet();
        if (facet.requiresAndroidModel()) {
            JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
            AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
            ArrayList<VirtualFile> resDirectories = new ArrayList<VirtualFile>();
            if (androidModel == null) {
                if (state != null) {
                    String path = state.RES_FOLDERS_RELATIVE_PATH;
                    if (path != null) {
                        VirtualFileManager manager = VirtualFileManager.getInstance();
                        for (String url : Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path)) {
                            VirtualFile dir = manager.findFileByUrl(url);
                            if (dir == null) continue;
                            resDirectories.add(dir);
                        }
                    } else {
                        String mainRes = "/src/main/res";
                        VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), mainRes, true);
                        if (dir != null) {
                            resDirectories.add(dir);
                        } else {
                            String res = "/res";
                            dir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), res, true);
                            if (dir != null) {
                                resDirectories.add(dir);
                            }
                        }
                    }
                }
            } else {
                for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                    resDirectories.addAll(provider.getResDirectories());
                }
                if (state != null) {
                    StringBuilder path = new StringBuilder(400);
                    for (VirtualFile dir : resDirectories) {
                        if (path.length() != 0) {
                            path.append(';');
                        }
                        path.append(dir.getUrl());
                    }
                    state.RES_FOLDERS_RELATIVE_PATH = path.toString();
                }
                if (!this.myVariantListenerAdded) {
                    this.myVariantListenerAdded = true;
                    BuildVariantUpdater.getInstance(facet.getModule().getProject()).addSelectionChangeListener(this::invalidate);
                }
            }
            ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
            return resDirectories;
        }
        return new ArrayList<VirtualFile>(facet.getMainIdeaSourceProvider().getResDirectories());
    }

    private void notifyChanged(@NotNull List<VirtualFile> before, @NotNull List<VirtualFile> after) {
        if (before == null) {
            ResourceFolderManager.$$$reportNull$$$0(3);
        }
        if (after == null) {
            ResourceFolderManager.$$$reportNull$$$0(4);
        }
        AndroidFacet facet = this.getFacet();
        ++this.myGeneration;
        HashSet added = new HashSet(after.size());
        added.addAll(after);
        added.removeAll(before);
        HashSet removed = new HashSet(before.size());
        removed.addAll(before);
        removed.removeAll(after);
        for (ResourceFolderListener listener2 : new ArrayList<ResourceFolderListener>(this.myListeners)) {
            listener2.resourceFoldersChanged(facet, after, (Collection<VirtualFile>)added, (Collection<VirtualFile>)removed);
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(5);
        }
        facet.putUserData(KEY, null);
    }

    public synchronized void addListener(@NotNull ResourceFolderListener listener2) {
        if (listener2 == null) {
            ResourceFolderManager.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener2);
    }

    public synchronized void removeListener(@NotNull ResourceFolderListener listener2) {
        if (listener2 == null) {
            ResourceFolderManager.$$$reportNull$$$0(7);
        }
        this.myListeners.remove(listener2);
    }

    public static void addAarsFromModuleLibraries(@NotNull AndroidFacet facet, @NotNull Map<File, String> dirs) {
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(8);
        }
        if (dirs == null) {
            ResourceFolderManager.$$$reportNull$$$0(9);
        }
        Module module = facet.getModule();
        block0: for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid() || !ResourceFolderManager.isAarDependency(facet, orderEntry)) continue;
            LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
            VirtualFile[] roots = entry.getRootFiles(OrderRootType.CLASSES);
            String libraryName = entry.getPresentableName();
            if (libraryName.startsWith(LibraryDependency.NAME_PREFIX)) {
                libraryName = libraryName.substring(LibraryDependency.NAME_PREFIX.length());
            }
            File res = null;
            for (VirtualFile root : roots) {
                if (root.getName().equals("res")) {
                    res = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                    break;
                }
                if (!root.getName().equals("res.apk")) continue;
                dirs.put(VfsUtilCore.virtualToIoFile((VirtualFile)root).getParentFile(), libraryName);
                continue block0;
            }
            if (res == null) {
                for (VirtualFile root : roots) {
                    File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root).getParentFile(), "res");
                    if (!file.exists()) continue;
                    res = file;
                    break;
                }
            }
            if (res == null) continue;
            dirs.put(res, libraryName);
        }
    }

    private static boolean isAarDependency(@NotNull AndroidFacet facet, @NotNull OrderEntry orderEntry) {
        if (facet == null) {
            ResourceFolderManager.$$$reportNull$$$0(10);
        }
        if (orderEntry == null) {
            ResourceFolderManager.$$$reportNull$$$0(11);
        }
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return false;
        }
        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
        if (facet.requiresAndroidModel()) {
            return ResourceFolderManager.looksLikeAar(libraryOrderEntry);
        }
        if (AndroidMavenUtil.isMavenizedModule(facet.getModule())) {
            return AndroidMavenUtil.isMavenAarDependency(facet.getModule(), orderEntry);
        }
        if (StringUtil.notNullize((String)libraryOrderEntry.getLibraryName()).endsWith(".aar")) {
            return ResourceFolderManager.looksLikeAar(libraryOrderEntry);
        }
        return false;
    }

    private static boolean looksLikeAar(@NotNull LibraryOrderEntry orderEntry) {
        VirtualFile[] files2;
        if (orderEntry == null) {
            ResourceFolderManager.$$$reportNull$$$0(12);
        }
        if ((files2 = orderEntry.getFiles(OrderRootType.CLASSES)).length >= 2) {
            for (VirtualFile file : files2) {
                if ((!"res".equals(file.getName()) || !file.isDirectory()) && !"res.apk".equals(file.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLibraryResourceFile(@Nullable VirtualFile file) {
        if (file != null) {
            return ResourceFolderManager.isLibraryResourceFolder(file.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceFolder(@Nullable VirtualFile folder) {
        if (folder != null) {
            return ResourceFolderManager.isLibraryResourceRoot(folder.getParent());
        }
        return false;
    }

    public static boolean isLibraryResourceRoot(@Nullable VirtualFile res) {
        String name;
        VirtualFile exploded;
        VirtualFile aar;
        return res != null && (aar = res.getParent()) != null && (exploded = aar.getParent()) != null && (name = exploded.getName()).equals("exploded-aar");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/ResourceFolderManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/ResourceFolderManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAarsFromModuleLibraries";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAarDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeAar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourceFolderListener {
        public void resourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<VirtualFile> var2, @NotNull Collection<VirtualFile> var3, @NotNull Collection<VirtualFile> var4);
    }
}

