/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleItemNameConverter
extends ResolvingConverter<String> {
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        AttributeDefinitions attrDefs;
        FrameworkResourceManager manager;
        XmlTag styleTag;
        ArrayList result2 = Lists.newArrayList();
        if (context.getModule() != null && context.getTag() != null && (styleTag = context.getTag().getParentTag()) != null) {
            result2.addAll(StyleItemNameConverter.getAttributesUsedByParentStyle(styleTag));
        }
        if ((manager = FrameworkResourceManager.getInstance(context)) != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null) {
            for (ResourceReference attr : attrDefs.getAttrs()) {
                result2.add(attr.getQualifiedName());
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            StyleItemNameConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> getAttributesUsedByParentStyle(@NotNull XmlTag styleTag) {
        Module module;
        if (styleTag == null) {
            StyleItemNameConverter.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)styleTag)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StyleItemNameConverter.$$$reportNull$$$0(2);
            }
            return list;
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(module);
        if (appResources == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StyleItemNameConverter.$$$reportNull$$$0(3);
            }
            return list;
        }
        ResourceReference parentStyleReference = StyleItemNameConverter.getParentStyleFromTag(styleTag);
        if (parentStyleReference == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StyleItemNameConverter.$$$reportNull$$$0(4);
            }
            return list;
        }
        List parentStyles = appResources.getResources(parentStyleReference);
        ResourceNamespaceContext namespacesContext = ResourceHelper.getNamespacesContext((XmlElement)styleTag);
        if (namespacesContext == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StyleItemNameConverter.$$$reportNull$$$0(5);
            }
            return list;
        }
        ResourceNamespace namespace = namespacesContext.getCurrentNs();
        ResourceNamespace.Resolver resolver = namespacesContext.getResolver();
        HashSet<String> attributeNames = new HashSet<String>();
        ArrayDeque<Pair> toExplore = new ArrayDeque<Pair>();
        for (ResourceItem parentStyle : parentStyles) {
            toExplore.push(Pair.pair((Object)parentStyle, (Object)0));
        }
        while (!toExplore.isEmpty()) {
            ResourceItem parentItem;
            StyleResourceValue parentValue;
            Pair top = (Pair)toExplore.pop();
            int depth = (Integer)top.second;
            if (depth > 50 || (parentValue = (StyleResourceValue)(parentItem = (ResourceItem)top.first).getResourceValue()) == null || parentValue.isFramework()) continue;
            for (StyleItemResourceValue value2 : parentValue.getDefinedItems()) {
                ResourceReference attr;
                if (value2.isFramework() || (attr = value2.getAttr()) == null) continue;
                attributeNames.add(attr.getRelativeResourceUrl(namespace, resolver).getQualifiedName());
            }
            parentStyleReference = parentValue.getParentStyle();
            if (parentStyleReference == null) continue;
            for (ResourceItem parentStyle : appResources.getResources(parentStyleReference)) {
                toExplore.add(Pair.pair((Object)parentStyle, (Object)(depth + 1)));
            }
        }
        HashSet<String> hashSet = attributeNames;
        if (hashSet == null) {
            StyleItemNameConverter.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Nullable
    private static ResourceReference getParentStyleFromTag(@NotNull XmlTag styleTag) {
        ResourceUrl parentUrl;
        String parentName;
        if (styleTag == null) {
            StyleItemNameConverter.$$$reportNull$$$0(7);
        }
        if ((parentName = styleTag.getAttributeValue("parent")) == null) {
            String styleName = styleTag.getAttributeValue("name");
            if (styleName == null) {
                return null;
            }
            int lastDot = styleName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            parentName = styleName.substring(0, lastDot);
        }
        if ((parentUrl = ResourceUrl.parseStyleParentReference((String)parentName)) == null) {
            return null;
        }
        return ResourceHelper.resolve(parentUrl, (XmlElement)styleTag);
    }

    public LookupElement createLookupElement(String s) {
        if (s == null) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s), (double)(s.startsWith("android:") ? 0.0 : 1.0));
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        Object repository;
        if (s == null) {
            return null;
        }
        XmlElement xmlElement = context.getXmlElement();
        if (xmlElement == null) {
            return null;
        }
        ResourceUrl attrUrl = ResourceUrl.parseAttrReference((String)s);
        if (attrUrl == null) {
            return null;
        }
        ResourceReference attributeReference = ResourceHelper.resolve(attrUrl, xmlElement);
        if (attributeReference == null) {
            return null;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)xmlElement);
        if (repositoryManager == null) {
            return null;
        }
        Object object = repository = attributeReference.getNamespace() == ResourceNamespace.ANDROID ? repositoryManager.getFrameworkResources(false) : repositoryManager.getAppResources(true);
        if (repository == null) {
            return null;
        }
        return repository.getResources(attributeReference).isEmpty() ? null : s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/StyleItemNameConverter";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/StyleItemNameConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesUsedByParentStyle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesUsedByParentStyle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentStyleFromTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

