/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.utils.Pair;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.reference.SoftReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlDocumentationProvider
implements DocumentationProvider {
    private static final Key<SoftReference<Map<XmlName, CachedValue<String>>>> ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY = Key.create((String)"ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE");

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof LazyValueResourceElementWrapper) {
            ValueResourceInfo info = ((LazyValueResourceElementWrapper)element).getResourceInfo();
            return "value resource '" + info.getName() + "' [" + info.getContainingFile().getName() + "]";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        PomTarget target;
        if (element instanceof ProvidedDocumentationPsiElement) {
            return ((ProvidedDocumentationPsiElement)element).getDocumentation();
        }
        if (element instanceof LazyValueResourceElementWrapper) {
            ResourceUrl url;
            ResourceUrl originalUrl;
            LazyValueResourceElementWrapper wrapper = (LazyValueResourceElementWrapper)element;
            ValueResourceInfo resourceInfo = wrapper.getResourceInfo();
            ResourceType type = resourceInfo.getType();
            String name = resourceInfo.getName();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(element);
            if (facet == null) {
                return null;
            }
            ResourceUrl resourceUrl = originalUrl = originalElement != null ? ResourceUrl.parse((String)originalElement.getText()) : null;
            if (originalUrl != null && name.equals(originalUrl.name)) {
                url = originalUrl;
            } else {
                boolean isFramework = false;
                if (originalUrl != null) {
                    isFramework = originalUrl.isFramework();
                } else {
                    VirtualFile resDir;
                    VirtualFile parent;
                    FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
                    VirtualFile containingFile = resourceInfo.getContainingFile();
                    if (frameworkResourceManager != null && (parent = containingFile.getParent()) != null && (resDir = parent.getParent()) != null) {
                        isFramework = frameworkResourceManager.isResourceDir(resDir);
                    }
                }
                url = ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
            }
            return AndroidXmlDocumentationProvider.generateDoc(element, url);
        }
        if (element instanceof MyResourceElement) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element, ((MyResourceElement)element).myResource);
        }
        if (element instanceof XmlAttributeValue) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element, ((XmlAttributeValue)element).getValue());
        }
        if (originalElement instanceof XmlToken) {
            String text;
            String documentation;
            PsiElement prev;
            XmlToken token = (XmlToken)originalElement;
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                PsiElement next = token.getNextSibling();
                if (next instanceof XmlToken) {
                    token = (XmlToken)next;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (prev = token.getPrevSibling()) instanceof XmlToken) {
                token = (XmlToken)prev;
            }
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                String documentation2 = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, token.getText());
                if (documentation2 != null) {
                    return documentation2;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (documentation = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, text = token.getText().trim())) != null) {
                return documentation;
            }
        }
        if (element instanceof PomTargetPsiElement && originalElement != null && (target = ((PomTargetPsiElement)element).getTarget()) instanceof DomAttributeChildDescription) {
            Key<SoftReference<Map<XmlName, CachedValue<String>>>> key = ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY;
            synchronized (key) {
                return AndroidXmlDocumentationProvider.generateDocForXmlAttribute((DomAttributeChildDescription)target, originalElement);
            }
        }
        if (element instanceof MyDocElement) {
            return ((MyDocElement)element).myDocumentation;
        }
        return null;
    }

    @Nullable
    private static String getResourceDocumentation(PsiElement element, String value2) {
        ResourceUrl url = ResourceUrl.parse((String)value2);
        if (url != null) {
            return AndroidXmlDocumentationProvider.generateDoc(element, url);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        XmlTag tag = null;
        boolean isXmlValue = false;
        if (element instanceof XmlToken && XmlTokenType.XML_DATA_CHARACTERS.equals(((XmlToken)element).getTokenType())) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            attribute = tag == null ? null : tag.getAttribute("name");
            isXmlValue = true;
        }
        if (attribute == null) {
            return null;
        }
        if ("name".equals(attribute.getName())) {
            XmlTag parentTag = (tag = tag != null ? tag : attribute.getParent()).getParentTag();
            if (parentTag == null) {
                return null;
            }
            if ("resources".equals(parentTag.getName())) {
                ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                if (type != null) {
                    return AndroidXmlDocumentationProvider.generateDoc(element, type, value2, false);
                }
            } else if ("style".equals(parentTag.getName())) {
                AttributeDefinition attributeDefinition;
                String targetValue = value2;
                if (isXmlValue && attribute.getValue() != null) {
                    targetValue = attribute.getValue();
                }
                if ((attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element, targetValue = StringUtil.trimStart((String)targetValue, (String)"android:"))) == null) {
                    return null;
                }
                return StringUtil.trim((String)(isXmlValue ? attributeDefinition.getValueDescription(value2) : attributeDefinition.getDescription(null)));
            }
        }
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
            AttributeDefinition attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element, attribute.getLocalName());
            if (attributeDefinition == null) {
                return null;
            }
            return StringUtil.trim((String)attributeDefinition.getValueDescription(value2));
        }
        return null;
    }

    @Nullable
    private static AttributeDefinition getAttributeDefinitionForElement(@NotNull PsiElement element, @NotNull String name) {
        AndroidFacet facet;
        if (element == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((facet = AndroidFacet.getInstance(element)) == null) {
            return null;
        }
        AttributeDefinitions definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager());
        if (definitions == null) {
            return null;
        }
        AttributeDefinition attributeDefinition = definitions.getAttrDefByName(name);
        if (attributeDefinition == null) {
            definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet).getLocalResourceManager());
            if (definitions == null) {
                return null;
            }
            attributeDefinition = definitions.getAttrDefByName(name);
        }
        return attributeDefinition;
    }

    @Nullable
    private static AttributeDefinitions getAttributeDefinitions(@Nullable ResourceManager manager) {
        return manager == null ? null : manager.getAttributeDefinitions();
    }

    @Nullable
    private static String generateDocForXmlAttribute(@NotNull DomAttributeChildDescription description, @NotNull PsiElement originalElement) {
        CachedValue cachedDoc;
        if (description == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(3);
        }
        XmlName xmlName = description.getXmlName();
        HashMap<XmlName, CachedValue> cachedDocsMap = (HashMap<XmlName, CachedValue>)SoftReference.dereference((Reference)((Reference)originalElement.getUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY)));
        if (cachedDocsMap != null && (cachedDoc = (CachedValue)cachedDocsMap.get(xmlName)) != null) {
            return (String)cachedDoc.getValue();
        }
        AndroidFacet facet = AndroidFacet.getInstance(originalElement);
        if (facet == null) {
            return null;
        }
        String localName = xmlName.getLocalName();
        String namespace = xmlName.getNamespaceKey();
        if (namespace == null) {
            return null;
        }
        if ("android".equals(namespace)) {
            namespace = "http://schemas.android.com/apk/res/android";
        }
        if (namespace.startsWith("http://schemas.android.com/apk/res/") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
            String finalNamespace = namespace;
            CachedValue cachedValue = CachedValuesManager.getManager((Project)originalElement.getProject()).createCachedValue(() -> {
                Pair<AttributeDefinition, String> pair = AndroidXmlDocumentationProvider.findAttributeDefinition(originalElement, facet, finalNamespace, localName);
                String doc = pair != null ? AndroidXmlDocumentationProvider.generateDocForXmlAttribute((AttributeDefinition)pair.getFirst(), (String)pair.getSecond()) : null;
                return CachedValueProvider.Result.create((Object)doc, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            if (cachedDocsMap == null) {
                cachedDocsMap = new HashMap<XmlName, CachedValue>();
                originalElement.putUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY, (Object)new SoftReference(cachedDocsMap));
            }
            cachedDocsMap.put(xmlName, cachedValue);
            return (String)cachedValue.getValue();
        }
        return null;
    }

    @Nullable
    private static Pair<AttributeDefinition, String> findAttributeDefinition(@NotNull PsiElement originalElement, @NotNull AndroidFacet facet, @NotNull String namespace, @NotNull String localName) {
        if (originalElement == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (namespace == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (localName == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (!originalElement.isValid()) {
            return null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (parentTag == null) {
            return null;
        }
        DomElement parentDomElement = DomManager.getDomManager((Project)parentTag.getProject()).getDomElement(parentTag);
        if (!(parentDomElement instanceof AndroidDomElement)) {
            return null;
        }
        Ref result2 = Ref.create();
        try {
            AttributeProcessingUtil.processAttributes((AndroidDomElement)parentDomElement, facet, false, (xn, attrDef, parentStyleableName) -> {
                if (xn.getLocalName().equals(localName) && namespace.equals(xn.getNamespaceKey())) {
                    result2.set((Object)Pair.of((Object)attrDef, (Object)parentStyleableName));
                    throw new MyStopException();
                }
                return null;
            });
        }
        catch (MyStopException myStopException) {
            // empty catch block
        }
        Pair pair = (Pair)result2.get();
        if (pair != null) {
            return pair;
        }
        AttributeDefinition attrDef2 = AndroidXmlDocumentationProvider.findAttributeDefinitionGlobally(facet, namespace, localName);
        return attrDef2 != null ? Pair.of((Object)attrDef2, (Object)null) : null;
    }

    @Nullable
    private static AttributeDefinition findAttributeDefinitionGlobally(@NotNull AndroidFacet facet, @NotNull String namespace, @NotNull String localName) {
        AttributeDefinitions attributes;
        ResourceManager resourceManager;
        if (facet == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (namespace == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (localName == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(10);
        }
        if ((resourceManager = "http://schemas.android.com/apk/res/android".equals(namespace) || "http://schemas.android.com/tools".equals(namespace) ? ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager() : (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/") ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager())) != null && (attributes = ((ResourceManager)resourceManager).getAttributeDefinitions()) != null) {
            return attributes.getAttrDefByName(localName);
        }
        return null;
    }

    private static String generateDocForXmlAttribute(@NotNull AttributeDefinition definition, @Nullable String parentStyleable) {
        String docValue;
        String[] values2;
        if (definition == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(11);
        }
        StringBuilder builder = new StringBuilder("<html><body>");
        Set<AttributeFormat> formats = definition.getFormats();
        if (!formats.isEmpty()) {
            builder.append("Formats: ");
            ArrayList<String> formatLabels = new ArrayList<String>(formats.size());
            for (AttributeFormat format : formats) {
                formatLabels.add(StringUtil.toLowerCase((String)format.name()));
            }
            Collections.sort(formatLabels);
            int n = formatLabels.size();
            for (int i2 = 0; i2 < n; ++i2) {
                builder.append((String)formatLabels.get(i2));
                if (i2 >= n - 1) continue;
                builder.append(", ");
            }
        }
        if ((values2 = definition.getValues()).length > 0) {
            if (builder.length() > 0) {
                builder.append("<br>");
            }
            builder.append("Values: ");
            Object[] sortedValues = new String[values2.length];
            System.arraycopy(values2, 0, sortedValues, 0, values2.length);
            Arrays.sort(sortedValues);
            for (int i3 = 0; i3 < sortedValues.length; ++i3) {
                builder.append((String)sortedValues[i3]);
                if (i3 >= sortedValues.length - 1) continue;
                builder.append(", ");
            }
        }
        if ((docValue = definition.getDescriptionByParentStyleableName(parentStyleable)) != null && !docValue.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("<br><br>");
            }
            builder.append(docValue);
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceType type, String name, boolean framework) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, type, name, framework);
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceUrl url) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, url);
    }

    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @NotNull Object object, @NotNull PsiElement element) {
        String doc;
        if (psiManager == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (object == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (element == null) {
            AndroidXmlDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (object instanceof ResourceReferenceConverter.DocumentationHolder) {
            ResourceReferenceConverter.DocumentationHolder holder = (ResourceReferenceConverter.DocumentationHolder)object;
            return new ProvidedDocumentationPsiElement(psiManager, Language.ANY, holder.getValue(), holder.getDocumentation());
        }
        if (!(element instanceof XmlAttributeValue) || !(object instanceof String)) {
            return null;
        }
        String value2 = (String)object;
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return null;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent);
        if (domValue == null) {
            return null;
        }
        Converter converter = domValue.getConverter();
        if (converter instanceof AttributeValueDocumentationProvider && (doc = ((AttributeValueDocumentationProvider)converter).getDocumentation(value2)) != null) {
            return new MyDocElement(element, doc);
        }
        if ((value2.startsWith("@") || value2.startsWith("?")) && !DataBindingUtil.isBindingExpression(value2)) {
            return new MyResourceElement(element, value2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributeDefinitionForElement";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDocForXmlAttribute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAttributeDefinition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findAttributeDefinitionGlobally";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentationElementForLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyStopException
    extends RuntimeException {
        private MyStopException() {
        }
    }

    private static class MyResourceElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myResource;

        private MyResourceElement(@NotNull PsiElement parent, @NotNull String resource) {
            if (parent == null) {
                MyResourceElement.$$$reportNull$$$0(0);
            }
            if (resource == null) {
                MyResourceElement.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myResource = resource;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resource";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider$MyResourceElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDocElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myDocumentation;

        private MyDocElement(@NotNull PsiElement parent, @NotNull String documentation) {
            if (parent == null) {
                MyDocElement.$$$reportNull$$$0(0);
            }
            if (documentation == null) {
                MyDocElement.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myDocumentation = documentation;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "documentation";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/AndroidXmlDocumentationProvider$MyDocElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

