/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import icons.StudioIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomElementDescriptorProvider
implements XmlElementDescriptorProvider {
    private static final Map<String, Ref<Icon>> ourViewTagName2Icon = ContainerUtil.createSoftMap();

    @Nullable
    private static XmlElementDescriptor getDescriptor(DomElement domElement, XmlTag tag, @Nullable String baseClassName) {
        XmlElementDescriptor domDescriptor;
        XmlElementDescriptor parentDescriptor;
        AndroidFacet facet = AndroidFacet.getInstance(domElement);
        if (facet == null) {
            return null;
        }
        String name = domElement.getXmlTag().getName();
        PsiClass aClass = baseClassName != null ? LayoutViewClassUtils.findClassByTagName(facet, name, baseClassName) : null;
        Icon icon = AndroidDomElementDescriptorProvider.getIconForTag(name, domElement);
        DefinesXml definesXml = (DefinesXml)domElement.getAnnotation(DefinesXml.class);
        if (definesXml != null) {
            return new AndroidXmlTagDescriptor(aClass, (XmlElementDescriptor)new DomElementXmlDescriptor(domElement), baseClassName, icon);
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (parentDescriptor = ((XmlTag)parent).getDescriptor()) != null && parentDescriptor instanceof AndroidXmlTagDescriptor && (domDescriptor = parentDescriptor.getElementDescriptor(tag, (XmlTag)parent)) != null) {
            return new AndroidXmlTagDescriptor(aClass, domDescriptor, baseClassName, icon);
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        Pair<AndroidDomElement, String> pair = AndroidDomElementDescriptorProvider.getDomElementAndBaseClassQName(tag);
        if (pair == null) {
            return null;
        }
        return AndroidDomElementDescriptorProvider.getDescriptor((DomElement)pair.getFirst(), tag, (String)pair.getSecond());
    }

    @Nullable
    public static Pair<AndroidDomElement, String> getDomElementAndBaseClassQName(@NotNull XmlTag tag) {
        PsiFile file;
        if (tag == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (!((file = tag.getContainingFile()) instanceof XmlFile)) {
            return null;
        }
        Project project = file.getProject();
        if (project.isDefault()) {
            return null;
        }
        DomManager domManager = DomManager.getDomManager((Project)project);
        if (domManager.getFileElement((XmlFile)file, AndroidDomElement.class) == null) {
            return null;
        }
        DomElement domElement = domManager.getDomElement(tag);
        if (!(domElement instanceof AndroidDomElement)) {
            return null;
        }
        String className = null;
        if (domElement instanceof LayoutViewElement) {
            className = "android.view.View";
        } else if (domElement instanceof XmlResourceElement) {
            className = "android.preference.Preference";
        }
        return Pair.create((Object)((AndroidDomElement)domElement), (Object)className);
    }

    @Nullable
    public static Icon getIconForTag(@Nullable String tagName, @Nullable DomElement context) {
        if (tagName == null || !(context instanceof LayoutViewElement)) {
            return null;
        }
        return AndroidDomElementDescriptorProvider.getIconForViewTag(tagName);
    }

    @Nullable
    public static Icon getIconForViewTag(@NotNull String tagName) {
        if (tagName == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(1);
        }
        return AndroidDomElementDescriptorProvider.getIconForView(tagName);
    }

    @Nullable
    public static Icon getLargeIconForViewTag(@NotNull String tagName) {
        if (tagName == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(2);
        }
        return AndroidDomElementDescriptorProvider.getIconForView(tagName + "Large");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Icon getIconForView(@NotNull String keyName) {
        if (keyName == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(3);
        }
        Map<String, Ref<Icon>> map2 = ourViewTagName2Icon;
        synchronized (map2) {
            Ref iconRef;
            if (ourViewTagName2Icon.isEmpty()) {
                Map<String, Icon> map3 = AndroidDomElementDescriptorProvider.getInitialViewTagName2IconMap();
                for (Map.Entry<String, Icon> entry : map3.entrySet()) {
                    ourViewTagName2Icon.put(entry.getKey(), (Ref<Icon>)Ref.create((Object)entry.getValue()));
                }
            }
            if ((iconRef = ourViewTagName2Icon.get(keyName)) == null) {
                Icon icon = IconLoader.findIcon((String)("StudioIcons.LayoutEditor.Palette." + AndroidDomElementDescriptorProvider.convertToPaletteIconName(keyName)));
                if (icon == null) {
                    icon = IconLoader.findIcon((String)("AndroidIcons.Views." + keyName));
                }
                iconRef = Ref.create((Object)icon);
                ourViewTagName2Icon.put(keyName, (Ref<Icon>)iconRef);
            }
            return (Icon)iconRef.get();
        }
    }

    @NotNull
    private static String convertToPaletteIconName(@NotNull String tagName) {
        if (tagName == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(4);
        }
        String string = StringUtil.toUpperCase((String)SdkVersionInfo.camelCaseToUnderlines((String)tagName));
        if (string == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static Map<String, Icon> getInitialViewTagName2IconMap() {
        HashMap map2 = new HashMap();
        map2.put((Object)"LinearLayout", (Object)StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ);
        HashMap hashMap = map2;
        if (hashMap == null) {
            AndroidDomElementDescriptorProvider.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidDomElementDescriptorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidDomElementDescriptorProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPaletteIconName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialViewTagName2IconMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDomElementAndBaseClassQName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIconForViewTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLargeIconForViewTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIconForView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToPaletteIconName";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

