/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.facet.FacetModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationArtifactType
extends ArtifactType {
    public AndroidApplicationArtifactType() {
        super("apk", "Android Application");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Artifact;
        if (icon == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(1);
        }
        return "/";
    }

    public boolean isSuitableItem(@NotNull PackagingSourceItem item) {
        if (item == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(2);
        }
        return !(item instanceof ModuleOutputSourceItem) && !(item instanceof LibrarySourceItem);
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(3);
        }
        CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().createArchive(ArtifactUtil.suggestArtifactFileName((String)artifactName) + ".apk");
        if (compositePackagingElement == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(4);
        }
        return compositePackagingElement;
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(5);
        }
        ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module : context.getModulesProvider().getModules()) {
            FacetModel facetModel = context.getModulesProvider().getFacetModel(module);
            AndroidFacet facet = (AndroidFacet)facetModel.getFacetByType(AndroidFacet.ID);
            if (facet == null || !((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            facets.add(facet);
        }
        if (facets.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidApplicationArtifactType.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<MyTemplate> list = Collections.singletonList(new MyTemplate(context.getProject(), facets));
        if (list == null) {
            AndroidApplicationArtifactType.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static ArtifactType getInstance() {
        return (ArtifactType)ContainerUtil.findInstance((Object[])AndroidApplicationArtifactType.getAllTypes(), AndroidApplicationArtifactType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewArtifactTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableItem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRootElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewArtifactTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTemplate
    extends ArtifactTemplate {
        private final Project myProject;
        private final List<AndroidFacet> myFacets;

        private MyTemplate(@NotNull Project project, List<AndroidFacet> facets) {
            if (project == null) {
                MyTemplate.$$$reportNull$$$0(0);
            }
            if (facets == null) {
                MyTemplate.$$$reportNull$$$0(1);
            }
            assert (!facets.isEmpty());
            this.myProject = project;
            this.myFacets = facets;
        }

        public String getPresentableName() {
            return this.myFacets.size() == 1 ? "From module '" + this.myFacets.get(0).getModule().getName() + "'" : "From module...";
        }

        public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
            AndroidFacet facet;
            AndroidFacet androidFacet = facet = this.myFacets.size() == 1 ? this.myFacets.get(0) : AndroidArtifactUtil.chooseAndroidApplicationModule(this.myProject, this.myFacets);
            if (facet == null) {
                return null;
            }
            CompositePackagingElement<?> rootElement = AndroidApplicationArtifactType.this.createRootElement(facet.getModule().getName());
            rootElement.addFirstChild((PackagingElement)new AndroidFinalPackageElement(this.myProject, facet));
            return new ArtifactTemplate.NewArtifactConfiguration(rootElement, facet.getModule().getName(), (ArtifactType)AndroidApplicationArtifactType.this);
        }

        public void setUpArtifact(@NotNull Artifact artifact, @NotNull ArtifactTemplate.NewArtifactConfiguration configuration) {
            ArtifactProperties properties;
            AndroidFacet facet;
            if (artifact == null) {
                MyTemplate.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                MyTemplate.$$$reportNull$$$0(3);
            }
            if ((facet = AndroidArtifactUtil.getPackagedFacet(this.myProject, artifact)) != null && (properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) {
                AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties;
                p.setProGuardCfgFiles(facet.getProperties().myProGuardCfgFiles);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType$MyTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpArtifact";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

