/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompilerConfiguration;
import org.jetbrains.android.compiler.ClassesAndJarsValidityState;
import org.jetbrains.android.compiler.tools.AndroidDxWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDexCompiler
implements ClassPostProcessingCompiler {
    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
        if (processingItemArray == null) {
            AndroidDexCompiler.$$$reportNull$$$0(0);
        }
        return processingItemArray;
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items2) {
        if (!AndroidCompileUtil.isFullBuild(context)) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        if (items2 != null && items2.length > 0) {
            context.getProgressIndicator().setText("Generating classes.dex...");
            return new ProcessAction(context, items2).compute();
        }
        return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
    }

    @NotNull
    public String getDescription() {
        String string = FileUtilRt.getNameWithoutExtension((String)SdkConstants.FN_DX);
        if (string == null) {
            AndroidDexCompiler.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    public static VirtualFile getOutputDirectoryForDex(@NotNull Module module) {
        VirtualFile buildDir;
        String buildDirPath;
        AndroidMavenProvider mavenProvider;
        if (module == null) {
            AndroidDexCompiler.$$$reportNull$$$0(2);
        }
        if (AndroidMavenUtil.isMavenizedModule(module) && (mavenProvider = AndroidMavenUtil.getMavenProvider()) != null && (buildDirPath = mavenProvider.getBuildDirectory(module)) != null && (buildDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)buildDirPath))) != null) {
            return buildDir;
        }
        return CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
    }

    static void addModuleOutputDir(Collection<VirtualFile> files2, VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isDirectory()) continue;
            files2.add(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidDexCompiler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingItems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidDexCompiler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDirectoryForDex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyValidityState
    extends ClassesAndJarsValidityState {
        private final String myAdditionalVmParams;
        private final int myMaxHeapSize;
        private final boolean myOptimize;

        MyValidityState(@NotNull Collection<VirtualFile> files2, @NotNull String additionalVmParams, int maxHeapSize, boolean optimize) {
            if (files2 == null) {
                MyValidityState.$$$reportNull$$$0(0);
            }
            if (additionalVmParams == null) {
                MyValidityState.$$$reportNull$$$0(1);
            }
            super(files2);
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        MyValidityState(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyValidityState.$$$reportNull$$$0(2);
            }
            super(in);
            this.myAdditionalVmParams = in.readUTF();
            this.myMaxHeapSize = in.readInt();
            this.myOptimize = in.readBoolean();
        }

        @Override
        public void save(DataOutput out) throws IOException {
            super.save(out);
            out.writeUTF(this.myAdditionalVmParams);
            out.writeInt(this.myMaxHeapSize);
            out.writeBoolean(this.myOptimize);
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!super.equalsTo(otherState)) {
                return false;
            }
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState state = (MyValidityState)otherState;
            return state.myAdditionalVmParams.equals(this.myAdditionalVmParams) && state.myMaxHeapSize == this.myMaxHeapSize && state.myOptimize == this.myOptimize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "additionalVmParams";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "in";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/compiler/AndroidDexCompiler$MyValidityState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DexItem
    implements FileProcessingCompiler.ProcessingItem {
        final Module myModule;
        final VirtualFile myClassDir;
        final IAndroidTarget myAndroidTarget;
        final Collection<VirtualFile> myFiles;
        final String myAdditionalVmParams;
        final int myMaxHeapSize;
        final boolean myOptimize;

        DexItem(@NotNull Module module, @NotNull VirtualFile classDir, @NotNull IAndroidTarget target, Collection<VirtualFile> files2, @NotNull String additionalVmParams, int maxHeapSize, boolean optimize) {
            if (module == null) {
                DexItem.$$$reportNull$$$0(0);
            }
            if (classDir == null) {
                DexItem.$$$reportNull$$$0(1);
            }
            if (target == null) {
                DexItem.$$$reportNull$$$0(2);
            }
            if (additionalVmParams == null) {
                DexItem.$$$reportNull$$$0(3);
            }
            this.myModule = module;
            this.myClassDir = classDir;
            this.myAndroidTarget = target;
            this.myFiles = files2;
            this.myAdditionalVmParams = additionalVmParams;
            this.myMaxHeapSize = maxHeapSize;
            this.myOptimize = optimize;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myClassDir;
            if (virtualFile == null) {
                DexItem.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            return new MyValidityState(this.myFiles, this.myAdditionalVmParams, this.myMaxHeapSize, this.myOptimize);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalVmParams";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/compiler/AndroidDexCompiler$DexItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/compiler/AndroidDexCompiler$DexItem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ProcessAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;
        private final FileProcessingCompiler.ProcessingItem[] myItems;

        ProcessAction(CompileContext context, FileProcessingCompiler.ProcessingItem[] items2) {
            this.myContext = context;
            this.myItems = items2;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            ArrayList<DexItem> results = new ArrayList<DexItem>(this.myItems.length);
            for (FileProcessingCompiler.ProcessingItem item : this.myItems) {
                if (!(item instanceof DexItem)) continue;
                DexItem dexItem = (DexItem)item;
                if (!AndroidCompileUtil.isModuleAffected(this.myContext, dexItem.myModule)) continue;
                String outputDirPath = FileUtil.toSystemDependentName((String)dexItem.myClassDir.getPath());
                String[] files2 = new String[dexItem.myFiles.size()];
                int i2 = 0;
                for (VirtualFile file : dexItem.myFiles) {
                    files2[i2++] = FileUtil.toSystemDependentName((String)file.getPath());
                }
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidDxWrapper.execute(dexItem.myModule, dexItem.myAndroidTarget, outputDirPath, files2, dexItem.myAdditionalVmParams, dexItem.myMaxHeapSize, dexItem.myOptimize));
                this.addMessages(messages, dexItem.myModule);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                results.add(dexItem);
            }
            return results.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        }

        private void addMessages(Map<CompilerMessageCategory, List<String>> messages, Module module) {
            for (CompilerMessageCategory category : messages.keySet()) {
                List<String> messageList = messages.get(category);
                for (String message : messageList) {
                    this.myContext.addMessage(category, '[' + module.getName() + "] " + message, null, -1, -1);
                }
            }
        }
    }

    private static final class PrepareAction
    implements Computable<FileProcessingCompiler.ProcessingItem[]> {
        private final CompileContext myContext;

        PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public FileProcessingCompiler.ProcessingItem[] compute() {
            AndroidDexCompilerConfiguration dexConfig = AndroidDexCompilerConfiguration.getInstance(this.myContext.getProject());
            Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
            ArrayList<DexItem> items2 = new ArrayList<DexItem>();
            for (Module module : modules) {
                HashSet files2;
                boolean shouldRunProguard;
                AndroidFacet facet = (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(AndroidFacet.ID);
                if (facet == null || !((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
                VirtualFile dexOutputDir = AndroidDexCompiler.getOutputDirectoryForDex(module);
                boolean bl = shouldRunProguard = AndroidCompileUtil.getProguardConfigFilePathIfShouldRun(facet, this.myContext) != null;
                if (shouldRunProguard) {
                    VirtualFile obfuscatedSourcesJar = dexOutputDir.findChild("obfuscated_sources.jar");
                    if (obfuscatedSourcesJar == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module.getName() + " because file " + "obfuscated_sources.jar" + " doesn't exist", null, -1, -1);
                        continue;
                    }
                    files2 = Collections.singleton(obfuscatedSourcesJar);
                } else {
                    VirtualFile outputDirForTests;
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                    VirtualFile outputDir = extension.getCompilerOutputPath();
                    if (outputDir == null) {
                        this.myContext.addMessage(CompilerMessageCategory.INFORMATION, "Dex won't be launched for module " + module.getName() + " because it doesn't contain compiled files", null, -1, -1);
                        continue;
                    }
                    files2 = new HashSet();
                    AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files2, outputDir);
                    files2.addAll(AndroidRootUtil.getExternalLibraries(module));
                    for (VirtualFile file : AndroidRootUtil.getDependentModules(module, outputDir)) {
                        if (file.isDirectory()) {
                            AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files2, file);
                            continue;
                        }
                        files2.add(file);
                    }
                    if (facet.getProperties().PACK_TEST_CODE && (outputDirForTests = extension.getCompilerOutputPathForTests()) != null) {
                        AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)files2, outputDirForTests);
                    }
                }
                AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
                AndroidPlatform platform = configuration.getAndroidPlatform();
                if (platform == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                    continue;
                }
                StringBuilder options = new StringBuilder(dexConfig.VM_OPTIONS);
                items2.add(new DexItem(module, dexOutputDir, platform.getTarget(), (Collection<VirtualFile>)files2, options.toString(), dexConfig.MAX_HEAP_SIZE, dexConfig.OPTIMIZE));
            }
            return items2.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        }
    }
}

