/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnerRClassBase
extends AndroidLightInnerClassBase {
    private static final Logger LOG = Logger.getInstance(InnerRClassBase.class);
    @NotNull
    protected final ResourceType myResourceType;
    @Nullable
    private CachedValue<PsiField[]> myFieldsCache;
    protected static PsiType INT_ARRAY = PsiType.INT.createArrayType();

    public InnerRClassBase(@NotNull PsiClass context, @NotNull ResourceType resourceType) {
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(1);
        }
        super(context, resourceType.getName());
        this.myResourceType = resourceType;
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull ResourceRepository repository, @NotNull ResourceNamespace namespace, @NotNull AndroidLightField.FieldModifier fieldModifier, @NotNull BiPredicate<ResourceType, String> isPublic, @NotNull ResourceType resourceType, @NotNull PsiClass context) {
        if (repository == null) {
            InnerRClassBase.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            InnerRClassBase.$$$reportNull$$$0(3);
        }
        if (fieldModifier == null) {
            InnerRClassBase.$$$reportNull$$$0(4);
        }
        if (isPublic == null) {
            InnerRClassBase.$$$reportNull$$$0(5);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(7);
        }
        HashMap<String, PsiType> fieldNames = new HashMap<String, PsiType>();
        PsiType basicType = ResourceType.STYLEABLE == resourceType ? INT_ARRAY : PsiType.INT;
        for (String resName : repository.getResources(namespace, resourceType).keySet()) {
            fieldNames.put(resName, basicType);
        }
        if (ResourceType.STYLEABLE == resourceType) {
            Collection items2 = repository.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item : items2) {
                StyleableResourceValue value2 = (StyleableResourceValue)item.getResourceValue();
                if (value2 == null) continue;
                List attributes = value2.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    if (!isPublic.test(attr.getResourceType(), attr.getName())) continue;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    String packageName = attrNamespace.getPackageName();
                    if (attrNamespace.equals((Object)namespace) || StringUtil.isEmpty((String)packageName)) {
                        fieldNames.put(item.getName() + '_' + attr.getName(), (PsiType)PsiType.INT);
                        continue;
                    }
                    fieldNames.put(item.getName() + '_' + packageName.replace('.', '_') + '_' + attr.getName(), (PsiType)PsiType.INT);
                }
            }
        }
        PsiField[] psiFieldArray = InnerRClassBase.buildResourceFields(fieldNames, resourceType, context, fieldModifier);
        if (psiFieldArray == null) {
            InnerRClassBase.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull Map<String, PsiType> fieldNames, @NotNull ResourceType resourceType, @NotNull PsiClass context, @NotNull AndroidLightField.FieldModifier fieldModifier) {
        if (fieldNames == null) {
            InnerRClassBase.$$$reportNull$$$0(9);
        }
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            InnerRClassBase.$$$reportNull$$$0(11);
        }
        if (fieldModifier == null) {
            InnerRClassBase.$$$reportNull$$$0(12);
        }
        PsiField[] result2 = new PsiField[fieldNames.size()];
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int idIterator = resourceType.ordinal() * 100000;
        int i2 = 0;
        for (Map.Entry<String, PsiType> entry : fieldNames.entrySet()) {
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(entry.getKey());
            PsiType type = entry.getValue();
            int id = -idIterator++;
            AndroidLightField field2 = new AndroidLightField(fieldName, context, type, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(id) : null);
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(id), (PsiElement)field2));
            result2[i2++] = field2;
        }
        if (result2 == null) {
            InnerRClassBase.$$$reportNull$$$0(13);
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recomputing fields for " + (Object)((Object)this));
                }
                Object[] fields = this.doGetFields();
                return CachedValueProvider.Result.create((Object)fields, (Object[])ArrayUtil.mergeArrays((Object[])this.getFieldsDependencies(), (Object[])fields));
            });
        }
        PsiField[] psiFieldArray = (PsiField[])this.myFieldsCache.getValue();
        if (psiFieldArray == null) {
            InnerRClassBase.$$$reportNull$$$0(14);
        }
        return psiFieldArray;
    }

    @NotNull
    protected abstract PsiField[] doGetFields();

    @NotNull
    protected abstract Object[] getFieldsDependencies();

    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = this.myResourceType;
        if (resourceType == null) {
            InnerRClassBase.$$$reportNull$$$0(15);
        }
        return resourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldModifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPublic";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/augment/InnerRClassBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/augment/InnerRClassBase";
                break;
            }
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResourceFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildResourceFields";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

