/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceDirectoryDialogBase;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDirectoryDialog
extends CreateResourceDirectoryDialogBase {
    private JComboBox<ResourceFolderType> myResourceTypeComboBox;
    private JPanel myDeviceConfiguratorWrapper;
    private JTextField myDirectoryNameTextField;
    private JPanel myContentPanel;
    private JBLabel myErrorLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel mySourceSetLabel;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private ElementCreatingValidator myValidator;
    private final CreateResourceDirectoryDialogBase.ValidatorFactory myValidatorFactory;
    private final PsiDirectory myResDirectory;
    private final DataContext myDataContext;

    public CreateResourceDirectoryDialog(@NotNull Project project, @Nullable Module module, @Nullable ResourceFolderType resType, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, @NotNull CreateResourceDirectoryDialogBase.ValidatorFactory validatorFactory) {
        if (project == null) {
            CreateResourceDirectoryDialog.$$$reportNull$$$0(0);
        }
        if (validatorFactory == null) {
            CreateResourceDirectoryDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myResDirectory = resDirectory;
        this.myDataContext = dataContext;
        this.myValidatorFactory = validatorFactory;
        this.$$$setupUI$$$();
        this.myResourceTypeComboBox.setModel((ComboBoxModel<ResourceFolderType>)new EnumComboBoxModel(ResourceFolderType.class));
        this.myResourceTypeComboBox.setRenderer((ListCellRenderer<ResourceFolderType>)SimpleListCellRenderer.create((String)"", ResourceFolderType::getName));
        this.myDeviceConfiguratorPanel = this.setupDeviceConfigurationPanel(this.myResourceTypeComboBox, this.myDirectoryNameTextField, this.myErrorLabel);
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.myResourceTypeComboBox.addActionListener(event -> this.myDeviceConfiguratorPanel.applyEditors());
        if (resType != null) {
            this.myResourceTypeComboBox.setSelectedItem(resType);
            this.myResourceTypeComboBox.setEnabled(false);
        } else {
            this.myResourceTypeComboBox.setSelectedItem(ResourceFolderType.VALUES);
        }
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, facet);
        this.myDeviceConfiguratorPanel.updateAll();
        this.setOKActionEnabled(!this.myDirectoryNameTextField.getText().isEmpty());
        this.init();
    }

    @Nullable
    public ValidationInfo doValidate() {
        PsiDirectory directory = this.getResourceDirectory(this.myDataContext);
        if (directory == null) {
            return null;
        }
        PsiDirectory subdirectory = directory.findSubdirectory(this.myDirectoryNameTextField.getText());
        if (subdirectory != null) {
            return new ValidationInfo(subdirectory.getVirtualFile().getPresentableUrl() + " already exists. Use a different qualifier.");
        }
        return null;
    }

    protected void doOKAction() {
        String dirName = this.myDirectoryNameTextField.getText();
        assert (dirName != null);
        PsiDirectory resourceDirectory = this.getResourceDirectory(this.myDataContext);
        if (resourceDirectory == null) {
            Module module = (Module)LangDataKeys.MODULE.getData(this.myDataContext);
            Messages.showErrorDialog((String)AndroidBundle.message("check.resource.dir.error", module), (String)CommonBundle.getErrorTitle());
            super.doOKAction();
            return;
        }
        this.myValidator = this.myValidatorFactory.create(resourceDirectory);
        if (this.myValidator.checkInput(dirName) && this.myValidator.canClose(dirName)) {
            super.doOKAction();
        }
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceDirectoryDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myResourceTypeComboBox.isEnabled()) {
            return this.myResourceTypeComboBox;
        }
        return this.myDirectoryNameTextField;
    }

    JTextComponent getDirectoryNameTextField() {
        return this.myDirectoryNameTextField;
    }

    @Override
    @NotNull
    public PsiElement[] getCreatedElements() {
        PsiElement[] psiElementArray = this.myValidator != null ? this.myValidator.getCreatedElements() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            CreateResourceDirectoryDialog.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Nullable
    private PsiDirectory getResourceDirectory(@Nullable DataContext context) {
        if (this.myResDirectory != null) {
            return this.myResDirectory;
        }
        if (context != null) {
            Module module = (Module)LangDataKeys.MODULE.getData(context);
            assert (module != null);
            return CreateResourceDialogUtils.getResourceDirectory(CreateResourceDialogUtils.getSourceProvider(this.mySourceSetCombo), module, true);
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validatorFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/CreateResourceDirectoryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/CreateResourceDirectoryDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreatedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(800, 400));
        JComboBox jComboBox2 = new JComboBox();
        this.myResourceTypeComboBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Resource type:");
        jBLabel3.setDisplayedMnemonic('R');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceConfiguratorWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Directory name:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryNameTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel3.setLabelFor(jComboBox2);
        jLabel.setLabelFor(jTextField);
        jBLabel.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

