/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidConnectDebuggerAction
extends AnAction {
    private final boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog = new AndroidProcessChooserDialog(project, true);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Client client = dialog.getClient();
            if (client == null) {
                return;
            }
            AndroidConnectDebuggerAction.closeOldSessionAndRun(project, dialog.getAndroidDebugger(), client);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        boolean isVisible = this.isAndroidStudio || project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        e.getPresentation().setVisible(isVisible);
    }

    private static void closeOldSessionAndRun(@NotNull Project project, @NotNull AndroidDebugger androidDebugger, @NotNull Client client) {
        if (project == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(2);
        }
        if (androidDebugger == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(3);
        }
        if (client == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(4);
        }
        AndroidConnectDebuggerAction.terminateRunSessions(project, client);
        androidDebugger.attachToClient(project, client);
    }

    private static void terminateRunSessions(@NotNull Project project, @NotNull Client selectedClient) {
        if (project == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(5);
        }
        if (selectedClient == null) {
            AndroidConnectDebuggerAction.$$$reportNull$$$0(6);
        }
        int pid = selectedClient.getClientData().getPid();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Client client;
            if (!(handler instanceof AndroidProcessHandler) || (client = ((AndroidProcessHandler)handler).getClient(selectedClient.getDevice())) == null || client.getClientData().getPid() != pid) continue;
            ((AndroidProcessHandler)handler).setNoKill();
            handler.detachProcess();
            handler.notifyTextAvailable("Disconnecting run session: a new debug session will be established.\n", ProcessOutputTypes.STDOUT);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebugger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedClient";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/AndroidConnectDebuggerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "closeOldSessionAndRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "terminateRunSessions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

