/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Objects;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidJavaCompletionContributor
extends CompletionContributor {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"javax.swing", "javafx"};

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        PsiReferenceExpression ref3;
        PsiReferenceExpression ref2;
        PsiReferenceExpression ref;
        if (parameters == null) {
            AndroidJavaCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            AndroidJavaCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, resultSet);
        PsiElement position = parameters.getPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null) {
            return;
        }
        if (AndroidMavenUtil.isMavenizedModule(facet.getModule())) {
            resultSet.runRemainingContributors(parameters, result2 -> {
                String qName;
                Object obj = result2.getLookupElement().getObject();
                if (obj instanceof PsiClass && (qName = ((PsiClass)obj).getQualifiedName()) != null && !AndroidJavaCompletionContributor.isAllowedInAndroid(qName)) {
                    return;
                }
                resultSet.passResult(result2);
            });
        }
        if (position.getParent() instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)position.getParent()).getQualifierExpression() != null && ref.getQualifierExpression() instanceof PsiReferenceExpression && (ref2 = (PsiReferenceExpression)ref.getQualifierExpression()).getQualifierExpression() instanceof PsiReferenceExpression && "R".equals((ref3 = (PsiReferenceExpression)ref2.getQualifierExpression()).getReferenceName())) {
            boolean filterPrivateResources = false;
            PsiExpression qualifierExpression = ref3.getQualifierExpression();
            if (qualifierExpression == null) {
                filterPrivateResources = true;
            } else if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                if (Objects.equals(AndroidManifestUtils.getPackageName(facet), referenceExpression.getQualifiedName()) || Objects.equals(AndroidManifestUtils.getTestPackageName(facet), referenceExpression.getQualifiedName())) {
                    filterPrivateResources = true;
                }
            }
            if (filterPrivateResources) {
                this.filterPrivateResources(parameters, resultSet, facet);
            }
        }
    }

    public void filterPrivateResources(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet, AndroidFacet facet) {
        ResourceVisibilityLookup lookup;
        if (parameters == null) {
            AndroidJavaCompletionContributor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            AndroidJavaCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((lookup = ResourceRepositoryManager.getOrCreateInstance(facet).getResourceVisibility()).isEmpty()) {
            return;
        }
        resultSet.runRemainingContributors(parameters, result2 -> {
            ResourceType type;
            PsiClass rClass;
            PsiField field2;
            PsiClass containingClass;
            Object obj = result2.getLookupElement().getObject();
            if (obj instanceof PsiField && (containingClass = (field2 = (PsiField)obj).getContainingClass()) != null && (rClass = containingClass.getContainingClass()) != null && "R".equals(rClass.getName()) && (type = ResourceType.fromClassName((String)containingClass.getName())) != null && lookup.isPrivate(type, field2.getName())) {
                return;
            }
            resultSet.passResult(result2);
        });
    }

    private static boolean isAllowedInAndroid(@NotNull String qName) {
        if (qName == null) {
            AndroidJavaCompletionContributor.$$$reportNull$$$0(4);
        }
        for (String aPackage : EXCLUDED_PACKAGES) {
            if (!qName.startsWith(aPackage + ".")) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidJavaCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filterPrivateResources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedInAndroid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

