/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nullable;

public class AndroidGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor2) {
        if (!(sourceElement instanceof PsiIdentifier)) {
            return null;
        }
        PsiFile file = sourceElement.getContainingFile();
        if (file == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        PsiReferenceExpression refExp = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiReferenceExpression.class);
        if (refExp == null) {
            return null;
        }
        AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, refExp, false);
        if (info == null) {
            PsiElement parent = refExp.getParent();
            if (parent instanceof PsiReferenceExpression) {
                info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, false);
            }
            if (info == null && (parent = parent.getParent()) instanceof PsiReferenceExpression) {
                info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, false);
            }
        }
        if (info == null) {
            return null;
        }
        return AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(info, refExp);
    }
}

