/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.adtui.LightCalloutPopup;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilder;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialColorPaletteProvider;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialGraphicalColorPipetteProvider;
import com.android.utils.HashCodes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.MouseInfo;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;

public class AndroidAnnotatorUtil {
    static final int MAX_ICON_SIZE = 5000;
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;

    @Nullable
    public static VirtualFile pickBitmapFromXml(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull ResourceValue resourceValue2) {
        if (file == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(0);
        }
        if (resourceResolver == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(3);
        }
        if (resourceValue2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(4);
        }
        try {
            String tagName;
            XmlPullParser parser = FileResourceReader.createXmlPullParser(file);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            String source = null;
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet);
                    List items2 = resourceRepository.getResources(resourceValue2.getNamespace(), resourceValue2.getResourceType(), resourceValue2.getName());
                    for (ResourceItem item : items2) {
                        Density density;
                        FolderConfiguration configuration = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return ResourceHelper.getSourceAsVirtualFile(item);
                    }
                    return file;
                }
                case "bitmap": 
                case "nine-patch": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                case "selector": 
                case "level-list": 
                case "layer-list": 
                case "transition": {
                    int childDepth = parser.getDepth() + 1;
                    parser.nextTag();
                    while (parser.getDepth() >= childDepth) {
                        String value2;
                        if (parser.getEventType() == 2 && parser.getDepth() == childDepth && "item".equals(parser.getName()) && (value2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable")) != null) {
                            source = value2;
                        }
                        parser.nextTag();
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            if (source == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver.findResValue(source, resourceValue2.isFramework());
            return resValue == null ? null : ResourceHelper.resolveDrawable((RenderResources)resourceResolver, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickBestBitmap(@Nullable VirtualFile bitmap) {
        if (bitmap != null && bitmap.exists()) {
            VirtualFile smallest = AndroidAnnotatorUtil.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.getLength();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(@NotNull VirtualFile bitmap) {
        VirtualFile parentFile;
        if (bitmap == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(5);
        }
        if ((parentFile = bitmap.getParent()) == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i2 = densities.length;
            while (--i2 >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i2];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    public static ResourceValue findResourceValue(@NotNull ResourceType type, @NotNull String name, boolean isFramework, @NotNull Module module, @NotNull Configuration configuration) {
        if (type == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(7);
        }
        if (module == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(9);
        }
        if (isFramework) {
            ResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            List items2 = frameworkResources.getResources(ResourceNamespace.ANDROID, type, name);
            if (items2.isEmpty()) {
                return null;
            }
            return ((ResourceItem)items2.get(0)).getResourceValue();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(module);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResources(ResourceNamespace.TODO(), type, name)) {
            return null;
        }
        return ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)appResources, (ResourceType)type, (String)name, (FolderConfiguration)configuration.getFullConfig());
    }

    @Nullable
    public static Configuration pickConfiguration(@NotNull AndroidFacet facet, @NotNull Module module, @NotNull PsiFile file) {
        VirtualFile layout2;
        VirtualFile virtualFile;
        if (facet == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(10);
        }
        if (module == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(11);
        }
        if (file == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(12);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        String parentName = parent.getName();
        if (!parentName.startsWith("layout")) {
            layout2 = ResourceHelper.pickAnyLayoutFile(module, facet);
            if (layout2 == null) {
                return null;
            }
        } else {
            layout2 = virtualFile;
        }
        return ConfigurationManager.getOrCreateInstance(module).getConfiguration(layout2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitmap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidAnnotatorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pickBitmapFromXml";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findSmallestDpiVersion";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "pickConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;
        private final Function1<Color, Unit> mySetColorTask;

        public ColorRenderer(@NotNull PsiElement element, @Nullable Color color) {
            if (element == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myColor = color;
            this.mySetColorTask = ColorRenderer.createSetColorTask(this.myElement);
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            JBUI.JBIcon jBIcon = color == null ? JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8)) : JBUI.scale((JBUI.JBIcon)new ColorIcon(8, color));
            if (jBIcon == null) {
                ColorRenderer.$$$reportNull$$$0(1);
            }
            return jBIcon;
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (this.myColor != null) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                    if (editor2 != null) {
                        if (((Boolean)StudioFlags.NELE_NEW_COLOR_PICKER.get()).booleanValue()) {
                            this.openNewColorPicker(this.getCurrentColor());
                        } else {
                            Color color = ColorPicker.showDialog(editor2.getComponent(), "Choose Color", this.getCurrentColor(), true, null, false);
                            if (color != null) {
                                this.setColorToAttribute(color);
                            }
                        }
                    }
                }
            };
        }

        private void openNewColorPicker(@Nullable Color currentColor) {
            LightCalloutPopup dialog = new LightCalloutPopup();
            JPanel panel2 = new ColorPickerBuilder().setOriginalColor(currentColor).addSaturationBrightnessComponent().addColorAdjustPanel(new MaterialGraphicalColorPipetteProvider()).addColorValuePanel().withFocus().addSeparator().addCustomComponent(MaterialColorPaletteProvider.INSTANCE).addColorListener((color, source) -> this.setColorToAttribute(color)).focusWhenDisplay(true).setFocusCycleRoot(true).build();
            dialog.show((JComponent)panel2, null, MouseInfo.getPointerInfo().getLocation());
        }

        private void setColorToAttribute(@NotNull Color color) {
            if (color == null) {
                ColorRenderer.$$$reportNull$$$0(2);
            }
            Project project = this.myElement.getProject();
            TransactionGuard.submitTransaction((Disposable)project, () -> WriteCommandAction.runWriteCommandAction((Project)project, (String)AndroidAnnotatorUtil.SET_COLOR_COMMAND_NAME, null, () -> {
                Unit cfr_ignored_0 = (Unit)this.mySetColorTask.invoke((Object)color);
            }, (PsiFile[])new PsiFile[0]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (this.myColor != null ? !this.myColor.equals(that.myColor) : that.myColor != null) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return HashCodes.mix((int)this.myElement.hashCode(), (int)Objects.hashCode(this.myColor));
        }

        public static Function1<Color, Unit> createSetColorTask(@NotNull PsiElement element) {
            XmlAttribute xmlAttribute;
            if (element == null) {
                ColorRenderer.$$$reportNull$$$0(3);
            }
            if (element instanceof XmlTag) {
                final XmlTagValue xmlTagValue = ((XmlTag)element).getValue();
                return new Function1<Color, Unit>(){

                    public Unit invoke(Color color) {
                        xmlTagValue.setText(ResourceHelper.colorToString(color));
                        return Unit.INSTANCE;
                    }
                };
            }
            if (element instanceof XmlAttributeValue && (xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null) {
                return new Function1<Color, Unit>(){

                    public Unit invoke(Color color) {
                        xmlAttribute.setValue(ResourceHelper.colorToString(color));
                        return Unit.INSTANCE;
                    }
                };
            }
            return color -> Unit.INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidAnnotatorUtil$ColorRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidAnnotatorUtil$ColorRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setColorToAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createSetColorTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

