/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.util.CancelableRunnable;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.rendering.parsers.DomPullParser;
import com.android.tools.swing.layoutlib.AlreadyDisposedException;
import com.android.tools.swing.layoutlib.GraphicsLayoutRenderer;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class AndroidPreviewPanel
extends JComponent
implements Scrollable,
Disposable {
    private static final Logger LOG = Logger.getInstance(AndroidPreviewPanel.class);
    public static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 5;
    public static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 10;
    private final AtomicBoolean myRunningInvalidates;
    private final AtomicBoolean myPendingInvalidates;
    private final GraphicsLayoutRendererFactory myGraphicsLayoutRendererFactory;
    private final Executor myExecutor;
    @VisibleForTesting
    protected final CancelableRunnable myInvalidateRunnable;
    private static final Notification UNSUPPORTED_LAYOUTLIB_NOTIFICATION = new Notification("Android", "Preview", "The Theme Editor preview requires at least Android M Platform SDK", NotificationType.ERROR);
    private static final AtomicBoolean ourLayoutlibNotification = new AtomicBoolean(false);
    private static final AtomicBoolean ourJavaRuntimeNotification = new AtomicBoolean(false);
    private final DumbService myDumbService;
    private final Object myGraphicsLayoutRendererLock;
    @GuardedBy(value="myGraphicsLayoutRendererLock")
    private GraphicsLayoutRenderer myGraphicsLayoutRenderer;
    private Configuration myConfiguration;
    private Document myDocument;
    private double myScale;
    private Dimension myLastRenderedSize;
    private Dimension myCachedPreferredSize;
    private int myCurrentWidth;
    private boolean myNeedsRepaint;

    @VisibleForTesting
    AndroidPreviewPanel(@NotNull Configuration configuration, @NotNull Executor executor, @NotNull GraphicsLayoutRendererFactory graphicsLayoutRendererFactory) {
        if (configuration == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(1);
        }
        if (graphicsLayoutRendererFactory == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(2);
        }
        this.myRunningInvalidates = new AtomicBoolean(false);
        this.myPendingInvalidates = new AtomicBoolean(false);
        this.myInvalidateRunnable = new CancelableRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AndroidPreviewPanel.this.getProject().isOpen()) {
                    return;
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    AndroidPreviewPanel.this.myExecutor.execute((Runnable)AndroidPreviewPanel.this.myInvalidateRunnable);
                    return;
                }
                try {
                    Object object = AndroidPreviewPanel.this.myGraphicsLayoutRendererLock;
                    synchronized (object) {
                        if (AndroidPreviewPanel.this.myGraphicsLayoutRenderer != null) {
                            AndroidPreviewPanel.this.myGraphicsLayoutRenderer.dispose();
                            AndroidPreviewPanel.this.myGraphicsLayoutRenderer = null;
                        }
                    }
                    if (!AndroidPreviewPanel.this.getProject().isOpen()) {
                        return;
                    }
                    ILayoutPullParser parser = DomPullParser.createFromDocument(AndroidPreviewPanel.this.myDocument);
                    GraphicsLayoutRenderer graphicsLayoutRenderer = AndroidPreviewPanel.this.myGraphicsLayoutRendererFactory.createGraphicsLayoutRenderer(AndroidPreviewPanel.this.myConfiguration, parser, AndroidPreviewPanel.this.getBackground());
                    graphicsLayoutRenderer.setScale(AndroidPreviewPanel.this.myScale);
                    graphicsLayoutRenderer.setSize(AndroidPreviewPanel.this.getWidth(), 1);
                    Object object2 = AndroidPreviewPanel.this.myGraphicsLayoutRendererLock;
                    synchronized (object2) {
                        AndroidPreviewPanel.this.myGraphicsLayoutRenderer = graphicsLayoutRenderer;
                        if (AndroidPreviewPanel.this.myNeedsRepaint) {
                            AndroidPreviewPanel.this.repaint();
                            AndroidPreviewPanel.this.myNeedsRepaint = false;
                        }
                    }
                }
                catch (AlreadyDisposedException | ProcessCanceledException parser) {
                }
                catch (UnsupportedLayoutlibException e) {
                    AndroidPreviewPanel.notifyUnsupportedLayoutlib();
                }
                catch (InitializationException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof UnsupportedJavaRuntimeException) {
                        AndroidPreviewPanel.notifyUnsupportedJavaRuntime(((UnsupportedJavaRuntimeException)cause).getPresentableMessage());
                    }
                    LOG.error((Throwable)e);
                }
            }
        });
        this.myGraphicsLayoutRendererLock = new Object();
        this.myScale = 1.0;
        this.myConfiguration = configuration;
        this.myDumbService = DumbService.getInstance((Project)this.getProject());
        this.myExecutor = executor;
        this.myGraphicsLayoutRendererFactory = graphicsLayoutRendererFactory;
    }

    public AndroidPreviewPanel(@NotNull Configuration configuration) {
        if (configuration == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(3);
        }
        this(configuration, ForkJoinPool.commonPool(), (configuration1, parser, background) -> GraphicsLayoutRenderer.create(configuration1, parser, background, false, true));
        this.myConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension previousSize = this.getSize();
        super.setBounds(x, y, width, height);
        Dimension currentSize = this.getSize();
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null && (Math.abs(currentSize.width - previousSize.width) > 5 || Math.abs(currentSize.height - previousSize.height) > 5)) {
                this.myGraphicsLayoutRenderer.setSize(width, this.myCurrentWidth < width ? 1 : height);
                this.myCurrentWidth = width;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double scale) {
        this.myScale = scale;
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myGraphicsLayoutRenderer.setScale(scale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revalidate() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myCurrentWidth = this.getWidth();
                this.myGraphicsLayoutRenderer.setSize(this.myCurrentWidth, this.getHeight());
            }
        }
        super.revalidate();
    }

    public void invalidateGraphicsRenderer() {
        if (this.myDocument != null) {
            this.myPendingInvalidates.set(true);
            if (!this.myRunningInvalidates.get()) {
                InvalidateTask invalidateTask = new InvalidateTask();
                Disposer.register((Disposable)this, (Disposable)invalidateTask);
                invalidateTask.execute();
            }
        }
    }

    public void updateConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(4);
        }
        this.myConfiguration = configuration;
        this.invalidateGraphicsRenderer();
    }

    public void setDocument(@NotNull Document document) {
        if (document == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(5);
        }
        this.myDocument = document;
        this.invalidateGraphicsRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(@NotNull Graphics graphics) {
        if (graphics == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(6);
        }
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myGraphicsLayoutRenderer.render((Graphics2D)graphics);
                Dimension renderSize = this.myGraphicsLayoutRenderer.getPreferredSize();
                if (!renderSize.equals(this.myLastRenderedSize)) {
                    this.myLastRenderedSize = renderSize;
                    this.revalidate();
                }
            } else {
                this.myNeedsRepaint = true;
            }
        }
    }

    private static void notifyUnsupportedLayoutlib() {
        if (ourLayoutlibNotification.compareAndSet(false, true)) {
            Notifications.Bus.notify((Notification)UNSUPPORTED_LAYOUTLIB_NOTIFICATION);
        }
    }

    private static void notifyUnsupportedJavaRuntime(@NotNull String message) {
        if (message == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(7);
        }
        if (ourJavaRuntimeNotification.compareAndSet(false, true)) {
            Notifications.Bus.notify((Notification)new Notification("Android", "Preview", message, NotificationType.ERROR));
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2 == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(8);
        }
        return dimension2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.isPreferredSizeSet() || this.myGraphicsLayoutRenderer == null) {
                return this.myCachedPreferredSize == null ? super.getPreferredSize() : this.myCachedPreferredSize;
            }
            this.myCachedPreferredSize = this.myGraphicsLayoutRenderer.getPreferredSize();
            return this.myCachedPreferredSize;
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsedAttrs() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer == null) {
                return Collections.emptySet();
            }
            return this.myGraphicsLayoutRenderer.getUsedAttrs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<ViewInfo> getRootViews() {
        Object object = this.myGraphicsLayoutRendererLock;
        // MONITORENTER : object
        List<Object> list = this.myGraphicsLayoutRenderer == null ? Collections.emptyList() : this.myGraphicsLayoutRenderer.getRootViews();
        // MONITOREXIT : object
        if (list != null) return list;
        AndroidPreviewPanel.$$$reportNull$$$0(9);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewInfo findViewAtPoint(Point p) {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            return this.myGraphicsLayoutRenderer != null ? this.myGraphicsLayoutRenderer.findViewAtPoint(p) : null;
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.invalidateGraphicsRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myGraphicsLayoutRenderer.dispose();
            }
        }
    }

    @NotNull
    private Project getProject() {
        Project project = this.myConfiguration.getModule().getProject();
        if (project == null) {
            AndroidPreviewPanel.$$$reportNull$$$0(10);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphicsLayoutRendererFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/swing/layoutlib/AndroidPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/swing/layoutlib/AndroidPreviewPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredScrollableViewportSize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyUnsupportedJavaRuntime";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InvalidateTask
    extends SwingWorker<Void, Void>
    implements Disposable {
        private boolean myDone;

        private InvalidateTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            do {
                AndroidPreviewPanel.this.myRunningInvalidates.set(true);
                AndroidPreviewPanel.this.myPendingInvalidates.set(false);
                AndroidPreviewPanel.this.myDumbService.waitForSmartMode();
                AndroidPreviewPanel.this.myDumbService.runWhenSmart((Runnable)AndroidPreviewPanel.this.myInvalidateRunnable);
                AndroidPreviewPanel.this.myRunningInvalidates.set(false);
            } while (AndroidPreviewPanel.this.myPendingInvalidates.get());
            return null;
        }

        @Override
        protected void done() {
            block9: {
                try {
                    this.get();
                    AndroidPreviewPanel.this.repaint();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof ProcessCanceledException) {
                        break block9;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new RuntimeException(t);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.myDone = true;
                    Disposer.dispose((Disposable)this);
                }
            }
        }

        public void dispose() {
            if (!this.myDone) {
                AndroidPreviewPanel.this.myInvalidateRunnable.cancel(true);
                this.cancel(true);
            }
        }
    }

    @VisibleForTesting
    static interface GraphicsLayoutRendererFactory {
        public GraphicsLayoutRenderer createGraphicsLayoutRenderer(@NotNull Configuration var1, @NotNull ILayoutPullParser var2, @NotNull Color var3) throws InitializationException;
    }
}

