/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedStateStore
implements Function<Key<?>, Object> {
    private Map<Key, Object> myState;
    private Set<Key> myRecentlyUpdated;
    private Scope myScope;
    private final Collection<WeakReference<ScopedStoreListener>> myListeners;
    @Nullable
    private ScopedStateStore myParent;
    private final ScopedStoreListener myParentListener;

    public ScopedStateStore(@NotNull Scope scope, @Nullable ScopedStateStore parent, @Nullable ScopedStoreListener listener2) {
        if (scope == null) {
            ScopedStateStore.$$$reportNull$$$0(0);
        }
        this.myState = Maps.newHashMap();
        this.myRecentlyUpdated = Sets.newHashSet();
        this.myListeners = Lists.newArrayListWithCapacity((int)4);
        this.myParentListener = new ScopedStoreListener(){

            @Override
            public <T> void invokeUpdate(@Nullable Key<T> changedKey) {
                ScopedStateStore.this.notifyListeners(changedKey);
            }
        };
        this.myScope = scope;
        if (this.myParent != null && this.myScope.isGreaterThan(this.myParent.myScope)) {
            throw new IllegalArgumentException("Attempted to add store of scope " + this.myScope.toString() + " as child of lesser scope " + this.myParent.myScope.toString());
        }
        this.myParent = parent;
        if (listener2 != null) {
            this.addListener(listener2);
        }
        if (this.myParent != null) {
            this.myParent.addListener(this.myParentListener);
        }
    }

    public final void addListener(@NotNull ScopedStoreListener listener2) {
        if (listener2 == null) {
            ScopedStateStore.$$$reportNull$$$0(1);
        }
        this.myListeners.add(new WeakReference<ScopedStoreListener>(listener2));
    }

    @Nullable
    public <T> T get(@NotNull Key<T> key) {
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(2);
        }
        if (this.myScope.equals((Object)key.scope) && this.myState.containsKey(key)) {
            try {
                return key.expectedClass.cast(this.myState.get(key));
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        if (this.myParent != null) {
            return this.myParent.get(key);
        }
        return null;
    }

    @NotNull
    public <T> T getNotNull(@NotNull Key<T> key, @NotNull T defaultValue) {
        T value2;
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(3);
        }
        if (defaultValue == null) {
            ScopedStateStore.$$$reportNull$$$0(4);
        }
        T t = (value2 = this.get(key)) == null ? defaultValue : value2;
        if (t == null) {
            ScopedStateStore.$$$reportNull$$$0(5);
        }
        return t;
    }

    public <T> boolean put(@NotNull Key<T> key, @Nullable T value2) {
        boolean stateChanged2;
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(6);
        }
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.name() + " in greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged2 = !this.myState.containsKey(key) || !ScopedStateStore.equals(this.myState.get(key), value2);
            this.myState.put(key, value2);
            if (stateChanged2) {
                this.notifyListeners(key);
            }
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged2 = this.myParent.put(key, value2);
        } else {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.toString() + " in lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        return stateChanged2;
    }

    private <T> void notifyListeners(@Nullable Key<T> key) {
        this.myRecentlyUpdated.add(key);
        Iterator<WeakReference<ScopedStoreListener>> iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            ScopedStoreListener listener2 = (ScopedStoreListener)iterator.next().get();
            if (listener2 == null) {
                iterator.remove();
                continue;
            }
            listener2.invokeUpdate(key);
        }
    }

    public <T> boolean listPush(@NotNull Key<List<T>> key, @NotNull T value2) {
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(7);
        }
        if (value2 == null) {
            ScopedStateStore.$$$reportNull$$$0(8);
        }
        List<Object> list = null;
        if (this.containsKey(key)) {
            list = this.get(key);
        }
        if (list == null) {
            list = Lists.newArrayList();
        }
        boolean stateChanged2 = list.add(value2);
        this.put(key, list);
        if (stateChanged2) {
            this.notifyListeners(key);
        }
        return stateChanged2;
    }

    public <T extends List> int listSize(@NotNull Key<T> key) {
        List list;
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(9);
        }
        if (this.containsKey(key) && (list = (List)this.get(key)) != null) {
            return list.size();
        }
        return 0;
    }

    public <T extends List<? super V>, V> boolean listRemove(@NotNull Key<T> key, @NotNull V value2) {
        List list;
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            ScopedStateStore.$$$reportNull$$$0(11);
        }
        boolean stateChanged2 = false;
        if (this.containsKey(key) && (list = (List)this.get(key)) != null) {
            stateChanged2 = list.remove(value2);
        }
        if (stateChanged2) {
            this.notifyListeners(key);
        }
        return stateChanged2;
    }

    public <T> void unsafePut(Key<T> key, @Nullable Object object) {
        this.put(key, key.expectedClass.cast(object));
    }

    private static boolean equals(@Nullable Object o, @Nullable Object o2) {
        if (o == null && o2 == null) {
            return true;
        }
        if (o != null) {
            return o.equals(o2);
        }
        return false;
    }

    public <T> void putAll(@NotNull Map<Key<T>, T> map2) {
        if (map2 == null) {
            ScopedStateStore.$$$reportNull$$$0(12);
        }
        for (Key<T> key : map2.keySet()) {
            this.put(key, map2.get(key));
        }
    }

    public void putAllInWizardScope(@NotNull ScopedStateStore store) {
        if (store == null) {
            ScopedStateStore.$$$reportNull$$$0(13);
        }
        for (Key key : store.getAllKeys()) {
            this.copyValue(store, key);
        }
    }

    private <T> void copyValue(@NotNull ScopedStateStore store, @NotNull Key<T> key) {
        if (store == null) {
            ScopedStateStore.$$$reportNull$$$0(14);
        }
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(15);
        }
        Key newKey = new Key(key.name, Scope.WIZARD, key.expectedClass);
        this.put(newKey, store.get(key));
    }

    public <T> boolean remove(@NotNull Key<T> key) {
        boolean stateChanged2;
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(16);
        }
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged2 = this.myState.containsKey(key);
            this.myState.remove(key);
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged2 = this.myParent.remove(key);
        } else {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        if (stateChanged2) {
            this.notifyListeners(key);
        }
        return stateChanged2;
    }

    public <T> boolean containsKey(@NotNull Key<T> key) {
        if (key == null) {
            ScopedStateStore.$$$reportNull$$$0(17);
        }
        if (this.myScope.equals((Object)key.scope)) {
            return this.myState.containsKey(key);
        }
        if (this.myParent != null && key.scope.isGreaterThan(this.myScope)) {
            return this.myParent.containsKey(key);
        }
        return false;
    }

    public Map<String, Object> flatten() {
        HashMap toReturn = this.myParent != null ? this.myParent.flatten() : Maps.newHashMapWithExpectedSize((int)this.myState.size());
        for (Key key : this.myState.keySet()) {
            toReturn.put(key.name, this.myState.get(key));
        }
        return toReturn;
    }

    public Set<Key> getRecentUpdates() {
        return this.myRecentlyUpdated;
    }

    public void clearRecentUpdates() {
        this.myRecentlyUpdated.clear();
    }

    public static <T> Key<T> createKey(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
        if (name == null) {
            ScopedStateStore.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            ScopedStateStore.$$$reportNull$$$0(19);
        }
        if (clazz == null) {
            ScopedStateStore.$$$reportNull$$$0(20);
        }
        return new Key(name, scope, clazz);
    }

    public <T> Key<T> createKey(@NotNull String name, @NotNull Class<T> clazz) {
        if (name == null) {
            ScopedStateStore.$$$reportNull$$$0(21);
        }
        if (clazz == null) {
            ScopedStateStore.$$$reportNull$$$0(22);
        }
        return ScopedStateStore.createKey(name, this.myScope, clazz);
    }

    public Object apply(Key<?> input) {
        return this.get(input);
    }

    public Set<Key> getAllKeys() {
        if (this.myParent == null) {
            return ImmutableSet.copyOf(this.myState.keySet());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.concat(this.myState.keySet(), this.myParent.getAllKeys()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/dynamic/ScopedStateStore";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/dynamic/ScopedStateStore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listPush";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "listSize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listRemove";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putAllInWizardScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Scope {
        STEP,
        PATH,
        WIZARD;


        public boolean isGreaterThan(@Nullable Scope other) {
            if (other == null) {
                return false;
            }
            return this.ordinal() > other.ordinal();
        }
    }

    public static class Key<T> {
        @NotNull
        public final Class<T> expectedClass;
        @NotNull
        public final String name;
        @NotNull
        public final Scope scope;

        private Key(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
            if (name == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                Key.$$$reportNull$$$0(1);
            }
            if (clazz == null) {
                Key.$$$reportNull$$$0(2);
            }
            this.expectedClass = clazz;
            this.name = name;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.expectedClass.equals(key.expectedClass)) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            return this.scope == key.scope;
        }

        public int hashCode() {
            int result2 = this.expectedClass.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.scope.hashCode();
            return result2;
        }

        public String toString() {
            return "Key{" + this.expectedClass.getSimpleName() + " " + (Object)((Object)this.scope) + "#" + this.name + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazz";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/wizard/dynamic/ScopedStateStore$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ScopedStoreListener {
        public <T> void invokeUpdate(@Nullable Key<T> var1);
    }
}

