/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.AndroidIcons;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizard
implements ScopedStateStore.ScopedStoreListener {
    public static final int MAX_UPDATE_ATTEMPTS = 42;
    public static Logger LOG = Logger.getInstance(DynamicWizard.class);
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myUpdateInProgress;
    @Nullable
    private Project myProject;
    @Nullable
    private Module myModule;
    @NotNull
    protected final DynamicWizardHost myHost;
    protected String myName;
    protected ArrayList<AndroidStudioWizardPath> myPaths;
    protected AndroidStudioWizardPath myCurrentPath;
    protected PathIterator myPathListIterator;
    private boolean myIsInitialized;
    protected ScopedStateStore myState;
    private JPanel myContentPanel;
    private Map<JComponent, String> myComponentToIdMap;

    public DynamicWizard(@Nullable Project project, @Nullable Module module, @NotNull String name) {
        if (name == null) {
            DynamicWizard.$$$reportNull$$$0(0);
        }
        this(project, module, name, new DialogWrapperHost(project));
    }

    public DynamicWizard(@Nullable Project project, @Nullable Module module, @NotNull String name, @NotNull DynamicWizardHost host) {
        if (name == null) {
            DynamicWizard.$$$reportNull$$$0(1);
        }
        if (host == null) {
            DynamicWizard.$$$reportNull$$$0(2);
        }
        this.myPaths = Lists.newArrayList();
        this.myPathListIterator = new PathIterator(this.myPaths);
        this.myIsInitialized = false;
        this.myContentPanel = new JPanel(new CardLayout());
        this.myComponentToIdMap = Maps.newHashMap();
        this.myHost = host;
        this.myProject = project;
        this.myModule = module;
        this.myName = name;
        this.myHost.setTitle(name);
        Application application = ApplicationManager.getApplication();
        this.myUpdateQueue = application == null || application.isUnitTestMode() ? null : new MergingUpdateQueue("wizard", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.myHost.getDisposable(), null, true);
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.WIZARD, null, this);
    }

    public void init() {
        this.myHost.init(this);
        this.myIsInitialized = true;
        if (this.myUpdateQueue != null) {
            int guard = 0;
            while (!this.myUpdateQueue.isEmpty()) {
                this.myUpdateQueue.flush();
                if (++guard < 42) continue;
                throw new IllegalStateException("Circular dependencies detected. Model state cannot be settled down.");
            }
        }
        Step step = this.showNextStep(null);
        assert (step != null);
    }

    @Nullable
    public final MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.queue((Update)new WizardUpdate());
        } else {
            this.update();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.deriveValues(this.myState.getRecentUpdates());
            this.myUpdateInProgress = false;
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public abstract void performFinishingActions();

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    protected final Module getModule() {
        return this.myModule;
    }

    public final void setErrorHtml(String errorMessage) {
        if (this.myCurrentPath != null) {
            this.myCurrentPath.setErrorHtml(errorMessage);
        }
    }

    public final void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancelCurrentPath, boolean canFinishCurrentPath) {
        if (!this.myIsInitialized) {
            return;
        }
        this.myHost.updateButtons(canGoPrev && this.hasPrevious(), canGoNext && this.hasNext(), canCancelCurrentPath && this.canCancel(), canFinishCurrentPath && this.canFinish());
    }

    public final void addPath(@NotNull AndroidStudioWizardPath path) {
        if (path == null) {
            DynamicWizard.$$$reportNull$$$0(3);
        }
        this.myPaths.add(path);
        path.attachToWizard(this);
        this.myPathListIterator = new PathIterator(this.myPaths);
    }

    @NotNull
    public final ArrayList<AndroidStudioWizardPath> getAllPaths() {
        ArrayList<AndroidStudioWizardPath> arrayList = this.myPaths;
        if (arrayList == null) {
            DynamicWizard.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public final AndroidStudioWizardPath getCurrentPath() {
        return this.myCurrentPath;
    }

    public final int getVisibleStepCount() {
        int sum = 0;
        for (AndroidStudioWizardPath path : this.myPaths) {
            sum += path.getVisibleStepCount();
        }
        return sum;
    }

    private void showStep(@NotNull Step step) {
        if (step == null) {
            DynamicWizard.$$$reportNull$$$0(5);
        }
        JComponent component = step.getComponent();
        this.addStepIfNecessary(step);
        Icon icon = step.getIcon();
        this.myHost.setIcon(icon);
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, this.myComponentToIdMap.get(component));
        JComponent focusedComponent = step.getPreferredFocusedComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true);
        }
    }

    protected boolean canGoNext() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoNext();
    }

    protected boolean canGoPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoPrevious();
    }

    protected boolean hasNext() {
        return this.myCurrentPath != null && this.myCurrentPath.hasNext() || this.myPathListIterator.hasNext();
    }

    protected boolean hasPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.hasPrevious() || this.myPathListIterator.hasPrevious();
    }

    protected boolean canFinish() {
        if (!(this.myPathListIterator.hasNext() || this.myCurrentPath != null && this.myCurrentPath.hasNext())) {
            return true;
        }
        if (this.myCurrentPath != null && this.myCurrentPath.hasNext()) {
            return false;
        }
        boolean canFinish = true;
        PathIterator remainingPaths = this.myPathListIterator.getFreshCopy();
        while (canFinish && remainingPaths.hasNext()) {
            canFinish = !remainingPaths.next().isPathRequired();
        }
        return canFinish;
    }

    public final void doNextAction() {
        if (!this.canAdvance()) {
            this.myHost.shakeWindow();
            return;
        }
        Step newStep = this.showNextStep(this.myCurrentPath);
        if (newStep == null) {
            this.doFinishAction();
        }
    }

    @Nullable
    private Step showNextStep(@Nullable AndroidStudioWizardPath path) {
        Step newStep = null;
        if (path != null) {
            newStep = path.next();
        }
        if (newStep == null) {
            newStep = null;
            while (this.myPathListIterator.hasNext() && newStep == null) {
                this.myCurrentPath = this.myPathListIterator.next();
                assert (this.myCurrentPath != null);
                this.myCurrentPath.onPathStarted(true);
                newStep = this.myCurrentPath.getCurrentStep();
            }
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
        return newStep;
    }

    private boolean canAdvance() {
        if (this.myCurrentPath == null) {
            return true;
        }
        if (this.myCurrentPath.canGoNext()) {
            return this.myCurrentPath.hasNext() || this.myCurrentPath.readyToLeavePath();
        }
        return false;
    }

    public final void doPreviousAction() {
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoPrevious()) {
            this.myHost.shakeWindow();
            return;
        }
        Step newStep = this.myCurrentPath.previous();
        if (newStep == null) {
            while (this.myPathListIterator.hasPrevious() && newStep == null) {
                this.myCurrentPath = this.myPathListIterator.previous();
                assert (this.myCurrentPath != null);
                this.myCurrentPath.onPathStarted(false);
                newStep = this.myCurrentPath.getCurrentStep();
            }
        }
        if (newStep != null) {
            this.showStep(newStep);
        } else {
            LOG.error("Stepped into Path " + this.myCurrentPath + " which returned a null step");
        }
    }

    public void doFinishAction() {
        if (!this.checkFinish()) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                try {
                    DynamicWizard.this.doFinish();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }, this.getProgressTitle(), false, this.getProject(), this.getProgressParentComponent());
    }

    protected boolean checkFinish() {
        if (this.myCurrentPath != null && !this.myCurrentPath.readyToLeavePath()) {
            this.myHost.shakeWindow();
            return false;
        }
        this.myHost.close(DynamicWizardHost.CloseAction.FINISH);
        return true;
    }

    @Nullable
    public JComponent getProgressParentComponent() {
        return null;
    }

    @NotNull
    protected abstract String getProgressTitle();

    public void doCancelAction() {
        this.myHost.close(DynamicWizardHost.CloseAction.CANCEL);
    }

    @Nullable
    public final JComponent getPreferredFocusedComponent() {
        Step currentStep = this.myCurrentPath.getCurrentStep();
        if (currentStep != null) {
            return currentStep.getPreferredFocusedComponent();
        }
        return null;
    }

    protected abstract String getWizardActionDescription();

    public final ScopedStateStore getState() {
        return this.myState;
    }

    private void prepareForShow() {
        assert (this.myIsInitialized) : "Must call init() before showing!";
        for (AndroidStudioWizardPath path : this.myPaths) {
            for (Step step : path.getAllSteps()) {
                this.addStepIfNecessary(step);
            }
        }
        SwingUtilities.getWindowAncestor(this.myContentPanel).pack();
    }

    private void addStepIfNecessary(Step step) {
        JComponent component = step.getComponent();
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = String.valueOf(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add((Component)component, id);
        }
    }

    public void show() {
        this.prepareForShow();
        this.myHost.show();
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myHost.getDisposable();
        if (disposable == null) {
            DynamicWizard.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    public boolean showAndGet() {
        this.prepareForShow();
        return this.myHost.showAndGet();
    }

    public final Component getContentPane() {
        return this.myContentPanel;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public void setTitle(String title) {
        this.myHost.setTitle(title);
    }

    public boolean containsStep(@NotNull String stepName, boolean visibleOnly) {
        if (stepName == null) {
            DynamicWizard.$$$reportNull$$$0(7);
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (visibleOnly && !path.isPathVisible() || !path.containsStep(stepName, visibleOnly)) continue;
            return true;
        }
        return false;
    }

    public void navigateToNamedStep(@NotNull String stepName, boolean requireVisible) {
        if (stepName == null) {
            DynamicWizard.$$$reportNull$$$0(8);
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (requireVisible && !path.isPathVisible() || !path.containsStep(stepName, requireVisible)) continue;
            this.myCurrentPath = path;
            this.myPathListIterator.myCurrentIndex = this.myPathListIterator.myList.indexOf(this.myCurrentPath);
            this.myCurrentPath.navigateToNamedStep(stepName, requireVisible);
            this.showStep(this.myCurrentPath.getCurrentStep());
            return;
        }
    }

    public boolean canCancel() {
        return true;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Wizards.NewProjectMascotGreen;
    }

    protected void doFinish() throws IOException {
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (!path.isPathVisible() || path.canPerformFinishingActions()) continue;
            return;
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (!path.isPathVisible()) continue;
            path.performFinishingActions();
        }
        this.performFinishingActions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/dynamic/DynamicWizard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/dynamic/DynamicWizard";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPath";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsStep";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateToNamedStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WizardUpdate
    extends Update {
        WizardUpdate() {
            super((Object)"Wizard Update");
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{DynamicWizard.this};
            if (objectArray == null) {
                WizardUpdate.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public void run() {
            DynamicWizard.this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/dynamic/DynamicWizard$WizardUpdate", "getEqualityObjects"));
        }
    }

    protected static class PathIterator {
        private int myCurrentIndex;
        private ArrayList<AndroidStudioWizardPath> myList;

        public PathIterator(ArrayList<AndroidStudioWizardPath> list) {
            this.myList = list;
            this.myCurrentIndex = -1;
        }

        public PathIterator getFreshCopy() {
            PathIterator toReturn = new PathIterator(this.myList);
            toReturn.myCurrentIndex = this.myCurrentIndex;
            return toReturn;
        }

        public boolean hasNext() {
            if (this.myCurrentIndex >= this.myList.size() - 1) {
                return false;
            }
            for (int i2 = this.myCurrentIndex + 1; i2 < this.myList.size(); ++i2) {
                AndroidStudioWizardPath path = this.myList.get(i2);
                if (!path.isPathVisible() || path.getVisibleStepCount() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            if (this.myCurrentIndex <= 0) {
                return false;
            }
            for (int i2 = this.myCurrentIndex - 1; i2 >= 0; --i2) {
                if (!this.myList.get(i2).isPathVisible()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public AndroidStudioWizardPath next() {
            while (this.myCurrentIndex < this.myList.size() - 1) {
                AndroidStudioWizardPath next;
                if (!(next = this.myList.get(++this.myCurrentIndex)).isPathVisible()) continue;
                return next;
            }
            return null;
        }

        @Nullable
        public AndroidStudioWizardPath previous() {
            do {
                --this.myCurrentIndex;
            } while (this.myCurrentIndex >= 0 && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex >= 0) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }
    }
}

