/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleHighlighter
implements EditorHighlighter,
DocumentListener {
    private List<HighlightRange> myRanges = Lists.newArrayListWithCapacity((int)1024);
    private boolean myIsUpdatePending = false;
    private StringBuilder myPendingStrings = new StringBuilder(4096);
    private String myLastString = null;
    private HighlighterClient myEditor;
    private ModalityState myModalityState = ModalityState.defaultModalityState();

    public synchronized void print(String string, @Nullable TextAttributes attributes) {
        if (Objects.equals(this.myLastString, string)) {
            return;
        }
        this.myLastString = string;
        Application application = ApplicationManager.getApplication();
        this.myPendingStrings.append(string);
        if (!this.myIsUpdatePending && application != null && !application.isUnitTestMode()) {
            this.myIsUpdatePending = true;
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleHighlighter.this.appendToDocument();
                }
            }, this.myModalityState);
        }
        HighlightRange lastRange = (HighlightRange)Iterables.getLast(this.myRanges, (Object)HighlightRange.EMPTY);
        assert (lastRange != null);
        int start = lastRange.end;
        this.myRanges.add(new HighlightRange(start, start + string.length(), attributes));
    }

    public void setModalityState(ModalityState state) {
        this.myModalityState = state;
    }

    private synchronized String getPendingString() {
        String string = this.myPendingStrings.toString();
        this.myPendingStrings.delete(0, string.length());
        this.myIsUpdatePending = false;
        return string;
    }

    private void appendToDocument() {
        Document document = this.myEditor.getDocument();
        if (document != null) {
            String pendingString = StringUtil.convertLineSeparators((String)this.getPendingString());
            document.insertString(document.getTextLength(), (CharSequence)pendingString);
            if (this.myEditor instanceof Editor) {
                Editor editor2 = (Editor)this.myEditor;
                int lineCount = document.getLineCount();
                editor2.getScrollingModel().scrollTo(new LogicalPosition(lineCount - 1, 0), ScrollType.MAKE_VISIBLE);
            }
        }
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        HighlightedRangesIterator highlightedRangesIterator = new HighlightedRangesIterator(this.getOffsetRangeIndex(startOffset));
        if (highlightedRangesIterator == null) {
            ConsoleHighlighter.$$$reportNull$$$0(0);
        }
        return highlightedRangesIterator;
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            ConsoleHighlighter.$$$reportNull$$$0(1);
        }
    }

    public void setEditor(@NotNull HighlighterClient editor2) {
        if (editor2 == null) {
            ConsoleHighlighter.$$$reportNull$$$0(2);
        }
        this.myEditor = editor2;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ConsoleHighlighter.$$$reportNull$$$0(3);
        }
    }

    private synchronized HighlightRange getRange(int index) {
        if (index < 0 || index >= this.myRanges.size()) {
            return HighlightRange.EMPTY;
        }
        return this.myRanges.get(index);
    }

    synchronized int getOffsetRangeIndex(int startOffset) {
        if (this.myRanges.isEmpty() || startOffset < 0 || startOffset >= ((HighlightRange)Iterables.getLast(this.myRanges)).end) {
            return -1;
        }
        int end = this.myRanges.size();
        int i2 = end / 2;
        while (true) {
            HighlightRange range = this.myRanges.get(i2);
            if (range.end > startOffset) {
                if (range.start <= startOffset) {
                    return i2;
                }
                end = i2;
                i2 /= 2;
                continue;
            }
            i2 = (i2 + end) / 2;
        }
    }

    public void clear() {
        this.clearHighlightedState();
        this.myEditor.getDocument().setText((CharSequence)"");
    }

    private synchronized void clearHighlightedState() {
        this.myRanges.clear();
        this.myPendingStrings.delete(0, this.myPendingStrings.length() - 1);
        this.myIsUpdatePending = false;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessOutputProcessor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/wizard/ConsoleHighlighter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/wizard/ConsoleHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HighlightedRangesIterator
    implements HighlighterIterator {
        private int myIndex;
        @NotNull
        private HighlightRange myRange = HighlightRange.EMPTY;

        HighlightedRangesIterator(int index) {
            this.myIndex = index;
            this.myRange = ConsoleHighlighter.this.getRange(index);
        }

        @Nullable
        public TextAttributes getTextAttributes() {
            return this.myRange.attributes;
        }

        public int getStart() {
            return this.myRange.start;
        }

        public int getEnd() {
            return this.myRange.end;
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            this.myRange = ConsoleHighlighter.this.getRange(++this.myIndex);
        }

        public void retreat() {
            this.myRange = ConsoleHighlighter.this.getRange(--this.myIndex);
        }

        public boolean atEnd() {
            return this.myRange == HighlightRange.EMPTY;
        }

        public Document getDocument() {
            return ConsoleHighlighter.this.myEditor.getDocument();
        }
    }

    private class ProcessOutputProcessor
    extends ProcessAdapter {
        private AtomicBoolean mySkipped = new AtomicBoolean(false);

        private ProcessOutputProcessor() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ProcessOutputProcessor.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ProcessOutputProcessor.$$$reportNull$$$0(1);
            }
            if (!this.mySkipped.compareAndSet(false, true)) {
                ConsoleHighlighter.this.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType).getAttributes());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/welcome/wizard/ConsoleHighlighter$ProcessOutputProcessor";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class HighlightRange {
        public static final HighlightRange EMPTY = new HighlightRange(0, 0, null);
        @Nullable
        public final TextAttributes attributes;
        public final int start;
        public final int end;

        HighlightRange(int start, int end, @Nullable TextAttributes attributes) {
            this.attributes = attributes;
            this.start = start;
            this.end = end;
        }
    }
}

