/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstallOperation<Return, Argument> {
    protected final InstallContext myContext;
    private final double myProgressRatio;

    protected InstallOperation(InstallContext context, double progressRatio) {
        this.myContext = context;
        this.myProgressRatio = progressRatio;
    }

    public static <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context, @NotNull Function<Argument, Return> function, double progressShare) {
        if (context == null) {
            InstallOperation.$$$reportNull$$$0(0);
        }
        if (function == null) {
            InstallOperation.$$$reportNull$$$0(1);
        }
        return new FunctionWrapper<Return, Argument>(context, function, progressShare);
    }

    @NotNull
    protected abstract Return perform(@NotNull ProgressIndicator var1, @NotNull Argument var2) throws WizardException, InstallationCancelledException;

    @NotNull
    public final Return execute(final @NotNull Argument argument) throws WizardException, InstallationCancelledException {
        Object r;
        if (argument == null) {
            InstallOperation.$$$reportNull$$$0(2);
        }
        this.myContext.checkCanceled();
        if (this.myProgressRatio == 0.0) {
            Return Return = this.perform((ProgressIndicator)new EmptyProgressIndicator(), argument);
            if (Return == null) {
                InstallOperation.$$$reportNull$$$0(3);
            }
            return Return;
        }
        try {
            r = this.myContext.run(new ThrowableComputable<Return, Exception>(){

                @Nullable
                public Return compute() throws Exception {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator == null) {
                        indicator = new EmptyProgressIndicator();
                    }
                    return InstallOperation.this.perform(indicator, argument);
                }
            }, this.myProgressRatio);
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, WizardException.class, InstallationCancelledException.class);
            throw new RuntimeException(e);
        }
        if (r == null) {
            InstallOperation.$$$reportNull$$$0(4);
        }
        return (Return)r;
    }

    protected final void promptToRetry(@NotNull String prompt, @NotNull String failureDescription, @Nullable Exception e) throws WizardException {
        if (prompt == null) {
            InstallOperation.$$$reportNull$$$0(5);
        }
        if (failureDescription == null) {
            InstallOperation.$$$reportNull$$$0(6);
        }
        AtomicBoolean response = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            String wrappedPrompt = prompt.replaceAll("(\\p{Print}{30,50}([\\h\\n]|$))", "$1\n");
            String wrappedFailure = failureDescription.replaceAll("(\\p{Print}{30,50}([\\h\\n]|$))", "$1\n").replaceAll("(\\p{Print}{30,50}/)", "$1\n");
            int i2 = Messages.showDialog(null, (String)wrappedPrompt, (String)"Android Studio Setup", (String)wrappedFailure, (String[])new String[]{"Retry", "Cancel"}, (int)0, (int)0, (Icon)Messages.getErrorIcon());
            response.set(i2 == 0);
        }, application.getAnyModalityState());
        if (!response.get()) {
            if (e != null) {
                Throwables.throwIfInstanceOf((Throwable)e, WizardException.class);
            }
            throw new WizardException(failureDescription, e);
        }
        this.myContext.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    public abstract void cleanup(@NotNull Return var1);

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull InstallOperation<FinalResult, Return> next) {
        if (next == null) {
            InstallOperation.$$$reportNull$$$0(7);
        }
        return new OperationChain(this, next);
    }

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull Function<Return, FinalResult> next) {
        if (next == null) {
            InstallOperation.$$$reportNull$$$0(8);
        }
        return this.then(InstallOperation.wrap(this.myContext, next, 0.0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/InstallOperation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failureDescription";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/InstallOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "promptToRetry";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "then";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FunctionWrapper<Return, Argument>
    extends InstallOperation<Return, Argument> {
        @NotNull
        private final Function<Argument, Return> myRunnable;

        FunctionWrapper(@NotNull InstallContext context, @NotNull Function<Argument, Return> runnable, double progressShare) {
            if (context == null) {
                FunctionWrapper.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                FunctionWrapper.$$$reportNull$$$0(1);
            }
            super(context, progressShare);
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Return perform(@NotNull ProgressIndicator indicator, @NotNull Argument arg) {
            if (indicator == null) {
                FunctionWrapper.$$$reportNull$$$0(2);
            }
            if (arg == null) {
                FunctionWrapper.$$$reportNull$$$0(3);
            }
            indicator.start();
            Object value2 = this.myRunnable.apply(arg);
            assert (value2 != null);
            Object object = value2;
            Object object2 = object;
            if (object2 == null) {
                FunctionWrapper.$$$reportNull$$$0(4);
            }
            return (Return)object2;
            finally {
                indicator.setFraction(1.0);
            }
        }

        @Override
        public void cleanup(@NotNull Return result2) {
            if (result2 == null) {
                FunctionWrapper.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OperationChain<FinalResult, Argument, Return>
    extends InstallOperation<FinalResult, Argument> {
        private final InstallOperation<Return, Argument> myFirst;
        private final InstallOperation<FinalResult, Return> mySecond;

        OperationChain(InstallOperation<Return, Argument> first, InstallOperation<FinalResult, Return> second) {
            super(first.myContext, 0.0);
            this.myFirst = first;
            this.mySecond = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected FinalResult perform(@NotNull ProgressIndicator indicator, @NotNull Argument argument) throws WizardException, InstallationCancelledException {
            if (indicator == null) {
                OperationChain.$$$reportNull$$$0(0);
            }
            if (argument == null) {
                OperationChain.$$$reportNull$$$0(1);
            }
            Return execute = this.myFirst.execute(argument);
            FinalResult FinalResult = this.mySecond.execute(execute);
            FinalResult FinalResult2 = FinalResult;
            if (FinalResult2 == null) {
                OperationChain.$$$reportNull$$$0(2);
            }
            return FinalResult2;
            finally {
                this.myFirst.cleanup(execute);
            }
        }

        @Override
        public void cleanup(@NotNull FinalResult result2) {
            if (result2 == null) {
                OperationChain.$$$reportNull$$$0(3);
            }
            this.mySecond.cleanup(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/install/InstallOperation$OperationChain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/install/InstallOperation$OperationChain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

