/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdk
extends InstallableComponent {
    public AndroidSdk(@NotNull ScopedStateStore store, boolean installUpdates) {
        if (store == null) {
            AndroidSdk.$$$reportNull$$$0(0);
        }
        super(store, "Android SDK", "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.", installUpdates, FileOpUtils.create());
    }

    @Nullable
    private String getLatestCompatibleBuildToolsPath() {
        ProgressIndicatorAdapter progress = new ProgressIndicatorAdapter(){};
        RemotePackage latest = this.mySdkHandler.getLatestRemotePackageForPrefix("build-tools", false, (ProgressIndicator)progress);
        return latest != null ? latest.getPath() : null;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList result2 = Lists.newArrayList();
        result2.add("tools");
        result2.add("platform-tools");
        String buildToolsPath = this.getLatestCompatibleBuildToolsPath();
        if (buildToolsPath != null) {
            result2.add(buildToolsPath);
        }
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            result2.add(repository.getRepositoryLocation(new File(""), false, FileOpUtils.create()).getPath().substring(1).replace(File.separatorChar, ';'));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AndroidSdk.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            AndroidSdk.$$$reportNull$$$0(2);
        }
        if (sdkHandler == null) {
            AndroidSdk.$$$reportNull$$$0(3);
        }
    }

    @Override
    protected boolean isOptionalForSdkLocation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/AndroidSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/AndroidSdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredSdkPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

