/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final int REQUEST_SCALE_DEBOUNCE_TIME_IN_MS = 300;
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myCachedVisibleImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private final ScheduledExecutorService myScheduledExecutorService;
    private final RescaleRunnable myRescaleRunnable;
    @Nullable
    private ScheduledFuture<?> myScheduledFuture;
    private final Rectangle myScreenViewVisibleSize;
    private final Dimension myScreenViewSize;
    private final Rectangle myCachedScreenViewDisplaySize;

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this(screenView, null);
    }

    ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ScheduledExecutorService executor) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        this.myRescaleRunnable = new RescaleRunnable(this::onScaledResultReady);
        this.myScreenViewVisibleSize = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myCachedScreenViewDisplaySize = new Rectangle();
        this.myScreenView = screenView;
        this.myScheduledExecutorService = executor != null ? executor : Executors.newScheduledThreadPool(1);
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage getPreviewImage(@NotNull GraphicsConfiguration configuration, @NotNull BufferedImage renderedImage, int screenViewX, int screenViewY, @NotNull Rectangle screenViewVisibleSize, double xScaleFactor, double yScaleFactor, @Nullable BufferedImage bufferedImage) {
        BufferedImage image;
        void existingBuffer;
        if (configuration == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        if (renderedImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        if (screenViewVisibleSize == null) {
            ScreenViewLayer.$$$reportNull$$$0(4);
        }
        int sx1 = (int)Math.round((double)(screenViewVisibleSize.x - screenViewX) * xScaleFactor);
        int sy1 = (int)Math.round((double)(screenViewVisibleSize.y - screenViewY) * yScaleFactor);
        int sx2 = sx1 + (int)Math.round((double)screenViewVisibleSize.width * xScaleFactor);
        int sy2 = sy1 + (int)Math.round((double)screenViewVisibleSize.height * yScaleFactor);
        if (existingBuffer != null && existingBuffer.getWidth() == screenViewVisibleSize.width && existingBuffer.getHeight() == screenViewVisibleSize.height) {
            image = existingBuffer;
        } else {
            image = configuration.createCompatibleImage(screenViewVisibleSize.width, screenViewVisibleSize.height, 3);
            assert (image != null);
        }
        Graphics2D cacheImageGraphics = image.createGraphics();
        cacheImageGraphics.setRenderingHints(HQ_RENDERING_HINTS);
        cacheImageGraphics.drawImage(renderedImage, 0, 0, image.getWidth(), image.getHeight(), sx1, sy1, sx2, sy2, null);
        cacheImageGraphics.dispose();
        BufferedImage bufferedImage2 = image;
        if (bufferedImage2 == null) {
            ScreenViewLayer.$$$reportNull$$$0(5);
        }
        return bufferedImage2;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        if (graphics2D == null) {
            ScreenViewLayer.$$$reportNull$$$0(6);
        }
        this.myScreenView.getSize(this.myScreenViewSize);
        this.myScreenViewVisibleSize.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.myScreenViewVisibleSize, graphics2D.getClipBounds(), this.myScreenViewVisibleSize);
        if (this.myScreenViewVisibleSize.isEmpty()) {
            return;
        }
        RenderResult renderResult = this.myScreenView.getResult();
        BufferedImage previousVisibleImage = this.myCachedVisibleImage;
        if (this.renderResultHasChanged(renderResult)) {
            this.myLastRenderResult = renderResult;
            this.myCachedVisibleImage = null;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        BufferedImage cachedVisibleImage = this.myCachedVisibleImage;
        if ((cachedVisibleImage == null || !this.myScreenViewVisibleSize.equals(this.myCachedScreenViewDisplaySize)) && this.myLastRenderResult != null && this.myLastRenderResult.hasImage()) {
            BufferedImage renderedImage = this.myLastRenderResult.getRenderedImage().getCopy();
            assert (renderedImage != null) : "Image was already disposed";
            int resultImageWidth = renderedImage.getWidth();
            int resultImageHeight = renderedImage.getHeight();
            this.myCachedScreenViewDisplaySize.setBounds(this.myScreenViewVisibleSize);
            double xScaleFactor = (double)resultImageWidth / (double)this.myScreenViewSize.width;
            double yScaleFactor = (double)resultImageHeight / (double)this.myScreenViewSize.height;
            this.cancelHighQualityScaleRequests();
            if (Math.abs(1.0 - xScaleFactor) > 0.2 && Math.abs(1.0 - yScaleFactor) > 0.2) {
                this.requestHighQualityScaledImage();
            }
            this.myCachedVisibleImage = cachedVisibleImage = ScreenViewLayer.getPreviewImage(g.getDeviceConfiguration(), renderedImage, this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewVisibleSize, xScaleFactor, yScaleFactor, previousVisibleImage);
        }
        if (cachedVisibleImage != null) {
            Shape screenShape = this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g.clip(screenShape);
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)cachedVisibleImage, (int)this.myScreenViewVisibleSize.x, (int)this.myScreenViewVisibleSize.y, null);
        }
        g.dispose();
    }

    private boolean renderResultHasChanged(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.hasImage() && renderResult != this.myLastRenderResult;
    }

    private void cancelHighQualityScaleRequests() {
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(true);
        }
    }

    private void requestHighQualityScaledImage() {
        if (this.myLastRenderResult == null) {
            return;
        }
        ImagePool.Image image = this.myLastRenderResult.getRenderedImage();
        double xScaleFactor = (double)image.getWidth() / (double)this.myScreenViewSize.width;
        double yScaleFactor = (double)image.getHeight() / (double)this.myScreenViewSize.height;
        int sx = (int)Math.round((double)(this.myScreenViewVisibleSize.x - this.myScreenView.getX()) * xScaleFactor);
        int sy = (int)Math.round((double)(this.myScreenViewVisibleSize.y - this.myScreenView.getY()) * yScaleFactor);
        int sw = (int)Math.round((double)this.myScreenViewVisibleSize.width * xScaleFactor);
        int sh = (int)Math.round((double)this.myScreenViewVisibleSize.height * yScaleFactor);
        if (sx + sw > image.getWidth()) {
            sw = image.getWidth() - sx;
        }
        if (sy + sy > image.getHeight()) {
            sh = image.getHeight() - sy;
        }
        if (sw <= 0 || sh <= 0) {
            Logger.getInstance(ScreenViewLayer.class).warn(String.format("requestHighQualityScaledImage with invalid size (sw=%d, sh=%d)", sw, sh));
            return;
        }
        BufferedImage imageCopy = image.getCopy(sx, sy, sw, sh);
        if (imageCopy == null) {
            return;
        }
        this.myRescaleRunnable.setSource(imageCopy, xScaleFactor, yScaleFactor);
        try {
            this.myScheduledFuture = this.myScheduledExecutorService.schedule(this.myRescaleRunnable, 300L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            Logger.getInstance(ScreenViewLayer.class).warn((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myLastRenderResult = null;
        this.myScheduledExecutorService.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull BufferedImage original, double scaleX, double scaleY, boolean bl) {
        void fastScaling;
        if (original == null) {
            ScreenViewLayer.$$$reportNull$$$0(7);
        }
        double xRetinaScale = 2.0 * scaleX;
        double yRetinaScale = 2.0 * scaleY;
        original = fastScaling != false ? ImageUtils.lowQualityFastScale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale) : ImageUtils.scale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale);
        return ImageUtils.convertToRetina((BufferedImage)original);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    static BufferedImage scaleOriginalImage(@NotNull BufferedImage source, double xScaleFactor, double d) {
        void yScaleFactor;
        if (source == null) {
            ScreenViewLayer.$$$reportNull$$$0(8);
        }
        BufferedImage scaledImage = null;
        if (UIUtil.isRetina() && ImageUtils.supportsRetina()) {
            scaledImage = ScreenViewLayer.getRetinaScaledImage(source, 1.0 / xScaleFactor, 1.0 / yScaleFactor, false);
        }
        if (scaledImage == null) {
            scaledImage = ImageUtils.scale((BufferedImage)source, (double)(1.0 / xScaleFactor), (double)(1.0 / yScaleFactor));
        }
        BufferedImage bufferedImage = scaledImage;
        if (bufferedImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(9);
        }
        return bufferedImage;
    }

    private void onScaledResultReady(BufferedImage result2) {
        this.myCachedVisibleImage = result2;
        UIUtil.invokeLaterIfNeeded(() -> this.myScreenView.getSurface().repaint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedImage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenViewVisibleSize";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics2D";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewImage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleOriginalImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewImage";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRetinaScaledImage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scaleOriginalImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RescaleRunnable
    implements Runnable {
        @NotNull
        private final Consumer<BufferedImage> myOnReadyCallback;
        private final Object lock;
        private BufferedImage mySourceImage;
        private double myXScaleFactor;
        private double myYScaleFactor;

        private RescaleRunnable(@NotNull Consumer<BufferedImage> onReadyCallback) {
            if (onReadyCallback == null) {
                RescaleRunnable.$$$reportNull$$$0(0);
            }
            this.lock = new Object();
            this.myOnReadyCallback = onReadyCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void setSource(@NotNull BufferedImage sourceImage, double xScaleFactor, double d) {
            if (sourceImage == null) {
                RescaleRunnable.$$$reportNull$$$0(1);
            }
            Object object = this.lock;
            synchronized (object) {
                void yScaleFactor;
                this.mySourceImage = sourceImage;
                this.myXScaleFactor = xScaleFactor;
                this.myYScaleFactor = yScaleFactor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double yScaleFactor;
            double xScaleFactor;
            BufferedImage source;
            Object object = this.lock;
            synchronized (object) {
                source = this.mySourceImage;
                xScaleFactor = this.myXScaleFactor;
                yScaleFactor = this.myYScaleFactor;
                this.mySourceImage = null;
            }
            if (source == null) {
                return;
            }
            BufferedImage result2 = ScreenViewLayer.scaleOriginalImage(source, xScaleFactor, yScaleFactor);
            this.myOnReadyCallback.accept(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onReadyCallback";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceImage";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer$RescaleRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

