/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsRead;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayerKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/uibuilder/surface/DiagnosticsLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "drawLastRenders", "", "g", "Ljava/awt/Graphics2D;", "lastRenders", "", "", "x", "", "startLine", "getDiagnosticsString", "", "diagnostics", "Lcom/android/tools/idea/common/diagnostics/NlDiagnosticsRead;", "paint", "graphics2D", "intellij.android.designer"})
public final class DiagnosticsLayer
extends Layer {
    @NotNull
    private final DesignSurface surface;

    private final String getDiagnosticsString(NlDiagnosticsRead diagnostics) {
        Runtime runtime = Runtime.getRuntime();
        double freeMemPct = (double)runtime.freeMemory() / (double)runtime.totalMemory() * (double)100;
        Long l = (Long)CollectionsKt.firstOrNull((List)CollectionsKt.takeLast(diagnostics.lastRenders(), (int)1));
        long lastRenderMs = l != null ? l : -1L;
        RenderService renderService = RenderService.getInstance(this.surface.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)renderService, (String)"RenderService.getInstance(surface.project)");
        ImagePool imagePool = renderService.getSharedImagePool();
        Intrinsics.checkExpressionValueIsNotNull((Object)imagePool, (String)"RenderService.getInstanc\u2026.project).sharedImagePool");
        ImagePool.Stats poolStats = imagePool.getStats();
        ImagePool.Stats stats = poolStats;
        ImagePool.Stats stats2 = poolStats;
        ImagePool.Stats stats3 = poolStats;
        ImagePool.Stats stats4 = poolStats;
        return StringsKt.trimMargin$default((String)("\n      |General\n      | Mem avail     " + runtime.freeMemory() / (long)0x100000 + "MB " + DiagnosticsLayerKt.getPCT_FORMAT().format(freeMemPct) + "%\n      | 90% Render    " + DiagnosticsLayerKt.getPCT_FORMAT().format(diagnostics.renderTime(90)) + "ms\n      | Last render   " + DiagnosticsLayerKt.getPCT_FORMAT().format(lastRenderMs) + "ms / " + diagnostics.lastRenderImageSize() / (long)0x100000 + "MB\n      |\n      |Image pool\n      | Allocated     " + (stats != null ? stats.totalBytesAllocated() : -1L) / (long)0x100000 + "MB\n      | In use        " + (stats2 != null ? stats2.totalBytesInUse() : -1L) / (long)0x100000 + "MB\n      | Free          " + ((stats3 != null ? stats3.totalBytesAllocated() : -1L) - (stats4 != null ? stats4.totalBytesInUse() : 0L)) / (long)0x100000 + "MB\n    "), null, (int)1, null);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        Intrinsics.checkParameterIsNotNull((Object)graphics2D, (String)"graphics2D");
        Graphics graphics = graphics2D.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D gc = (Graphics2D)graphics;
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Color color = Color.BLUE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.BLUE");
        GraphicsUtilKt.setColorAndAlpha((Graphics2D)gc, (Color)color);
        gc.setFont((Font)DiagnosticsLayerKt.getFONT());
        Rectangle clipBounds = gc.getClipBounds();
        NlDiagnosticsRead diagnostics = NlDiagnosticsManager.getReadInstance(this.surface);
        int startY = clipBounds.y + 20;
        int startX = clipBounds.x + 20;
        startY += DiagnosticsLayerKt.drawMultilineString(gc, this.getDiagnosticsString(diagnostics), startX, startY);
        this.drawLastRenders(gc, diagnostics.lastRenders(), startX, startY);
        gc.dispose();
    }

    private final void drawLastRenders(Graphics2D g, List<Long> lastRenders, int x, int startLine) {
        g.setColor(DiagnosticsLayerKt.getLAST_RENDER_BACKGROUND());
        g.fillRect(x, startLine, 158, 50);
        int startX = x;
        Iterable $this$forEach$iv = CollectionsKt.takeLast(lastRenders, (int)20);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            g.setColor(DiagnosticsLayerKt.access$colorForRenderTime(it));
            int barLength = Math.min((int)(it / (long)3), 50);
            g.fillRect(startX, startLine + (50 - barLength), 6, barLength);
            startX += 8;
        }
    }

    @NotNull
    public final DesignSurface getSurface() {
        return this.surface;
    }

    public DiagnosticsLayer(@NotNull DesignSurface surface) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)surface), (String)"surface");
        this.surface = surface;
    }
}

