/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessoryPanel
extends JPanel
implements DesignSurfaceListener,
ModelListener {
    private final boolean myHandlesVisibility;
    private NlDesignSurface mySurface;
    private NlModel myModel;
    private AccessoryPanelInterface myCachedPanel;
    private HashMap<NlComponent, AccessoryPanelInterface> myPanels;
    private Type myType;

    public AccessoryPanel(@NotNull Type type, boolean handlesVisibility) {
        if (type == null) {
            AccessoryPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myPanels = new HashMap();
        this.myType = Type.SOUTH_PANEL;
        this.setBorder((Border)JBUI.Borders.empty());
        this.myType = type;
        this.myHandlesVisibility = handlesVisibility;
    }

    public void setSurface(@Nullable NlDesignSurface surface) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
            this.setModel(null);
        }
        this.removeCurrentPanel();
        this.mySurface = surface;
        if (surface == null) {
            this.setModel(null);
        } else {
            this.setModel(this.mySurface.getModel());
            this.mySurface.addListener(this);
        }
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model) {
        if (model == null) {
            AccessoryPanel.$$$reportNull$$$0(1);
        }
        this.updatePanel(model);
        if (this.myCachedPanel != null) {
            this.myCachedPanel.updateAfterModelDerivedDataChanged();
        }
    }

    @Override
    public void modelActivated(@NotNull NlModel model) {
        if (model == null) {
            AccessoryPanel.$$$reportNull$$$0(2);
        }
        this.updatePanel(model);
    }

    private void updatePanel(@NotNull NlModel model) {
        if (model == null) {
            AccessoryPanel.$$$reportNull$$$0(3);
        }
        if (this.mySurface == null) {
            return;
        }
    }

    public void setModel(@Nullable NlModel model) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        if (model != null) {
            model.addListener(this);
        }
        this.myModel = model;
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            AccessoryPanel.$$$reportNull$$$0(4);
        }
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            AccessoryPanel.$$$reportNull$$$0(5);
        }
        if (newSelection == null) {
            AccessoryPanel.$$$reportNull$$$0(6);
        }
        if (newSelection.isEmpty()) {
            this.removeCurrentPanel();
            return;
        }
        NlComponent parent = AccessoryPanel.findSharedParent(newSelection);
        if (parent == null) {
            this.removeCurrentPanel();
            return;
        }
        ViewHandler handler = ViewHandlerManager.get(surface.getProject()).getHandler(parent);
        if (handler instanceof ViewGroupHandler) {
            ViewGroupHandler viewGroupHandler = (ViewGroupHandler)handler;
            if (!viewGroupHandler.needsAccessoryPanel(this.myType)) {
                this.removeCurrentPanel();
                return;
            }
            AccessoryPanelInterface panel2 = this.myPanels.get(parent);
            if (panel2 == null) {
                NlDesignSurface visibilityCallback = this.mySurface;
                panel2 = viewGroupHandler.createAccessoryPanel(surface, this.myType, parent, visibilityCallback);
                this.myPanels.put(parent, panel2);
            }
            if (panel2 != this.myCachedPanel) {
                this.removeCurrentPanel();
                this.myCachedPanel = panel2;
                this.add(this.myCachedPanel.getPanel());
            }
            panel2.updateAccessoryPanelWithSelection(this.myType, newSelection);
            if (this.myHandlesVisibility) {
                this.setVisible(true);
            }
        }
    }

    private void removeCurrentPanel() {
        if (this.myCachedPanel != null) {
            this.remove(this.myCachedPanel.getPanel());
            this.myCachedPanel.deactivate();
            this.myCachedPanel = null;
        }
        if (this.myHandlesVisibility) {
            this.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/AccessoryPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "modelDerivedDataChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "modelActivated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findSharedParent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "componentSelectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        SOUTH_PANEL,
        EAST_PANEL;

    }
}

