/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ResizeBaseTarget
extends BaseTarget {
    protected final Type myType;
    protected final int mySize;
    protected int myStartX1;
    protected int myStartY1;
    protected int myStartX2;
    protected int myStartY2;

    public Type getType() {
        return this.myType;
    }

    public ResizeBaseTarget(@NotNull Type type) {
        if (type == null) {
            ResizeBaseTarget.$$$reportNull$$$0(0);
        }
        this.mySize = JBUIScale.scale((int)2);
        this.myType = type;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio;
        if (sceneTransform == null) {
            ResizeBaseTarget.$$$reportNull$$$0(1);
        }
        if ((ratio = 1.0f / (float)sceneTransform.getScale()) > 2.0f) {
            ratio = 2.0f;
        }
        float size = (float)this.mySize * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)mh + size;
                break;
            }
            case TOP: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)t - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)mh + size;
                break;
            }
            case BOTTOM: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)b - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)b + size;
                break;
            }
            case LEFT_TOP: {
                this.myLeft = (float)l - size;
                this.myTop = (float)t - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)t + size;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = (float)l - size;
                this.myTop = (float)b - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)b + size;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = (float)r - size;
                this.myTop = (float)t - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = (float)r - size;
                this.myTop = (float)b - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)b + size;
            }
        }
        return false;
    }

    @Override
    public Cursor getMouseCursor() {
        switch (this.myType) {
            case LEFT: {
                return Cursor.getPredefinedCursor(10);
            }
            case RIGHT: {
                return Cursor.getPredefinedCursor(11);
            }
            case TOP: {
                return Cursor.getPredefinedCursor(8);
            }
            case BOTTOM: {
                return Cursor.getPredefinedCursor(9);
            }
            case LEFT_TOP: {
                return Cursor.getPredefinedCursor(6);
            }
            case LEFT_BOTTOM: {
                return Cursor.getPredefinedCursor(4);
            }
            case RIGHT_TOP: {
                return Cursor.getPredefinedCursor(7);
            }
            case RIGHT_BOTTOM: {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ResizeBaseTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            ResizeBaseTarget.$$$reportNull$$$0(3);
        }
        if (this.isHittable()) {
            DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver ? 1 : 0);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            ResizeBaseTarget.$$$reportNull$$$0(4);
        }
        if (picker == null) {
            ResizeBaseTarget.$$$reportNull$$$0(5);
        }
        if (this.isHittable()) {
            picker.addRect(this, 0, transform2.getSwingXDip(this.myLeft), transform2.getSwingYDip(this.myTop), transform2.getSwingXDip(this.myRight), transform2.getSwingYDip(this.myBottom));
        }
    }

    @Override
    protected boolean isHittable() {
        SceneComponent component = this.getComponent();
        if (component.getScene().getSelection().size() > 1) {
            return false;
        }
        if (component.isSelected()) {
            if (component.canShowBaseline()) {
                return true;
            }
            return !component.isDragging();
        }
        Scene.FilterType filterType = component.getScene().getFilterType();
        return filterType == Scene.FilterType.RESIZE || filterType == Scene.FilterType.ALL;
    }

    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    @Override
    public int getPreferenceLevel() {
        return 60;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myStartX1 = this.myComponent.getDrawX();
        this.myStartY1 = this.myComponent.getDrawY();
        this.myStartX2 = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
        this.myStartY2 = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ResizeBaseTarget.$$$reportNull$$$0(6);
        }
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ResizeBaseTarget.$$$reportNull$$$0(7);
        }
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(component, "Resize " + StringUtil.getShortName((String)component.getTagName()));
        this.updateAttributes(modification, x, y);
        modification.commit();
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public String getToolTipText() {
        return "Resize View";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/ResizeBaseTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        LEFT,
        LEFT_TOP,
        LEFT_BOTTOM,
        TOP,
        BOTTOM,
        RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

