/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleFilter {
    private final AndroidFacet myFacet;
    private final ResourceResolver myResolver;

    public StyleFilter(@NotNull AndroidFacet facet, @Nullable ResourceResolver resolver) {
        if (facet == null) {
            StyleFilter.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        this.myResolver = resolver;
    }

    public boolean hasWidgetStyles(@NotNull String tagName) {
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(1);
        }
        return !this.getWidgetBaseStyles(tagName).isEmpty();
    }

    public List<StyleResourceValue> getWidgetStyles(@NotNull String tagName) {
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(2);
        }
        return this.findDerivedStyles(this.getWidgetBaseStyles(tagName));
    }

    @NotNull
    public List<StyleResourceValue> getStylesDerivedFrom(@NotNull StyleResourceValue baseStyle) {
        if (baseStyle == null) {
            StyleFilter.$$$reportNull$$$0(3);
        }
        List<StyleResourceValue> list = this.findDerivedStyles(Collections.singletonList(baseStyle));
        if (list == null) {
            StyleFilter.$$$reportNull$$$0(4);
        }
        return list;
    }

    private List<StyleResourceValue> findDerivedStyles(@NotNull List<StyleResourceValue> baseStyles) {
        if (baseStyles == null) {
            StyleFilter.$$$reportNull$$$0(5);
        }
        if (this.myResolver == null) {
            return baseStyles;
        }
        ArrayList<StyleResourceValue> bases = new ArrayList<StyleResourceValue>(baseStyles);
        HashSet<StyleResourceValue> styles2 = new HashSet<StyleResourceValue>();
        while (!bases.isEmpty()) {
            StyleResourceValue base = (StyleResourceValue)bases.remove(bases.size() - 1);
            if (styles2.contains(base)) continue;
            styles2.add(base);
            bases.addAll(this.myResolver.getChildren(base));
        }
        return styles2.stream().filter(this::filter).sorted(Comparator.comparing(ResourceValue::isUserDefined).reversed().thenComparing(ResourceValue::getNamespace).thenComparing(ResourceValue::getName)).collect(Collectors.toList());
    }

    boolean filter(@NotNull StyleResourceValue style) {
        if (style == null) {
            StyleFilter.$$$reportNull$$$0(6);
        }
        if (style.getName().startsWith("Base.") && style.getName().contains(".AppCompat")) {
            return false;
        }
        return ResourceHelper.isAccessibleInXml((ResourceValue)style, this.myFacet);
    }

    @NotNull
    private List<StyleResourceValue> getWidgetBaseStyles(@NotNull String tagName) {
        ViewHandlerManager manager;
        ViewHandler handler;
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(7);
        }
        if ((handler = (manager = ViewHandlerManager.get(this.myFacet.getModule().getProject())).getHandler(tagName)) == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                StyleFilter.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<StyleResourceValue> styles2 = new ArrayList<StyleResourceValue>();
        List<String> possibleNames = handler.getBaseStyles(tagName);
        Map<String, String> prefixMap = handler.getPrefixToNamespaceMap();
        for (String styleName : possibleNames) {
            StyleResourceValue style = this.resolve(styleName, prefixMap);
            if (style == null) continue;
            styles2.add(style);
        }
        ArrayList<StyleResourceValue> arrayList = styles2;
        if (arrayList == null) {
            StyleFilter.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private StyleResourceValue resolve(@NotNull String qualifiedStyleName, @NotNull Map<String, String> prefixMap) {
        if (qualifiedStyleName == null) {
            StyleFilter.$$$reportNull$$$0(10);
        }
        if (prefixMap == null) {
            StyleFilter.$$$reportNull$$$0(11);
        }
        if (this.myResolver == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parseStyleParentReference((String)qualifiedStyleName);
        if (url == null) {
            return null;
        }
        ResourceReference reference2 = url.resolve(ResourceNamespace.ANDROID, prefixMap::get);
        if (reference2 == null) {
            return null;
        }
        return this.myResolver.getStyle(reference2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStyle";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/StyleFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStyles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedStyleName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/StyleFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesDerivedFrom";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetBaseStyles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasWidgetStyles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetStyles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStylesDerivedFrom";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDerivedStyles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetBaseStyles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

