/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.fonts.MoreFontsDialog;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontEnumSupport
extends EnumSupport {
    private ProjectFonts myProjectFonts;

    public FontEnumSupport(@NotNull NlProperty property2) {
        if (property2 == null) {
            FontEnumSupport.$$$reportNull$$$0(0);
        }
        super(property2);
        this.myProjectFonts = new ProjectFonts(this.myProperty.getResolver());
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        ArrayList<ValueWithDisplayString> values2 = new ArrayList<ValueWithDisplayString>();
        List<FontFamily> fonts = this.myProjectFonts.getFonts();
        for (FontFamily font : fonts) {
            values2.add(new ValueWithDisplayString(font.getName(), "@font/" + font.getName()));
        }
        if (!values2.isEmpty()) {
            values2.add(ValueWithDisplayString.SEPARATOR);
        }
        for (String stringValue : AndroidDomUtil.AVAILABLE_FAMILIES) {
            values2.add(new ValueWithDisplayString(stringValue, stringValue));
        }
        AndroidFacet facet = this.myProperty.getModel().getFacet();
        ResourceResolver resolver = this.myProperty.getResolver();
        if (resolver != null) {
            values2.add(ValueWithDisplayString.SEPARATOR);
            values2.add(new ValueWithDisplayString("More Fonts...", null, null, new MoreFontSelector(facet, resolver)));
        }
        ArrayList<ValueWithDisplayString> arrayList = values2;
        if (arrayList == null) {
            FontEnumSupport.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public boolean customizeCellRenderer(@NotNull ColoredListCellRenderer<ValueWithDisplayString> renderer, @NotNull ValueWithDisplayString value2, boolean selected) {
        String fontValue;
        if (renderer == null) {
            FontEnumSupport.$$$reportNull$$$0(2);
        }
        if (value2 == null) {
            FontEnumSupport.$$$reportNull$$$0(3);
        }
        if ((fontValue = value2.getValue()) == null && value2.getValueSelector() == null) {
            fontValue = this.myProperty.resolveValue(null);
        }
        if (fontValue == null) {
            return false;
        }
        FontFamily fontFamily = this.myProjectFonts.getFont(fontValue);
        switch (fontFamily.getFontSource()) {
            case SYSTEM: {
                renderer.setIcon(StudioIcons.Shell.Filetree.ANDROID_PROJECT);
                break;
            }
            case PROJECT: {
                if (fontFamily.getMenu().startsWith("file://")) {
                    renderer.setIcon(StudioIcons.Shell.Filetree.FONT_FILE);
                    break;
                }
                if (fontFamily.getMenu().startsWith("https://")) {
                    renderer.setIcon(StudioIcons.Common.LINK);
                    break;
                }
                renderer.setIcon(AllIcons.General.BalloonError);
                break;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value2, @Nullable String hint) {
        if (resolvedValue == null) {
            FontEnumSupport.$$$reportNull$$$0(4);
        }
        if (value2 != null && !value2.startsWith("@font/") && !AndroidDomUtil.AVAILABLE_FAMILIES.contains(value2)) {
            value2 = "@font/" + value2;
        }
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(resolvedValue, value2);
        if (valueWithDisplayString == null) {
            FontEnumSupport.$$$reportNull$$$0(5);
        }
        return valueWithDisplayString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/FontEnumSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/FontEnumSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromResolvedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromResolvedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MoreFontSelector
    implements ValueWithDisplayString.ValueSelector {
        private final AndroidFacet myFacet;
        private final ResourceResolver myResolver;

        MoreFontSelector(@NotNull AndroidFacet facet, @NotNull ResourceResolver resolver) {
            if (facet == null) {
                MoreFontSelector.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                MoreFontSelector.$$$reportNull$$$0(1);
            }
            this.myFacet = facet;
            this.myResolver = resolver;
        }

        @Override
        @Nullable
        public ValueWithDisplayString selectValue(@Nullable String currentValue) {
            String font;
            MoreFontsDialog dialog = new MoreFontsDialog(this.myFacet, this.myResolver, currentValue);
            dialog.show();
            String string = font = dialog.isOK() ? dialog.getResultingFont() : null;
            if (font == null) {
                return null;
            }
            return new ValueWithDisplayString(StringUtil.trimStart((String)font, (String)"@font/"), font);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolver";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/property/editors/support/FontEnumSupport$MoreFontSelector";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

