/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="palette")
public class Palette {
    public static final Palette EMPTY = new Palette();
    @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
    private final List<BaseItem> myItems = new ArrayList<BaseItem>();
    private final Map<String, Item> myItemsById = new HashMap<String, Item>();

    private Palette() {
    }

    public static Palette parse(@NotNull Reader xmlReader, @NotNull ViewHandlerManager manager) throws JAXBException {
        if (xmlReader == null) {
            Palette.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            Palette.$$$reportNull$$$0(1);
        }
        Palette palette = Palette.unMarshal(xmlReader);
        palette.accept(item -> item.setUp(palette, manager));
        palette.setParentGroups();
        return palette;
    }

    private void setParentGroups() {
        this.accept(new Visitor(){

            @Override
            public void visit(@NotNull Item item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visit(@NotNull Group group) {
                if (group == null) {
                    1.$$$reportNull$$$0(1);
                }
                group.getItems().forEach(item -> item.setParent(group));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/palette/Palette$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public List<BaseItem> getItems() {
        List<BaseItem> list = this.myItems;
        if (list == null) {
            Palette.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Item getItemById(@NotNull String id) {
        if (id == null) {
            Palette.$$$reportNull$$$0(3);
        }
        return this.myItemsById.get(id);
    }

    @NotNull
    public Set<String> getGradleCoordinateIds() {
        HashSet<String> gradleCoordinateIds = new HashSet<String>();
        this.accept(item -> item.addGradleCoordinateId(gradleCoordinateIds));
        HashSet<String> hashSet = gradleCoordinateIds;
        if (hashSet == null) {
            Palette.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static Palette unMarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            Palette.$$$reportNull$$$0(5);
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Palette.class}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            throw new RuntimeException(event.getLinkedException());
        });
        return (Palette)unmarshaller.unmarshal(xmlReader);
    }

    public void accept(@NotNull Visitor visitor) {
        if (visitor == null) {
            Palette.$$$reportNull$$$0(6);
        }
        for (BaseItem item : this.myItems) {
            item.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleCoordinateIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unMarshal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class XmlValuePart {
        @XmlValue
        @Language(value="XML")
        @Nullable
        private String myValue;
        @XmlAttribute(name="reuse")
        private String myReuse;

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        public boolean reuseForDragPreview() {
            return this.myReuse != null && Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myReuse).contains("drag-preview");
        }
    }

    public static class Item
    implements BaseItem {
        @XmlAttribute(required=true, name="tag")
        @NotNull
        private String myTagName;
        @XmlAttribute(name="id")
        @Nullable
        private String myId;
        @XmlAttribute(name="title")
        @Nullable
        private String myTitle;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="coordinate")
        @Nullable
        private String myGradleCoordinateId;
        @XmlAttribute(name="handler-class")
        @Nullable
        private String myHandlerClass;
        @XmlAttribute(name="suggested")
        @Nullable
        private Boolean mySuggested;
        @XmlAttribute(name="meta")
        @Nullable
        private String myMeta;
        @XmlAttribute(name="materialReference")
        @Nullable
        private String myMaterialReference;
        @XmlAttribute(name="info")
        @Nullable
        private String myInfo;
        @XmlElement(name="xml", type=XmlValuePart.class)
        private XmlValuePart myXmlValuePart;
        @Language(value="XML")
        @Nullable
        private String myXml;
        @XmlElement(name="drag-preview")
        @Language(value="XML")
        @Nullable
        private String myDragPreviewXml;
        @Nullable
        private Group myParent;
        private List<String> myMetaTags;
        private PaletteComponentHandler myHandler;

        private Item() {
        }

        public Item(@NotNull String tagName, @NotNull ViewHandler handler) {
            if (tagName == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                Item.$$$reportNull$$$0(1);
            }
            this.myTagName = tagName;
            this.myHandler = handler;
        }

        @NotNull
        public String getTagName() {
            String string = this.myTagName;
            if (string == null) {
                Item.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getId() {
            String string = this.myId != null ? this.myId : this.myTagName;
            if (string == null) {
                Item.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getTitle() {
            if (this.myTitle != null) {
                String string = this.myTitle;
                if (string == null) {
                    Item.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.myHandler.getTitle(this.myTagName);
            if (string == null) {
                Item.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            if (this.myIconName != null && (icon = IconLoader.findIcon((String)this.myIconName, this.getClass())) != null) {
                Icon icon2 = icon;
                if (icon2 == null) {
                    Item.$$$reportNull$$$0(6);
                }
                return icon2;
            }
            Icon icon3 = this.myHandler.getIcon(this.myTagName);
            if (icon3 == null) {
                Item.$$$reportNull$$$0(7);
            }
            return icon3;
        }

        public String getGradleCoordinateId() {
            if (this.myGradleCoordinateId != null) {
                return this.myGradleCoordinateId;
            }
            return this.myHandler.getGradleCoordinateId(this.myTagName);
        }

        public boolean isSuggested() {
            if (this.mySuggested != null) {
                return this.mySuggested;
            }
            return false;
        }

        @NotNull
        public List<String> getMetaTags() {
            List<String> list = this.myMetaTags;
            if (list == null) {
                Item.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Nullable
        public String getMaterialReference() {
            return this.myMaterialReference;
        }

        @Nullable
        public String getInfo() {
            return this.myInfo;
        }

        @NotNull
        @Language(value="XML")
        public String getXml() {
            if (this.myXml != null) {
                String string = this.myXml;
                if (string == null) {
                    Item.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.COMPONENT_CREATION);
            if (string == null) {
                Item.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        @Language(value="XML")
        public String getDragPreviewXml() {
            if (this.myDragPreviewXml != null) {
                String string = this.myDragPreviewXml;
                if (string == null) {
                    Item.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.DRAG_PREVIEW);
            if (string == null) {
                Item.$$$reportNull$$$0(12);
            }
            return string;
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            if (parent == null) {
                Item.$$$reportNull$$$0(13);
            }
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                Item.$$$reportNull$$$0(14);
            }
            visitor.visit(this);
        }

        void setUp(@NotNull Palette palette, @NotNull ViewHandlerManager manager) {
            if (palette == null) {
                Item.$$$reportNull$$$0(15);
            }
            if (manager == null) {
                Item.$$$reportNull$$$0(16);
            }
            this.resolve();
            this.initHandler(manager);
            palette.myItemsById.put(this.getId(), this);
        }

        private void resolve() {
            if (this.myXmlValuePart != null) {
                this.myXml = this.myXmlValuePart.getValue();
                if (this.myDragPreviewXml == null && this.myXmlValuePart.reuseForDragPreview()) {
                    this.myDragPreviewXml = this.myXml;
                }
                this.myXmlValuePart = null;
            }
            if (this.myMetaTags == null) {
                this.myMetaTags = this.myMeta == null || this.myMeta.trim().isEmpty() ? Collections.emptyList() : (this.myMeta.indexOf(44) < 0 ? Collections.singletonList(this.myMeta.trim()) : Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myMeta));
            }
        }

        private void initHandler(@NotNull ViewHandlerManager manager) {
            if (manager == null) {
                Item.$$$reportNull$$$0(17);
            }
            if (this.myHandlerClass != null) {
                try {
                    this.myHandler = (PaletteComponentHandler)Class.forName(this.myHandlerClass).newInstance();
                }
                catch (ReflectiveOperationException exception) {
                    this.myHandler = ViewHandlerManager.NONE;
                }
            } else {
                this.myHandler = manager.getHandlerOrDefault(this.myTagName);
            }
        }

        private void addGradleCoordinateId(@NotNull Set<String> coordinateIds) {
            String coordinateId;
            if (coordinateIds == null) {
                Item.$$$reportNull$$$0(18);
            }
            if (!(coordinateId = this.getGradleCoordinateId()).isEmpty()) {
                coordinateIds.add(coordinateId);
            }
        }

        @NotNull
        public String toString() {
            String string = this.getTitle();
            if (string == null) {
                Item.$$$reportNull$$$0(19);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette$Item";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "palette";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coordinateIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$Item";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTagName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaTags";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getXml";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragPreviewXml";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setUp";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "initHandler";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addGradleCoordinateId";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Group
    implements BaseItem {
        @XmlAttribute(required=true, name="name")
        @NotNull
        private String myName;
        @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
        private List<BaseItem> myItems;
        @Nullable
        private Group myParent;

        private Group() {
            this.myItems = Lists.newArrayList();
        }

        public Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.myItems = Lists.newArrayList();
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<BaseItem> getItems() {
            List<BaseItem> list = this.myItems;
            if (list == null) {
                Group.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public BaseItem getItem(int index) {
            BaseItem baseItem = this.myItems.get(index);
            if (baseItem == null) {
                Group.$$$reportNull$$$0(3);
            }
            return baseItem;
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            if (parent == null) {
                Group.$$$reportNull$$$0(4);
            }
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                Group.$$$reportNull$$$0(5);
            }
            visitor.visit(this);
            for (BaseItem item : this.myItems) {
                item.accept(visitor);
            }
            visitor.visitAfter(this);
        }

        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette$Group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface BaseItem {
        public void accept(@NotNull Visitor var1);

        @Nullable
        public Group getParent();

        public void setParent(@NotNull Group var1);
    }

    public static interface Visitor {
        public void visit(@NotNull Item var1);

        default public void visit(@NotNull Group group) {
            if (group == null) {
                Visitor.$$$reportNull$$$0(0);
            }
        }

        default public void visitAfter(@NotNull Group group) {
            if (group == null) {
                Visitor.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "group";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAfter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

