/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.SelectionLayer;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropTool
extends JPanel
implements MockupEditor.Tool {
    private final MockupEditor myMockupEditor;
    @Nullable
    private Mockup myMockup;
    private final MockupViewPanel.SelectionListener mySelectionListener;
    private boolean myActive;
    private MockupViewPanel myMockupViewPanel;
    private MatchComponentRatio myMatchComponentRatioAction;

    public CropTool(MockupEditor mockupEditor) {
        super(new FlowLayout(2, 3, 1));
        this.myMockupEditor = mockupEditor;
        this.myMockupViewPanel = mockupEditor.getMockupViewPanel();
        this.myMockupEditor.addListener(this::update);
        this.add(this.createCropButton());
        this.update(mockupEditor.getMockup());
        this.mySelectionListener = new MySelectionListener();
    }

    private void update(@Nullable Mockup mockup) {
        this.myMockup = mockup;
        this.setCropLabel(mockup);
    }

    private static void saveSelectionToMockup(@NotNull Rectangle selection, @NotNull Mockup mockup) {
        if (selection == null) {
            CropTool.$$$reportNull$$$0(0);
        }
        if (mockup == null) {
            CropTool.$$$reportNull$$$0(1);
        }
        mockup.setCropping(selection.x, selection.y, selection.width, selection.height);
        MockupFileHelper.writePositionToXML(mockup);
    }

    @NotNull
    private JComponent createCropButton() {
        this.myMatchComponentRatioAction = new MatchComponentRatio();
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ToggleCrop(), this.myMatchComponentRatioAction});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("AndroidDesignerCropTool", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(1);
        JComponent jComponent = actionToolbar.getComponent();
        if (jComponent == null) {
            CropTool.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private void setCropLabel(@Nullable Mockup mockup) {
        if (mockup != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMockupEditor.setSelectionText(mockup.getComputedCropping()));
        }
    }

    @Override
    public void enable(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            CropTool.$$$reportNull$$$0(3);
        }
        this.myActive = true;
        this.myMockupViewPanel.addSelectionListener(this.mySelectionListener);
        this.myMockupViewPanel.setDisplayOnlyCroppedRegion(false);
        this.myMockupViewPanel.setSelectionMode(true);
        this.myMockupViewPanel.setSelectionToMockupCrop();
        this.setCropActionsEnabled(false);
        this.update(mockupEditor.getMockup());
        mockupEditor.addBottomControls(this.createApplyButton());
    }

    @NotNull
    private JComponent createApplyButton() {
        JPanel panel2 = new JPanel();
        JButton apply2 = new JButton("Finish Crop");
        apply2.addActionListener(e -> this.myMockupEditor.disableTool(this));
        panel2.add(new JLabel("<html>Select area to fit inside the selected component</html>"));
        panel2.add(apply2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CropTool.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public void disable(@NotNull MockupEditor mockupEditor) {
        if (mockupEditor == null) {
            CropTool.$$$reportNull$$$0(5);
        }
        this.myActive = false;
        this.setCropActionsEnabled(false);
        this.myMockupViewPanel.removeSelectionListener(this.mySelectionListener);
        this.myMockupViewPanel.resetState();
    }

    private void setCropActionsEnabled(boolean enabled) {
        this.myMatchComponentRatioAction.getTemplatePresentation().setEnabled(enabled);
        this.setSelected(false);
    }

    void setSelected(boolean state) {
        if (this.myMockup == null) {
            return;
        }
        NlComponent component = this.myMockup.getComponent();
        SelectionLayer selectionLayer = this.myMockupViewPanel.getSelectionLayer();
        selectionLayer.setFixedRatio(state);
        if (state) {
            selectionLayer.setAspectRatio(NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component));
            CropTool.saveSelectionToMockup(selectionLayer.getSelection(), this.myMockup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/tools/CropTool";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockupEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/CropTool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCropButton";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createApplyButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveSelectionToMockup";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySelectionListener
    implements MockupViewPanel.SelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void selectionStarted(MockupViewPanel mockupViewPanel, int x, int y) {
        }

        @Override
        public void selectionEnded(MockupViewPanel mockupViewPanel, Rectangle selection) {
            if (CropTool.this.myMockup != null) {
                CropTool.saveSelectionToMockup(selection, CropTool.this.myMockup);
            }
        }
    }

    private class MatchComponentRatio
    extends ToggleAction {
        public static final String TITLE = "Match component ratio";

        MatchComponentRatio() {
            super(TITLE, TITLE, AndroidIcons.Mockup.MatchWidget);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MatchComponentRatio.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(CropTool.this.myActive && CropTool.this.myMockup != null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MatchComponentRatio.$$$reportNull$$$0(1);
            }
            return CropTool.this.myActive && CropTool.this.myMockupViewPanel != null && CropTool.this.myMockupViewPanel.getSelectionLayer().isFixedRatio();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MatchComponentRatio.$$$reportNull$$$0(2);
            }
            CropTool.this.setSelected(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/CropTool$MatchComponentRatio";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleCrop
    extends ToggleAction {
        ToggleCrop() {
            this.getTemplatePresentation().setIcon(AndroidIcons.Mockup.Crop);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleCrop.$$$reportNull$$$0(0);
            }
            return CropTool.this.myActive;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleCrop.$$$reportNull$$$0(1);
            }
            if (state) {
                CropTool.this.myMockupEditor.enableTool(CropTool.this);
            } else {
                CropTool.this.myMockupEditor.disableTool(CropTool.this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/CropTool$ToggleCrop";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

