/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.TriData;
import java.text.DecimalFormat;

public class Rasterize {
    public static final int BLUE = 0x5599FF;
    public static final int GRAY = 0x101010;
    private static DecimalFormat df = new DecimalFormat("       #####0.000;             -####0.000");

    private static final int min(int x1, int x2, int x3) {
        return x1 > x2 ? (x2 > x3 ? x3 : x2) : (x1 > x3 ? x3 : x1);
    }

    private static final int max(int x1, int x2, int x3) {
        return x1 < x2 ? (x2 < x3 ? x3 : x2) : (x1 < x3 ? x3 : x1);
    }

    public static void triangle(float[] zbuff, int w, int h, float fx3, float fy3, float fz3, float fx2, float fy2, float fz2, float fx1, float fy1, float fz1) {
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            return;
        }
        double d = fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1;
        if (d == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                if (CX1 > 0 && CX2 > 0 && CX3 > 0) {
                    zbuff[x + off] = p + dx * (float)x;
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void triangleZBuffMin(float[] zbuff, int w, int h, float fx3, float fy3, float fz3, float fx2, float fy2, float fz2, float fx1, float fy1, float fz1) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] > (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void render_perspectiveAffine(float[] zbuff, int[] rgb, int w, int h, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, float fx3, float fy3, float fz3, float tx1, float ty1, float tx2, float ty2, float tx3, float ty3, int[] texture, int tWidth, int tHeight, double[] matrix) {
        if (!((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f)) {
            return;
        }
        float tmpx = fx1;
        float tmpy = fy1;
        float tmpz = fz1;
        fx1 = fx2;
        fy1 = fy2;
        fz1 = fz2;
        fx2 = tmpx;
        fy2 = tmpy;
        fz2 = tmpz;
        tmpx = tx1;
        tmpy = ty1;
        tx1 = tx2;
        ty1 = ty2;
        tx2 = tmpx;
        ty2 = tmpy;
        double d = fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1;
        if (d == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        float diffuse = 1.0f;
        float dx12 = fx1 - fx2;
        float dy12 = fy1 - fy2;
        float dz12 = fz1 - fz2;
        float dx13 = fx1 - fx3;
        float dy13 = fy1 - fy3;
        float dz13 = fz1 - fz3;
        float normal_x = dy12 * dz13 - dy13 * dz12;
        float normal_y = dz12 * dx13 - dz13 * dx12;
        float normal_z = dx12 * dy13 - dx13 * dy12;
        float norm = normal_x * normal_x + normal_y * normal_y + normal_z * normal_z;
        diffuse = -(normal_z = (float)((double)normal_z / Math.sqrt(norm)));
        if (diffuse < 0.0f) {
            diffuse = 0.0f;
        }
        diffuse = (diffuse + 1.0f) / 2.0f;
        float dsx1 = fx1 - fx2;
        float dsx2 = fx2 - fx3;
        float dsx3 = fx3 - fx1;
        float dsy1 = fy1 - fy2;
        float dsy2 = fy2 - fy3;
        float dsy3 = fy3 - fy1;
        float dtx1 = tx1 - tx2;
        float dtx2 = tx2 - tx3;
        float dtx3 = tx3 - tx3;
        float dty1 = ty1 - ty2;
        float dty2 = ty2 - ty3;
        float dty3 = ty3 - ty3;
        float d12 = dsx1 * dsy2 - dsx2 * dsy1;
        float d23 = dsx2 * dsy3 - dsx3 * dsy2;
        float d31 = dsx3 * dsy1 - dsx1 * dsy3;
        float delta = d12;
        float dtx_dsx = (dsy2 * dtx1 - dsy1 * dtx2) / delta;
        float dtx_dsy = (dsx1 * dtx2 - dsx2 * dtx1) / delta;
        float dty_dsx = (dsy2 * dty1 - dsy1 * dty2) / delta;
        float dty_dsy = (dsx1 * dty2 - dsx2 * dty1) / delta;
        float txoff = tx1 - dtx_dsx * fx1 - dtx_dsy * fy1;
        float tyoff = ty1 - dty_dsx * fx1 - dty_dsy * fy1;
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            float tx_yoff = dtx_dsy * (float)y + txoff;
            float ty_yoff = dty_dsy * (float)y + tyoff;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] > (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                    int tx = Rasterize.clamp((int)(tx_yoff + dtx_dsx * (float)x), tWidth - 1);
                    int ty = Rasterize.clamp((int)(ty_yoff + dty_dsx * (float)x), tHeight - 1);
                    try {
                        rgb[point] = Rasterize.shade(texture[tx + ty * tWidth], diffuse);
                    }
                    catch (Exception e) {
                        System.err.println(" " + tx + ", " + ty);
                    }
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void render_perspective(float[] zbuff, int[] rgb, int w, int h, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, float fx3, float fy3, float fz3, float tx1, float ty1, float tx2, float ty2, float tx3, float ty3, int[] texture, int tWidth, int tHeight, double[] matrix) {
        float dtz12;
        if (!((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f)) {
            return;
        }
        float tmpx = fx1;
        float tmpy = fy1;
        float tmpz = fz1;
        fx1 = fx2;
        fy1 = fy2;
        fz1 = fz2;
        fx2 = tmpx;
        fy2 = tmpy;
        fz2 = tmpz;
        tmpx = tx1;
        tmpy = ty1;
        tx1 = tx2;
        ty1 = ty2;
        tx2 = tmpx;
        ty2 = tmpy;
        double d = fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1;
        if (d == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        float diffuse = 1.0f;
        float dx12 = fx1 - fx2;
        float dy12 = fy1 - fy2;
        float dz12 = fz1 - fz2;
        float dx13 = fx1 - fx3;
        float dy13 = fy1 - fy3;
        float dz13 = fz1 - fz3;
        float normal_x = dy12 * dz13 - dy13 * dz12;
        float normal_y = dz12 * dx13 - dz13 * dx12;
        float normal_z = dx12 * dy13 - dx13 * dy12;
        float norm = normal_x * normal_x + normal_y * normal_y + normal_z * normal_z;
        diffuse = -(normal_z = (float)((double)normal_z / Math.sqrt(norm)));
        if (diffuse < 0.0f) {
            diffuse = 0.0f;
        }
        diffuse = (diffuse + 1.0f) / 2.0f;
        float dsx1 = fx1 - fx2;
        float dsx2 = fx2 - fx3;
        float dsx3 = fx3 - fx1;
        float dsy1 = fy1 - fy2;
        float dsy2 = fy2 - fy3;
        float dsy3 = fy3 - fy1;
        float dtx1 = tx1 - tx2;
        float dtx2 = tx2 - tx3;
        float dtx3 = tx3 - tx3;
        float dty1 = ty1 - ty2;
        float dty2 = ty2 - ty3;
        float dty3 = ty3 - ty3;
        float d12 = dsx1 * dsy2 - dsx2 * dsy1;
        float d23 = dsx2 * dsy3 - dsx3 * dsy2;
        float d31 = dsx3 * dsy1 - dsx1 * dsy3;
        float dz1 = 1.0f / fz1 - 1.0f / fz2;
        float dz2 = 1.0f / fz2 - 1.0f / fz3;
        float dz3 = 1.0f / fz3 - 1.0f / fz1;
        float dtxz2 = tx2 / fz2 - tx3 / fz3;
        float dtxz1 = tx1 / fz1 - tx2 / fz2;
        float dtxz3 = tx3 / fz3 - tx1 / fz1;
        float dtyz1 = ty1 / fz1 - ty2 / fz2;
        float dtyz2 = ty2 / fz2 - ty3 / fz3;
        float dtyz3 = ty3 / fz3 - ty1 / fz1;
        float deltatz = dtz12 = dtxz1 * dtyz2 - dtxz2 * dtyz1;
        float dz_dsx = dz1 / dsx1;
        float dz_dsy = dz1 / dsy1;
        float dtx_dsx = (dsy2 * dtxz1 - dsy1 * dtxz2) / deltatz;
        float dtx_dsy = (dsx1 * dtxz2 - dsx2 * dtxz1) / deltatz;
        float dty_dsx = (dsy2 * dtyz1 - dsy1 * dtyz2) / deltatz;
        float dty_dsy = (dsx1 * dtyz2 - dsx2 * dtyz1) / deltatz;
        float delta = d12;
        float txoff = tx1 - dtx_dsx * fx1 - dtx_dsy * fy1;
        float tyoff = ty1 - dty_dsx * fx1 - dty_dsy * fy1;
        float off1_z = 1.0f / fz1 - dz_dsx * fx1 - dz_dsy * fy1;
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            float tx_yoff = dtx_dsy * (float)y + txoff;
            float ty_yoff = dty_dsy * (float)y + tyoff;
            float t_z_yoff = dz_dsy * (float)y + off1_z;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] > (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                    int tx = Rasterize.clamp((int)((tx_yoff + dtx_dsx * (float)x) / (t_z_yoff + dz_dsx * (float)x)), tWidth - 1);
                    int ty = Rasterize.clamp((int)((ty_yoff + dty_dsx * (float)x) / (t_z_yoff + dz_dsx * (float)x)), tHeight - 1);
                    try {
                        rgb[point] = Rasterize.shade(texture[tx + ty * tWidth], diffuse);
                    }
                    catch (Exception e) {
                        System.err.println(" " + tx + ", " + ty);
                    }
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void render(float[] zbuff, int[] rgb, int w, int h, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, float fx3, float fy3, float fz3, float tx1, float ty1, float tx2, float ty2, float tx3, float ty3, int[] texture, int tWidth, int tHeight, double[] matrix) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
            tmpx = tx1;
            tmpy = ty1;
            tx1 = tx2;
            ty1 = ty2;
            tx2 = tmpx;
            ty2 = tmpy;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        float diffuse = 1.0f;
        float dx12 = fx1 - fx2;
        float dy12 = fy1 - fy2;
        float dz12 = fz1 - fz2;
        float dx13 = fx1 - fx3;
        float dy13 = fy1 - fy3;
        float dz13 = fz1 - fz3;
        float normal_x = dy12 * dz13 - dy13 * dz12;
        float normal_y = dz12 * dx13 - dz13 * dx12;
        float normal_z = dx12 * dy13 - dx13 * dy12;
        float norm = normal_x * normal_x + normal_y * normal_y + normal_z * normal_z;
        diffuse = -(normal_z = (float)((double)normal_z / Math.sqrt(norm)));
        if (diffuse < 0.0f) {
            diffuse = 0.0f;
        }
        diffuse = (diffuse + 1.0f) / 2.0f;
        float dtx_dsx = (float)matrix[0];
        float dtx_dsy = (float)matrix[1];
        float dtx_dsz = (float)matrix[2];
        float dty_dsx = (float)matrix[4];
        float dty_dsy = (float)matrix[5];
        float dty_dsz = (float)matrix[6];
        float txoff = tx1 - dtx_dsx * fx1 - dtx_dsy * fy1 - dtx_dsz * fz1;
        float tyoff = ty1 - dty_dsx * fx1 - dty_dsy * fy1 - dty_dsz * fz1;
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            float tx_yoff = dtx_dsy * (float)y + txoff;
            float ty_yoff = dty_dsy * (float)y + tyoff;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] > (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                    int tx = Rasterize.clamp((int)(tx_yoff + dtx_dsx * (float)x + dtx_dsz * zval), tWidth - 1);
                    int ty = Rasterize.clamp((int)(ty_yoff + dty_dsx * (float)x + dty_dsz * zval), tHeight - 1);
                    try {
                        rgb[point] = Rasterize.shade(texture[tx + ty * tWidth], diffuse);
                    }
                    catch (Exception e) {
                        System.err.println(" " + tx + ", " + ty);
                    }
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void flat(float[] zbuff, int[] rgb, int w, int h, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, float fx3, float fy3, float fz3, int color) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        float diffuse = 1.0f;
        float dx12 = fx1 - fx2;
        float dy12 = fy1 - fy2;
        float dz12 = fz1 - fz2;
        float dx13 = fx1 - fx3;
        float dy13 = fy1 - fy3;
        float dz13 = fz1 - fz3;
        float normal_x = dy12 * dz13 - dy13 * dz12;
        float normal_y = dz12 * dx13 - dz13 * dx12;
        float normal_z = dx12 * dy13 - dx13 * dy12;
        float norm = normal_x * normal_x + normal_y * normal_y + normal_z * normal_z;
        diffuse = -(normal_z = (float)((double)normal_z / Math.sqrt(norm)));
        if (diffuse < 0.0f) {
            diffuse = 0.0f;
        }
        diffuse = (diffuse + 1.0f) / 2.0f;
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] > (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                    rgb[point] = Rasterize.shade(color, diffuse);
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    private static int shade(int texture, float diffuse) {
        int b = texture & 0xFF;
        int g = texture >> 8 & 0xFF;
        int r = texture >> 16 & 0xFF;
        r = (int)((float)r * diffuse);
        g = (int)((float)g * diffuse);
        b = (int)((float)b * diffuse);
        return r << 16 | g << 8 | b;
    }

    private static int clamp(int c, int N) {
        c &= ~(c >> 31);
        c -= N;
        c &= c >> 31;
        return c += N;
    }

    public static void triangleZBuffMax(float[] zbuff, int w, int h, float fx3, float fy3, float fz3, float fx2, float fy2, float fz2, float fx1, float fy1, float fz1) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                float zval;
                int point;
                if (CX1 > 0 && CX2 > 0 && CX3 > 0 && zbuff[point = x + off] < (zval = p + dx * (float)x)) {
                    zbuff[point] = zval;
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void triangleZBuffMinMax(float[] minz, float[] maxz, int w, int h, float fx3, float fy3, float fz3, float fx2, float fy2, float fz2, float fx1, float fy1, float fz1) {
        double d;
        if ((fx1 - fx2) * (fy3 - fy2) - (fy1 - fy2) * (fx3 - fx2) < 0.0f) {
            float tmpx = fx1;
            float tmpy = fy1;
            float tmpz = fz1;
            fx1 = fx2;
            fy1 = fy2;
            fz1 = fz2;
            fx2 = tmpx;
            fy2 = tmpy;
            fz2 = tmpz;
        }
        if ((d = (double)(fx1 * (fy3 - fy2) - fx2 * fy3 + fx3 * fy2 + (fx2 - fx3) * fy1)) == 0.0) {
            return;
        }
        float dx = (float)((double)(-(fy1 * (fz3 - fz2) - fy2 * fz3 + fy3 * fz2 + (fy2 - fy3) * fz1)) / d);
        float dy = (float)((double)(fx1 * (fz3 - fz2) - fx2 * fz3 + fx3 * fz2 + (fx2 - fx3) * fz1) / d);
        float zoff = (float)((double)(fx1 * (fy3 * fz2 - fy2 * fz3) + fy1 * (fx2 * fz3 - fx3 * fz2) + (fx3 * fy2 - fx2 * fy3) * fz1) / d);
        int Y1 = (int)(16.0f * fy1 + 0.5f);
        int Y2 = (int)(16.0f * fy2 + 0.5f);
        int Y3 = (int)(16.0f * fy3 + 0.5f);
        int X1 = (int)(16.0f * fx1 + 0.5f);
        int X2 = (int)(16.0f * fx2 + 0.5f);
        int X3 = (int)(16.0f * fx3 + 0.5f);
        int DX12 = X1 - X2;
        int DX23 = X2 - X3;
        int DX31 = X3 - X1;
        int DY12 = Y1 - Y2;
        int DY23 = Y2 - Y3;
        int DY31 = Y3 - Y1;
        int FDX12 = DX12 << 4;
        int FDX23 = DX23 << 4;
        int FDX31 = DX31 << 4;
        int FDY12 = DY12 << 4;
        int FDY23 = DY23 << 4;
        int FDY31 = DY31 << 4;
        int minx = Rasterize.min(X1, X2, X3) + 15 >> 4;
        int maxx = Rasterize.max(X1, X2, X3) + 15 >> 4;
        int miny = Rasterize.min(Y1, Y2, Y3) + 15 >> 4;
        int maxy = Rasterize.max(Y1, Y2, Y3) + 15 >> 4;
        if (miny < 0) {
            miny = 0;
        }
        if (minx < 0) {
            minx = 0;
        }
        if (maxx > w) {
            maxx = w;
        }
        if (maxy > h) {
            maxy = h;
        }
        int off = miny * w;
        int C1 = DY12 * X1 - DX12 * Y1;
        int C2 = DY23 * X2 - DX23 * Y2;
        int C3 = DY31 * X3 - DX31 * Y3;
        if (DY12 < 0 || DY12 == 0 && DX12 > 0) {
            ++C1;
        }
        if (DY23 < 0 || DY23 == 0 && DX23 > 0) {
            ++C2;
        }
        if (DY31 < 0 || DY31 == 0 && DX31 > 0) {
            ++C3;
        }
        int CY1 = C1 + DX12 * (miny << 4) - DY12 * (minx << 4);
        int CY2 = C2 + DX23 * (miny << 4) - DY23 * (minx << 4);
        int CY3 = C3 + DX31 * (miny << 4) - DY31 * (minx << 4);
        for (int y = miny; y < maxy; ++y) {
            int CX1 = CY1;
            int CX2 = CY2;
            int CX3 = CY3;
            float p = zoff + dy * (float)y;
            for (int x = minx; x < maxx; ++x) {
                if (CX1 > 0 && CX2 > 0 && CX3 > 0) {
                    int point = x + off;
                    float zval = p + dx * (float)x;
                    if (minz[point] > zval) {
                        minz[point] = zval;
                    }
                    if (maxz[point] < zval) {
                        maxz[point] = zval;
                    }
                }
                CX1 -= FDY12;
                CX2 -= FDY23;
                CX3 -= FDY31;
            }
            CY1 += FDX12;
            CY2 += FDX23;
            CY3 += FDX31;
            off += w;
        }
    }

    public static void toZBuffMinMax(float[] minz, float[] maxz, int w, int h, TriData tri) {
        for (int i2 = 0; i2 < tri.myIndex.length; i2 += 3) {
            int p1 = tri.myIndex[i2];
            int p2 = tri.myIndex[i2 + 1];
            int p3 = tri.myIndex[i2 + 2];
            Rasterize.triangleZBuffMinMax(minz, maxz, w, h, tri.myVert[p1], tri.myVert[p1 + 1], tri.myVert[p1 + 2], tri.myVert[p2], tri.myVert[p2 + 1], tri.myVert[p2 + 2], tri.myVert[p3], tri.myVert[p3 + 1], tri.myVert[p3 + 2]);
        }
    }

    public static void toZBuff(float[] zbuff, int w, int h, TriData tri) {
        for (int i2 = 0; i2 < tri.myIndex.length; i2 += 3) {
            int p1 = tri.myIndex[i2];
            int p2 = tri.myIndex[i2 + 1];
            int p3 = tri.myIndex[i2 + 2];
            Rasterize.triangleZBuffMin(zbuff, w, h, tri.myVert[p1], tri.myVert[p1 + 1], tri.myVert[p1 + 2], tri.myVert[p2], tri.myVert[p2 + 1], tri.myVert[p2 + 2], tri.myVert[p3], tri.myVert[p3 + 1], tri.myVert[p3 + 2]);
        }
    }

    public static void toZBuff(float[] zbuff, int[] rgb, int w, int h, TriData tri, int[] texture, int tWidth, int tHeight, double[] matrix) {
        for (int i2 = 0; i2 < tri.myIndex.length; i2 += 3) {
            int p1 = tri.myIndex[i2];
            int p2 = tri.myIndex[i2 + 1];
            int p3 = tri.myIndex[i2 + 2];
            int type = tri.mySurfaceType[i2 / 3];
            if (type == 1) {
                Rasterize.render_perspectiveAffine(zbuff, rgb, w, h, tri.myVert[p1], tri.myVert[p1 + 1], tri.myVert[p1 + 2], tri.myVert[p2], tri.myVert[p2 + 1], tri.myVert[p2 + 2], tri.myVert[p3], tri.myVert[p3 + 1], tri.myVert[p3 + 2], tri.myTexture_uv[p1], tri.myTexture_uv[p1 + 1], tri.myTexture_uv[p2], tri.myTexture_uv[p2 + 1], tri.myTexture_uv[p3], tri.myTexture_uv[p3 + 1], texture, tWidth, tHeight, matrix);
                continue;
            }
            Rasterize.flat(zbuff, rgb, w, h, tri.myVert[p1], tri.myVert[p1 + 1], tri.myVert[p1 + 2], tri.myVert[p2], tri.myVert[p2 + 1], tri.myVert[p2 + 2], tri.myVert[p3], tri.myVert[p3 + 1], tri.myVert[p3 + 2], type == 0 ? 0x5599FF : 0x101010);
        }
    }

    public static void simple(float[] zbuff, int[] rgb, int w, int h, TriData tri) {
        for (int i2 = 0; i2 < tri.myIndex.length; i2 += 3) {
            int p1 = tri.myIndex[i2];
            int p2 = tri.myIndex[i2 + 1];
            int p3 = tri.myIndex[i2 + 2];
            int type = tri.mySurfaceType != null ? tri.mySurfaceType[i2 / 3] : 0;
            Rasterize.flat(zbuff, rgb, w, h, tri.myVert[p1], tri.myVert[p1 + 1], tri.myVert[p1 + 2], tri.myVert[p2], tri.myVert[p2 + 1], tri.myVert[p2 + 2], tri.myVert[p3], tri.myVert[p3 + 1], tri.myVert[p3 + 2], type == 0 ? 0x5599FF : 0x101010);
        }
    }

    private static String toString(float ... x) {
        String ret = null;
        for (int i2 = 0; i2 < x.length; ++i2) {
            float v = x[i2];
            String s = df.format(v);
            ret = ret == null ? s.substring(s.length() - 9) : ret + "," + s.substring(s.length() - 9);
        }
        return ret;
    }
}

