/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layeredimage;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayersTree
extends Tree {
    private DefaultMutableTreeNode myRoot;

    LayersTree() {
        this.configure();
        DefaultTreeModel model = new DefaultTreeModel(null);
        this.setModel(model);
    }

    void setImage(@Nullable Image image) {
        this.myRoot = new DefaultMutableTreeNode("Layers");
        if (image != null) {
            LayersTree.addLayers(this.myRoot, image.getLayers());
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.setRoot(this.myRoot);
        model.reload();
        this.expandAllRows();
    }

    private static void addLayers(@NotNull DefaultMutableTreeNode root, @NotNull List<Layer> layers) {
        if (root == null) {
            LayersTree.$$$reportNull$$$0(0);
        }
        if (layers == null) {
            LayersTree.$$$reportNull$$$0(1);
        }
        for (Layer layer : layers) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(layer);
            if (layer.getType() == Layer.Type.GROUP) {
                LayersTree.addLayers(node, layer.getChildren());
            }
            root.add(node);
        }
    }

    private void configure() {
        this.createCellRenderer();
        this.getSelectionModel().setSelectionMode(1);
        this.setToggleClickCount(2);
        TreeUtil.installActions((JTree)((Object)this));
    }

    private void expandAllRows() {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getPathForRow(i2).getLastPathComponent();
            if (node == this.myRoot) {
                this.expandRow(i2);
                continue;
            }
            Layer layer = (Layer)node.getUserObject();
            if (layer.getType() != Layer.Type.GROUP || !layer.isOpen()) continue;
            this.expandRow(i2);
        }
        this.setRootVisible(false);
    }

    private void createCellRenderer() {
        LayerTreeCellRenderer renderer = new LayerTreeCellRenderer();
        renderer.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        this.setCellRenderer((TreeCellRenderer)((Object)renderer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "layers";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/layeredimage/LayersTree";
        objectArray[2] = "addLayers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LayerTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Composite mAlphaComposite = AlphaComposite.getInstance(3, 0.5f);
        private boolean mVisible;

        private LayerTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object content;
            if (tree == null) {
                LayerTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((content = (node = (DefaultMutableTreeNode)value2).getUserObject()) instanceof Layer) {
                Layer layer = (Layer)content;
                this.append(layer.getName());
                switch (layer.getType()) {
                    case ADJUSTMENT: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.SEEK_BAR);
                        break;
                    }
                    case IMAGE: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.IMAGE_VIEW);
                        break;
                    }
                    case GROUP: {
                        this.setIcon(AllIcons.Nodes.Folder);
                        break;
                    }
                    case SHAPE: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.TEXTURE_VIEW);
                        break;
                    }
                    case TEXT: {
                        this.setIcon(StudioIcons.LayoutEditor.Palette.TEXT_VIEW);
                    }
                }
                this.mVisible = layer.isVisible();
            }
        }

        protected void doPaint(Graphics2D g) {
            Composite old = g.getComposite();
            if (!this.mVisible) {
                g.setComposite(this.mAlphaComposite);
            }
            super.doPaint(g);
            if (!this.mVisible) {
                g.setComposite(old);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/layeredimage/LayersTree$LayerTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

