/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TimeLineRows
extends JPanel
implements Gantt.ChartElement {
    private static final boolean DEBUG = false;
    Color myBackground = Chart.ourAvgBackground;
    Chart myChart;
    int[] myXPoints = new int[10];
    int[] myYPoints = new int[10];
    ArrayList<ViewRow> myViewRows = new ArrayList();
    public static int ourDiamondSize = JBUIScale.scale((int)10);
    private boolean myInStateChange;
    private boolean myDisplayInstructions = true;
    static int ourBaseSelected = Chart.ourMySelectedLineColor.getRGB() & 0xFFFFFF | 0x77000000;
    static Color ourTransparent = new Color(ourBaseSelected & 0xFFFFFF, true);
    static Color ourLightColor = new Color(ourBaseSelected, true);
    JComponent mySpacer = new JComponent(){};

    TimeLineRows(Chart chart) {
        VerticalFlowLayout layout2 = new VerticalFlowLayout(0, 0, 0, true, false);
        this.setLayout((LayoutManager)layout2);
        layout2.setHorizontalFill(true);
        layout2.setVerticalFill(false);
        this.myChart = chart;
        this.update(Gantt.ChartElement.Reason.CONSTRUCTION);
        this.myChart.add(this);
    }

    @Override
    public void update(Gantt.ChartElement.Reason reason) {
        if (reason == Gantt.ChartElement.Reason.SELECTION_CHANGED) {
            return;
        }
        if (reason == Gantt.ChartElement.Reason.CURSOR_POSITION_CHANGED) {
            this.repaint();
            return;
        }
        if (reason == Gantt.ChartElement.Reason.RESIZE || reason == Gantt.ChartElement.Reason.ZOOM || reason == Gantt.ChartElement.Reason.ADDVIEW) {
            Dimension d = this.getPreferredSize();
            d.width = this.myChart.getGraphWidth();
            if (this.myChart.getmNumberOfViews() > 0) {
                Gantt.ViewElement v = this.myChart.myViewElements.get(this.myChart.getmNumberOfViews() - 1);
                d.height = v.myYStart + v.myHeight + 1;
            }
            if (reason != Gantt.ChartElement.Reason.ADDVIEW && this.myViewRows.size() == this.myChart.myViewElements.size()) {
                int chartWidth = this.myChart.getGraphWidth();
                for (ViewRow row : this.myViewRows) {
                    int pos = row.myRow;
                    Gantt.ViewElement v = this.myChart.myViewElements.get(pos);
                    Dimension dimension2 = row.getPreferredSize();
                    if (dimension2.width == chartWidth && dimension2.height == v.myHeight) continue;
                    row.setPreferredSize(new Dimension(chartWidth, v.myHeight));
                }
                this.revalidate();
                this.repaint();
            } else {
                for (ViewRow row : this.myViewRows) {
                    this.remove(row);
                }
                this.myViewRows.clear();
                this.remove(this.mySpacer);
                int chartWidth = this.myChart.getGraphWidth();
                for (int i2 = 0; i2 < this.myChart.myViewElements.size(); ++i2) {
                    Gantt.ViewElement v = this.myChart.myViewElements.get(i2);
                    ViewRow vr = new ViewRow(v, i2);
                    this.myViewRows.add(vr);
                    vr.setPreferredSize(new Dimension(chartWidth, v.myHeight));
                    this.add(vr);
                }
                this.myDisplayInstructions = false;
                if (this.myChart != null && this.myChart.myModel != null && (this.myChart.myModel.getStartConstraintSet().myConstraintViews.isEmpty() || this.myChart.myModel.getEndConstraintSet().myConstraintViews.isEmpty())) {
                    this.myDisplayInstructions = true;
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!Float.isNaN(this.myChart.getTimeCursorMs())) {
            int x = this.myChart.getCursorPosition();
            g.setColor(Chart.getColorForPosition(this.myChart.getFramePosition()));
            g.fillRect(x, 0, 1, this.getHeight());
        }
        if (this.myDisplayInstructions) {
            g.setColor(Chart.myGridColor);
            int w = this.getWidth();
            int h = this.getHeight();
            String str = "Please add Constraints at 0% and 100%";
            Rectangle2D b = g.getFontMetrics().getStringBounds(str, g);
            g.drawString(str, (w - (int)b.getWidth()) / 2, (h - (int)b.getHeight()) / 2);
        }
    }

    private void paintBorder(Graphics g, int width, int height) {
        g.setColor(this.myBackground);
        g.fillRect(0, 0, width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.paintBorder(g, width, height);
    }

    class ViewRow
    extends JPanel {
        final Gantt.ViewElement myViewElement;
        LocationTable myLocationTable = new LocationTable();
        int myRow;
        boolean myRowHasMarks = false;

        public ViewRow(Gantt.ViewElement v, int row) {
            this.myViewElement = v;
            this.myRow = row;
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ViewRow.this.select(e.getX(), e.getY());
                }
            };
            this.addMouseMotionListener(ml);
            this.addMouseListener(ml);
        }

        private void select(int x, int y) {
            MotionSceneModel.KeyFrame keyFrame = this.myLocationTable.find(x, y, 20);
            if (keyFrame != TimeLineRows.this.myChart.mySelectedKeyFrame) {
                TimeLineRows.this.myChart.mySelectedKeyFrame = keyFrame;
                TimeLineRows.this.myChart.mySelectedKeyView = keyFrame.target;
                TimeLineRows.this.myChart.mySelection = Chart.Selection.KEY;
                TimeLineRows.this.myChart.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
                if (keyFrame != null) {
                    float position = (float)keyFrame.getFramePosition() / 100.0f;
                    TimeLineRows.this.myChart.setCursorPosition(position);
                }
            } else {
                int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
                int fp = (x - TimeLineRows.this.myChart.myChartLeftInset) * 100 / width;
                if (fp < 0) {
                    fp = 0;
                } else if (fp > 100) {
                    fp = 100;
                }
                TimeLineRows.this.myChart.setCursorPosition((float)fp / 100.0f);
            }
        }

        public void drawBowtie(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos + half - 1;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos;
            TimeLineRows.this.myXPoints[2] = x + half;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x;
            TimeLineRows.this.myYPoints[3] = pos + half + 1;
            TimeLineRows.this.myXPoints[4] = x - half;
            TimeLineRows.this.myYPoints[4] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[5] = x - half;
            TimeLineRows.this.myYPoints[5] = pos;
            if (selected) {
                g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 6);
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, ourTransparent, x, 0.0f, ourLightColor);
                ((Graphics2D)g).setPaint(paint);
                TimeLineRows.this.myXPoints[0] = 0;
                TimeLineRows.this.myYPoints[0] = pos;
                TimeLineRows.this.myXPoints[1] = 0;
                TimeLineRows.this.myYPoints[1] = pos + ourDiamondSize;
                TimeLineRows.this.myXPoints[2] = x - half;
                TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
                TimeLineRows.this.myXPoints[3] = x - half;
                TimeLineRows.this.myYPoints[3] = pos;
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 6);
            }
        }

        public void drawDiamond(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + half;
            TimeLineRows.this.myXPoints[2] = x;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x - half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            if (selected) {
                g.drawPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            } else {
                g.fillPolygon(TimeLineRows.this.myXPoints, TimeLineRows.this.myYPoints, 4);
            }
        }

        public void drawCircle(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            if (selected) {
                g.drawRoundRect(x - half, pos, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            } else {
                g.fillRoundRect(x - half, pos, ourDiamondSize, ourDiamondSize, ourDiamondSize, ourDiamondSize);
            }
        }

        public void drawSquare(Graphics g, boolean selected, int x, int pos) {
            int half = ourDiamondSize / 2;
            TimeLineRows.this.myXPoints[0] = x;
            TimeLineRows.this.myYPoints[0] = pos;
            TimeLineRows.this.myXPoints[1] = x + half;
            TimeLineRows.this.myYPoints[1] = pos + half;
            TimeLineRows.this.myXPoints[2] = x;
            TimeLineRows.this.myYPoints[2] = pos + ourDiamondSize;
            TimeLineRows.this.myXPoints[3] = x - half;
            TimeLineRows.this.myYPoints[3] = pos + half;
            if (selected) {
                g.drawRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, 2, 2);
            } else {
                g.fillRoundRect(x - half, pos - half, ourDiamondSize, ourDiamondSize, 2, 2);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myRow % 2 == 0) {
                g.setColor(Chart.ourPrimaryPanelBackground);
            } else {
                g.setColor(Chart.ourSecondaryPanelBackground);
            }
            this.myLocationTable.clear();
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.myRow % 2 == 1) {
                g.setColor(Chart.ourPrimaryPanelBackground);
            } else {
                g.setColor(Chart.ourSecondaryPanelBackground);
            }
            g.setColor(Chart.ourBorder);
            for (int i2 = 0; i2 < TimeLineRows.this.myChart.myXTickCount; ++i2) {
                int xLines = TimeLineRows.this.myChart.myXTicksPixels[i2];
                g.fillRect(xLines, 0, 1, panelHeight);
            }
            boolean DRAW_RECTS = false;
            g.setColor(Color.GRAY);
            int y = 0;
            this.myRowHasMarks = false;
            y += this.myViewElement.myHeightView;
            if (this.myViewElement.myHeightPosition > 0) {
                y += this.myViewElement.myHeightPosition;
            }
            if (this.myViewElement.myHeightAttribute > 0) {
                y += this.myViewElement.myHeightAttribute;
            }
            if (this.myViewElement.myHeightCycle > 0) {
                y += this.myViewElement.myHeightCycle;
            }
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            int pos = 2;
            if (TimeLineRows.this.myChart != null) {
                int x;
                int xpos;
                int width = this.getWidth() - TimeLineRows.this.myChart.myChartLeftInset - TimeLineRows.this.myChart.myChartRightInset;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Chart.myUnSelectedLineColor);
                if (TimeLineRows.this.myChart.myModel != null && TimeLineRows.this.myChart.myModel.getStartConstraintSet() != null && TimeLineRows.this.myChart.myModel.getStartConstraintSet().myConstraintViews != null && TimeLineRows.this.myChart.myModel.getStartConstraintSet().myConstraintViews.get(this.myViewElement.myName) != null) {
                    xpos = TimeLineRows.this.myChart.myChartLeftInset + 0 * width / 100;
                    this.drawSquare(g, false, xpos, pos + ourDiamondSize);
                    this.myRowHasMarks = true;
                }
                if (TimeLineRows.this.myChart.myModel != null && TimeLineRows.this.myChart.myModel.getEndConstraintSet() != null && TimeLineRows.this.myChart.myModel.getEndConstraintSet().myConstraintViews != null && TimeLineRows.this.myChart.myModel.getEndConstraintSet().myConstraintViews.get(this.myViewElement.myName) != null) {
                    xpos = TimeLineRows.this.myChart.myChartLeftInset + 100 * width / 100;
                    this.drawSquare(g, false, xpos, pos + ourDiamondSize);
                    this.myRowHasMarks = true;
                }
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyAttributes.isEmpty();
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyCycles.isEmpty();
                this.myRowHasMarks |= !this.myViewElement.mKeyFrames.myKeyPositions.isEmpty();
                pos = this.myViewElement.myHeightPosition > 0 ? this.myViewElement.myHeightView + (this.myViewElement.myHeightPosition - ourDiamondSize) / 2 : (this.myViewElement.myHeightView - ourDiamondSize) / 2;
                for (MotionSceneModel.KeyPos keyPos : this.myViewElement.mKeyFrames.myKeyPositions) {
                    int x2 = TimeLineRows.this.myChart.myChartLeftInset + keyPos.framePosition * width / 100;
                    if (keyPos == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawDiamond(g, true, x2, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawDiamond(g, false, x2, pos);
                    }
                    this.myLocationTable.add(x2, pos, keyPos);
                }
                int delta_y = (this.getHeight() - ourDiamondSize) / 4;
                if (this.myViewElement.myHeightAttribute > 0) {
                    pos = this.myViewElement.myHeightView + this.myViewElement.myHeightPosition;
                    pos += (this.myViewElement.myHeightAttribute - ourDiamondSize) / 2;
                } else {
                    pos += delta_y;
                }
                for (MotionSceneModel.KeyAttributes key : this.myViewElement.mKeyFrames.myKeyAttributes) {
                    x = TimeLineRows.this.myChart.myChartLeftInset + key.framePosition * width / 100;
                    if (key == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawCircle(g, true, x, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawCircle(g, false, x, pos);
                    }
                    this.myLocationTable.add(x, pos, key);
                }
                if (this.myViewElement.myHeightCycle > 0) {
                    pos = this.myViewElement.myHeightView + this.myViewElement.myHeightPosition + this.myViewElement.myHeightAttribute;
                    pos += (this.myViewElement.myHeightCycle - ourDiamondSize) / 2;
                } else {
                    pos += delta_y;
                }
                for (MotionSceneModel.KeyCycle key : this.myViewElement.mKeyFrames.myKeyCycles) {
                    x = TimeLineRows.this.myChart.myChartLeftInset + key.framePosition * width / 100;
                    if (key == TimeLineRows.this.myChart.mySelectedKeyFrame) {
                        g.setColor(Chart.ourMySelectedLineColor);
                        this.drawBowtie(g, true, x, pos);
                        g.setColor(Chart.myUnSelectedLineColor);
                    } else {
                        this.drawBowtie(g, false, x, pos);
                    }
                    this.myLocationTable.add(x, pos, key);
                }
                int n = TimeLineRows.this.myChart.getCursorPosition();
                g2d.setStroke(stroke);
                Chart cfr_ignored_0 = TimeLineRows.this.myChart;
                g.setColor(Chart.getColorForPosition(TimeLineRows.this.myChart.getFramePosition()));
                g.fillRect(n, 0, 1, panelHeight);
            }
        }
    }

    static class LocationTable {
        int max = 10;
        int[] location = new int[this.max * 2];
        MotionSceneModel.KeyFrame[] keyFrames = new MotionSceneModel.KeyFrame[this.max];
        int addPoint = 0;

        LocationTable() {
        }

        public void clear() {
            this.addPoint = 0;
        }

        void add(int x, int y, MotionSceneModel.KeyFrame keyFrame) {
            if (this.max == this.addPoint) {
                this.max *= 2;
                this.location = Arrays.copyOf(this.location, this.max * 2);
                this.keyFrames = Arrays.copyOf(this.keyFrames, this.max);
            }
            this.location[this.addPoint * 2] = x;
            this.location[this.addPoint * 2 + 1] = y;
            this.keyFrames[this.addPoint] = keyFrame;
            ++this.addPoint;
        }

        MotionSceneModel.KeyFrame find(int x, int y, int max) {
            int closeSq = Integer.MAX_VALUE;
            MotionSceneModel.KeyFrame keyFrame = null;
            int maxSq = max * max;
            for (int i2 = 0; i2 < this.keyFrames.length; ++i2) {
                int kf_x = this.location[i2 * 2];
                int kf_y = this.location[i2 * 2 + 1];
                int dx = Math.abs(kf_x - x);
                if ((dx *= dx) > maxSq) continue;
                int dy = Math.abs(kf_y - y);
                if ((dy *= dy) > maxSq || closeSq <= dy + dx) continue;
                keyFrame = this.keyFrames[i2];
                closeSq = dy + dx;
            }
            return keyFrame;
        }
    }
}

