/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MotionSceneStatusPanel
extends JPanel {
    private final MotionLayoutAttributePanel myBasePanel;
    private final JBLabel myLdAttribute = new JBLabel("MotionScene:", 2);
    private final JBLabel myLdName = new JBLabel("foo", 2);
    private final JBLabel myTransitionLabel = new JBLabel("Transition:", 2);
    private final ComboBox myTransitionMenu = new ComboBox();
    ArrayList<MotionSceneModel.TransitionTag> myTransitions;
    static JBColor ourAttributeColor = new JBColor(255, 0xAFAFAF);
    static JBColor ourValueColor = new JBColor(32768, 5472078);
    private MotionSceneModel myModel;

    public MotionSceneStatusPanel(MotionLayoutAttributePanel basePanel) {
        this.setLayout(new GridBagLayout());
        this.myBasePanel = basePanel;
        this.setLayout(new GridBagLayout());
        this.setBackground((Color)EditorUtils.ourMainBackground);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setAttributeLook(this.myLdAttribute);
        this.setValueLook((JLabel)this.myLdName);
        this.myLdAttribute.setForeground((Color)EditorUtils.ourNameColor);
        this.myLdAttribute.setAlignmentX(0.0f);
        this.myLdAttribute.setFont(this.myLdAttribute.getFont().deriveFont(1));
        this.myLdAttribute.setBorder(JBUI.Borders.empty((int)4));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        this.add((Component)this.myLdAttribute, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.add((Component)this.myLdName, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.myTransitionLabel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)this.myTransitionMenu, gbc);
        this.myTransitionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotionSceneStatusPanel.this.myTransitions.get(MotionSceneStatusPanel.this.myTransitionMenu.getSelectedIndex());
            }
        });
    }

    private void setAttributeLook(JBLabel label) {
        label.setForeground((Color)EditorUtils.ourNameColor);
        label.setAlignmentX(0.0f);
        label.setFont(this.myLdAttribute.getFont().deriveFont(1));
        label.setBorder(JBUI.Borders.empty((int)4));
    }

    private void setValueLook(JLabel label) {
        label.setForeground((Color)EditorUtils.ourValueColor);
        label.setAlignmentX(0.0f);
        label.setFont(this.myLdAttribute.getFont().deriveFont(1));
        label.setBorder(JBUI.Borders.empty((int)4));
    }

    public void setModel(MotionSceneModel model) {
        this.myModel = model;
        String name = this.myModel.getName();
        name = name.substring(0, name.lastIndexOf(".xml"));
        this.myLdName.setText(name);
        this.myTransitionMenu.removeAllItems();
        this.myTransitions = model.getTransitions();
        for (MotionSceneModel.TransitionTag transitionTag : this.myTransitions) {
            MotionSceneModel.ConstraintSet csStart = transitionTag.getConstraintSetStart();
            MotionSceneModel.ConstraintSet csEnd = transitionTag.getConstraintSetEnd();
            String sid = csStart == null ? "[none]" : this.strip(csStart.getId());
            String eid = csEnd == null ? "" : this.strip(csEnd.getId());
            this.myTransitionMenu.addItem((Object)(sid + " - " + eid));
        }
    }

    private String strip(String s) {
        return s.substring(s.indexOf(47) + 1);
    }
}

