/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearDragTarget
extends DragBaseTarget {
    private final LinearLayoutHandler myHandler;
    private final boolean myIsDragFromPalette;
    private LinearSeparatorTarget myClosest;
    private boolean myDragHandled;

    public LinearDragTarget(@NotNull LinearLayoutHandler handler) {
        if (handler == null) {
            LinearDragTarget.$$$reportNull$$$0(0);
        }
        this(handler, false);
    }

    public LinearDragTarget(@NotNull LinearLayoutHandler handler, boolean fromPalette) {
        if (handler == null) {
            LinearDragTarget.$$$reportNull$$$0(1);
        }
        this.myHandler = handler;
        this.myIsDragFromPalette = fromPalette;
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            LinearDragTarget.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        this.myHandler.setDragging(this.myComponent, true);
        ((LayoutlibSceneManager)parent.getScene().getSceneManager()).addTargets(this.myComponent);
        parent.updateTargets();
        this.myDragHandled = false;
        super.mouseDown(x, y);
        this.myComponent.setModelUpdateAuthorized(false);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        Target closestTarget;
        if (closestTargets == null) {
            LinearDragTarget.$$$reportNull$$$0(3);
        }
        SceneComponent sceneParent = this.myComponent.getParent();
        assert (sceneParent != null);
        this.myComponent.setDragging(true);
        TargetSnapper snapper = this.getTargetNotchSnapper();
        x -= this.myOffsetX;
        y -= this.myOffsetY;
        if (this.myHandler.isVertical(sceneParent.getNlComponent())) {
            int middle = this.myComponent.getDrawHeight() / 2;
            int parentHeight = sceneParent.getDrawHeight();
            int nx = this.myIsDragFromPalette ? x : this.myComponent.getDrawX();
            int ny = Math.min(Math.max(y, -middle), parentHeight + middle);
            ny = snapper.trySnapVertical(ny).orElse(ny);
            this.myComponent.setPosition(nx, ny, false);
            closestTarget = snapper.getSnappedVerticalTarget();
        } else {
            int middle = this.myComponent.getDrawWidth() / 2;
            int parentWidth = sceneParent.getDrawWidth();
            int nx = Math.min(Math.max(x, -middle), parentWidth + middle);
            nx = snapper.trySnapHorizontal(nx).orElse(nx);
            int ny = this.myIsDragFromPalette ? y : this.myComponent.getDrawY();
            this.myComponent.setPosition(nx, ny, false);
            closestTarget = snapper.getSnappedHorizontalTarget();
        }
        if (this.myClosest != closestTarget) {
            if (this.myClosest != null) {
                this.myClosest.setHighlight(false);
            }
            if (closestTarget != null && closestTarget instanceof LinearSeparatorTarget) {
                this.myClosest = (LinearSeparatorTarget)closestTarget;
                this.myClosest.setHighlight(true, this.myComponent.getDrawWidth(), this.myComponent.getDrawHeight());
            } else {
                this.myClosest = null;
            }
        }
        this.myComponent.getScene().repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTarget) {
        if (closestTarget == null) {
            LinearDragTarget.$$$reportNull$$$0(4);
        }
        super.mouseRelease(x, y, closestTarget);
        this.myComponent.setModelUpdateAuthorized(true);
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.updateTargets();
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
            if (!LinearLayoutHandler.insertComponentAtTarget(this.myComponent, this.myClosest)) {
                this.myComponent.getScene().needsLayout(2);
                return;
            }
            this.myDragHandled = true;
        } else {
            this.myComponent.getScene().needsLayout(2);
        }
    }

    public boolean isDragHandled() {
        return this.myDragHandled;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.myHandler.setDragging(this.myComponent, false);
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
        }
    }

    @Nullable
    public LinearSeparatorTarget getClosest() {
        return this.myClosest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTarget";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/targets/LinearDragTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

